/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.std;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.data.IAWriter;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputSinkPushRuntime;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import java.io.PrintStream;
import java.nio.ByteBuffer;

public class SinkWriterRuntime
extends AbstractOneInputSinkPushRuntime {
    private final IHyracksTaskContext ctx;
    private final PrintStream printStream;
    private final IAWriter writer;
    private RecordDescriptor inputRecordDesc;
    private FrameTupleAccessor tAccess;
    private boolean autoClose = false;
    private boolean first = true;

    public SinkWriterRuntime(IAWriter writer, IHyracksTaskContext ctx, PrintStream printStream, RecordDescriptor inputRecordDesc) {
        this.writer = writer;
        this.ctx = ctx;
        this.printStream = printStream;
        this.inputRecordDesc = inputRecordDesc;
        this.tAccess = new FrameTupleAccessor(ctx.getFrameSize(), inputRecordDesc);
    }

    public SinkWriterRuntime(IAWriter writer, IHyracksTaskContext ctx, PrintStream printStream, RecordDescriptor inputRecordDesc, boolean autoClose) {
        this(writer, ctx, printStream, inputRecordDesc);
        this.autoClose = autoClose;
    }

    public void open() throws HyracksDataException {
        if (this.first) {
            this.first = false;
            this.tAccess = new FrameTupleAccessor(this.ctx.getFrameSize(), this.inputRecordDesc);
            try {
                this.writer.init();
            }
            catch (AlgebricksException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.tAccess.reset(buffer);
        int nTuple = this.tAccess.getTupleCount();
        for (int t = 0; t < nTuple; ++t) {
            try {
                this.writer.printTuple((IFrameTupleAccessor)this.tAccess, t);
                continue;
            }
            catch (AlgebricksException ae) {
                throw new HyracksDataException((Throwable)ae);
            }
        }
    }

    public void close() throws HyracksDataException {
        if (this.autoClose) {
            this.printStream.close();
        }
    }

    @Override
    public void setInputRecordDescriptor(int index, RecordDescriptor recordDescriptor) {
        this.inputRecordDesc = recordDescriptor;
    }

    public void fail() throws HyracksDataException {
    }
}

