/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.std;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IRunningAggregateEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IRunningAggregateEvaluatorFactory;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class RunningAggregateRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private int[] outColumns;
    private IRunningAggregateEvaluatorFactory[] runningAggregates;

    public RunningAggregateRuntimeFactory(int[] outColumns, IRunningAggregateEvaluatorFactory[] runningAggregates, int[] projectionList) {
        super(projectionList);
        this.outColumns = outColumns;
        this.runningAggregates = runningAggregates;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("running-aggregate [");
        for (i = 0; i < this.outColumns.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.outColumns[i]);
        }
        sb.append("] := [");
        for (i = 0; i < this.runningAggregates.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.runningAggregates[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public AbstractOneInputOneOutputOneFramePushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) throws AlgebricksException {
        final int[] projectionToOutColumns = new int[this.projectionList.length];
        for (int j = 0; j < this.projectionList.length; ++j) {
            projectionToOutColumns[j] = Arrays.binarySearch(this.outColumns, this.projectionList[j]);
        }
        return new AbstractOneInputOneOutputOneFramePushRuntime(){
            private IPointable p = VoidPointable.FACTORY.createPointable();
            private IRunningAggregateEvaluator[] raggs = new IRunningAggregateEvaluator[RunningAggregateRuntimeFactory.access$000(RunningAggregateRuntimeFactory.this).length];
            private ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(RunningAggregateRuntimeFactory.access$100(RunningAggregateRuntimeFactory.this).length);
            private boolean first = true;

            public void open() throws HyracksDataException {
                if (!this.first) {
                    FrameUtils.flushFrame((ByteBuffer)this.frame, (IFrameWriter)this.writer);
                    this.appender.reset(this.frame, true);
                }
                this.initAccessAppendRef(ctx);
                if (this.first) {
                    this.first = false;
                    int n = RunningAggregateRuntimeFactory.this.runningAggregates.length;
                    for (int i = 0; i < n; ++i) {
                        try {
                            this.raggs[i] = RunningAggregateRuntimeFactory.this.runningAggregates[i].createRunningAggregateEvaluator();
                            continue;
                        }
                        catch (AlgebricksException ae) {
                            throw new HyracksDataException((Throwable)ae);
                        }
                    }
                }
                for (int i = 0; i < RunningAggregateRuntimeFactory.this.runningAggregates.length; ++i) {
                    try {
                        this.raggs[i].init();
                        continue;
                    }
                    catch (AlgebricksException ae) {
                        throw new HyracksDataException((Throwable)ae);
                    }
                }
                this.writer.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.tAccess.reset(buffer);
                int nTuple = this.tAccess.getTupleCount();
                for (int t = 0; t < nTuple; ++t) {
                    this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
                    this.produceTuple(this.tupleBuilder, (IFrameTupleAccessor)this.tAccess, t, this.tRef);
                    this.appendToFrameFromTupleBuilder(this.tupleBuilder);
                }
            }

            private void produceTuple(ArrayTupleBuilder tb, IFrameTupleAccessor accessor, int tIndex, FrameTupleReference tupleRef) throws HyracksDataException {
                tb.reset();
                for (int f = 0; f < RunningAggregateRuntimeFactory.this.projectionList.length; ++f) {
                    int k = projectionToOutColumns[f];
                    if (k >= 0) {
                        try {
                            this.raggs[k].step((IFrameTupleReference)tupleRef, this.p);
                        }
                        catch (AlgebricksException e) {
                            throw new HyracksDataException((Throwable)e);
                        }
                        tb.addField(this.p.getByteArray(), this.p.getStartOffset(), this.p.getLength());
                        continue;
                    }
                    tb.addField(accessor, tIndex, RunningAggregateRuntimeFactory.this.projectionList[f]);
                }
            }
        };
    }

    static /* synthetic */ int[] access$100(RunningAggregateRuntimeFactory x0) {
        return x0.projectionList;
    }
}

