/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.std;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.data.IBinaryBooleanInspector;
import edu.uci.ics.hyracks.algebricks.runtime.base.ICopyEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.ICopyEvaluatorFactory;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.data.std.api.IDataOutputProvider;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputOperatorNodePushable;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class PartitioningSplitOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    public static int NO_DEFAULT_BRANCH = -1;
    private final ICopyEvaluatorFactory[] evalFactories;
    private final IBinaryBooleanInspector boolInspector;
    private final int defaultBranchIndex;

    public PartitioningSplitOperatorDescriptor(IOperatorDescriptorRegistry spec, ICopyEvaluatorFactory[] evalFactories, IBinaryBooleanInspector boolInspector, int defaultBranchIndex, RecordDescriptor rDesc) {
        super(spec, 1, defaultBranchIndex == evalFactories.length ? evalFactories.length + 1 : evalFactories.length);
        for (int i = 0; i < evalFactories.length; ++i) {
            this.recordDescriptors[i] = rDesc;
        }
        this.evalFactories = evalFactories;
        this.boolInspector = boolInspector;
        this.defaultBranchIndex = defaultBranchIndex;
    }

    public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, final IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        return new AbstractUnaryInputOperatorNodePushable(){
            private final IFrameWriter[] writers;
            private final ByteBuffer[] writeBuffers;
            private final ICopyEvaluator[] evals;
            private final ArrayBackedValueStorage evalBuf;
            private final RecordDescriptor inOutRecDesc;
            private final FrameTupleAccessor accessor;
            private final FrameTupleReference frameTuple;
            private final FrameTupleAppender tupleAppender;
            private final ArrayTupleBuilder tupleBuilder;
            private final DataOutput tupleDos;
            {
                this.writers = new IFrameWriter[PartitioningSplitOperatorDescriptor.this.outputArity];
                this.writeBuffers = new ByteBuffer[PartitioningSplitOperatorDescriptor.this.outputArity];
                this.evals = new ICopyEvaluator[PartitioningSplitOperatorDescriptor.this.outputArity];
                this.evalBuf = new ArrayBackedValueStorage();
                this.inOutRecDesc = recordDescProvider.getInputRecordDescriptor(PartitioningSplitOperatorDescriptor.this.getActivityId(), 0);
                this.accessor = new FrameTupleAccessor(ctx.getFrameSize(), this.inOutRecDesc);
                this.frameTuple = new FrameTupleReference();
                this.tupleAppender = new FrameTupleAppender(ctx.getFrameSize());
                this.tupleBuilder = new ArrayTupleBuilder(this.inOutRecDesc.getFieldCount());
                this.tupleDos = this.tupleBuilder.getDataOutput();
            }

            public void close() throws HyracksDataException {
                for (int i = 0; i < PartitioningSplitOperatorDescriptor.this.outputArity; ++i) {
                    this.tupleAppender.reset(this.writeBuffers[i], false);
                    if (this.tupleAppender.getTupleCount() > 0) {
                        FrameUtils.flushFrame((ByteBuffer)this.writeBuffers[i], (IFrameWriter)this.writers[i]);
                    }
                    this.writers[i].close();
                }
            }

            public void fail() throws HyracksDataException {
                for (IFrameWriter writer : this.writers) {
                    writer.fail();
                }
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.accessor.reset(buffer);
                int tupleCount = this.accessor.getTupleCount();
                for (int i = 0; i < tupleCount; ++i) {
                    this.frameTuple.reset((IFrameTupleAccessor)this.accessor, i);
                    boolean found = false;
                    for (int j = 0; j < this.evals.length; ++j) {
                        try {
                            this.evalBuf.reset();
                            this.evals[j].evaluate((IFrameTupleReference)this.frameTuple);
                        }
                        catch (AlgebricksException e) {
                            throw new HyracksDataException((Throwable)e);
                        }
                        found = PartitioningSplitOperatorDescriptor.this.boolInspector.getBooleanValue(this.evalBuf.getByteArray(), 0, 1);
                        if (!found) continue;
                        this.copyAndAppendTuple(j);
                        break;
                    }
                    if (found || PartitioningSplitOperatorDescriptor.this.defaultBranchIndex == NO_DEFAULT_BRANCH) continue;
                    this.copyAndAppendTuple(PartitioningSplitOperatorDescriptor.this.defaultBranchIndex);
                }
            }

            private void copyAndAppendTuple(int outputIndex) throws HyracksDataException {
                try {
                    this.tupleBuilder.reset();
                    for (int i = 0; i < this.frameTuple.getFieldCount(); ++i) {
                        this.tupleDos.write(this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i));
                        this.tupleBuilder.addFieldEndOffset();
                    }
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
                this.tupleAppender.reset(this.writeBuffers[outputIndex], false);
                if (!this.tupleAppender.append(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray(), 0, this.tupleBuilder.getSize())) {
                    FrameUtils.flushFrame((ByteBuffer)this.writeBuffers[outputIndex], (IFrameWriter)this.writers[outputIndex]);
                    this.tupleAppender.reset(this.writeBuffers[outputIndex], true);
                    if (!this.tupleAppender.append(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray(), 0, this.tupleBuilder.getSize())) {
                        throw new IllegalStateException();
                    }
                }
            }

            public void open() throws HyracksDataException {
                int i;
                for (IFrameWriter writer : this.writers) {
                    writer.open();
                }
                for (i = 0; i < PartitioningSplitOperatorDescriptor.this.outputArity; ++i) {
                    this.writeBuffers[i] = ctx.allocateFrame();
                    this.tupleAppender.reset(this.writeBuffers[i], true);
                }
                try {
                    for (i = 0; i < PartitioningSplitOperatorDescriptor.this.evalFactories.length; ++i) {
                        this.evals[i] = PartitioningSplitOperatorDescriptor.this.evalFactories[i].createEvaluator((IDataOutputProvider)this.evalBuf);
                    }
                }
                catch (AlgebricksException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }

            public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) {
                this.writers[index] = writer;
            }
        };
    }
}

