/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.std;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class AssignRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private int[] outColumns;
    private IScalarEvaluatorFactory[] evalFactories;
    private final boolean flushFramesRapidly;

    public AssignRuntimeFactory(int[] outColumns, IScalarEvaluatorFactory[] evalFactories, int[] projectionList) {
        this(outColumns, evalFactories, projectionList, false);
    }

    public AssignRuntimeFactory(int[] outColumns, IScalarEvaluatorFactory[] evalFactories, int[] projectionList, boolean flushFramesRapidly) {
        super(projectionList);
        this.outColumns = outColumns;
        this.evalFactories = evalFactories;
        this.flushFramesRapidly = flushFramesRapidly;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("assign [");
        for (i = 0; i < this.outColumns.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.outColumns[i]);
        }
        sb.append("] := [");
        for (i = 0; i < this.evalFactories.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.evalFactories[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public AbstractOneInputOneOutputOneFramePushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) throws AlgebricksException {
        final int[] projectionToOutColumns = new int[this.projectionList.length];
        for (int j = 0; j < this.projectionList.length; ++j) {
            projectionToOutColumns[j] = Arrays.binarySearch(this.outColumns, this.projectionList[j]);
        }
        return new AbstractOneInputOneOutputOneFramePushRuntime(){
            private IPointable result = VoidPointable.FACTORY.createPointable();
            private IScalarEvaluator[] eval = new IScalarEvaluator[AssignRuntimeFactory.access$000(AssignRuntimeFactory.this).length];
            private ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(AssignRuntimeFactory.access$100(AssignRuntimeFactory.this).length);
            private boolean first = true;

            public void open() throws HyracksDataException {
                if (this.first) {
                    this.initAccessAppendRef(ctx);
                    this.first = false;
                    int n = AssignRuntimeFactory.this.evalFactories.length;
                    for (int i = 0; i < n; ++i) {
                        try {
                            this.eval[i] = AssignRuntimeFactory.this.evalFactories[i].createScalarEvaluator(ctx);
                            continue;
                        }
                        catch (AlgebricksException ae) {
                            throw new HyracksDataException((Throwable)ae);
                        }
                    }
                }
                this.writer.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                int t;
                this.tAccess.reset(buffer);
                int nTuple = this.tAccess.getTupleCount();
                if (nTuple > 1) {
                    for (t = 0; t < nTuple - 1; ++t) {
                        this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
                        this.produceTuple(this.tupleBuilder, (IFrameTupleAccessor)this.tAccess, t, this.tRef);
                        this.appendToFrameFromTupleBuilder(this.tupleBuilder);
                    }
                }
                this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
                this.produceTuple(this.tupleBuilder, (IFrameTupleAccessor)this.tAccess, t, this.tRef);
                if (AssignRuntimeFactory.this.flushFramesRapidly) {
                    this.appendToFrameFromTupleBuilder(this.tupleBuilder, true);
                } else {
                    this.appendToFrameFromTupleBuilder(this.tupleBuilder);
                }
            }

            private void produceTuple(ArrayTupleBuilder tb, IFrameTupleAccessor accessor, int tIndex, FrameTupleReference tupleRef) throws HyracksDataException {
                tb.reset();
                for (int f = 0; f < AssignRuntimeFactory.this.projectionList.length; ++f) {
                    int k = projectionToOutColumns[f];
                    if (k >= 0) {
                        try {
                            this.eval[k].evaluate((IFrameTupleReference)tupleRef, this.result);
                        }
                        catch (AlgebricksException e) {
                            throw new HyracksDataException((Throwable)e);
                        }
                        tb.addField(this.result.getByteArray(), this.result.getStartOffset(), this.result.getLength());
                        continue;
                    }
                    tb.addField(accessor, tIndex, AssignRuntimeFactory.this.projectionList[f]);
                }
            }

            @Override
            public void fail() throws HyracksDataException {
                this.writer.fail();
            }
        };
    }

    static /* synthetic */ int[] access$100(AssignRuntimeFactory x0) {
        return x0.projectionList;
    }
}

