/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.sort;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.exceptions.NotImplementedException;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputPushRuntime;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.std.sort.FrameSorterMergeSort;
import java.nio.ByteBuffer;

public class InMemorySortRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final int[] sortFields;
    private INormalizedKeyComputerFactory firstKeyNormalizerFactory;
    private IBinaryComparatorFactory[] comparatorFactories;

    public InMemorySortRuntimeFactory(int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, int[] projectionList) {
        super(projectionList);
        if (projectionList != null) {
            throw new NotImplementedException("Cannot push projection into InMemorySortRuntime.");
        }
        this.sortFields = sortFields;
        this.firstKeyNormalizerFactory = firstKeyNormalizerFactory;
        this.comparatorFactories = comparatorFactories;
    }

    @Override
    public AbstractOneInputOneOutputPushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) throws AlgebricksException {
        return new AbstractOneInputOneOutputPushRuntime(){
            FrameSorterMergeSort frameSorter = null;

            public void open() throws HyracksDataException {
                if (this.frameSorter == null) {
                    this.frameSorter = new FrameSorterMergeSort(ctx, InMemorySortRuntimeFactory.this.sortFields, InMemorySortRuntimeFactory.this.firstKeyNormalizerFactory, InMemorySortRuntimeFactory.this.comparatorFactories, this.outputRecordDesc);
                }
                this.frameSorter.reset();
                this.writer.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.frameSorter.insertFrame(buffer);
            }

            @Override
            public void fail() throws HyracksDataException {
                this.writer.fail();
            }

            public void close() throws HyracksDataException {
                this.frameSorter.sortFrames();
                this.frameSorter.flushFrames(this.writer);
                this.writer.close();
            }
        };
    }
}

