/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.meta;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.exceptions.NotImplementedException;
import edu.uci.ics.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import edu.uci.ics.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputPushRuntime;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import edu.uci.ics.hyracks.algebricks.runtime.operators.meta.PipelineAssembler;
import edu.uci.ics.hyracks.algebricks.runtime.operators.std.NestedTupleSourceRuntimeFactory;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriter;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriterFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import java.io.DataOutput;
import java.nio.ByteBuffer;

public class SubplanRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final AlgebricksPipeline pipeline;
    private final RecordDescriptor inputRecordDesc;
    private final INullWriterFactory[] nullWriterFactories;

    public SubplanRuntimeFactory(AlgebricksPipeline pipeline, INullWriterFactory[] nullWriterFactories, RecordDescriptor inputRecordDesc, int[] projectionList) {
        super(projectionList);
        this.pipeline = pipeline;
        this.nullWriterFactories = nullWriterFactories;
        this.inputRecordDesc = inputRecordDesc;
        if (projectionList != null) {
            throw new NotImplementedException();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Subplan { \n");
        for (IPushRuntimeFactory f : this.pipeline.getRuntimeFactories()) {
            sb.append("  " + f.toString() + ";\n");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public AbstractOneInputOneOutputPushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) throws AlgebricksException, HyracksDataException {
        RecordDescriptor pipelineOutputRecordDescriptor = null;
        final PipelineAssembler pa = new PipelineAssembler(this.pipeline, 1, 1, this.inputRecordDesc, pipelineOutputRecordDescriptor);
        final INullWriter[] nullWriters = new INullWriter[this.nullWriterFactories.length];
        for (int i = 0; i < this.nullWriterFactories.length; ++i) {
            nullWriters[i] = this.nullWriterFactories[i].createNullWriter();
        }
        return new AbstractOneInputOneOutputOneFramePushRuntime(){
            IFrameWriter endPipe = new TupleOuterProduct();
            NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime startOfPipeline = (NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime)pa.assemblePipeline(this.endPipe, ctx);
            boolean first = true;

            public void open() throws HyracksDataException {
                if (this.first) {
                    this.first = false;
                    this.initAccessAppendRef(ctx);
                }
                this.writer.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.tAccess.reset(buffer);
                int nTuple = this.tAccess.getTupleCount();
                for (int t = 0; t < nTuple; ++t) {
                    this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
                    this.startOfPipeline.writeTuple(buffer, t);
                    this.startOfPipeline.open();
                    this.startOfPipeline.close();
                }
            }

            class TupleOuterProduct
            implements IFrameWriter {
                private boolean smthWasWritten = false;
                private IHyracksTaskContext hCtx;
                private int frameSize;
                private FrameTupleAccessor ta;
                private ArrayTupleBuilder tb;

                TupleOuterProduct() {
                    this.hCtx = ctx;
                    this.frameSize = this.hCtx.getFrameSize();
                    this.ta = new FrameTupleAccessor(this.frameSize, SubplanRuntimeFactory.this.pipeline.getRecordDescriptors()[SubplanRuntimeFactory.this.pipeline.getRecordDescriptors().length - 1]);
                    this.tb = new ArrayTupleBuilder(nullWriters.length);
                }

                public void open() throws HyracksDataException {
                    this.smthWasWritten = false;
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.ta.reset(buffer);
                    int nTuple = this.ta.getTupleCount();
                    for (int t = 0; t < nTuple; ++t) {
                        if (appender.appendConcat(tRef.getFrameTupleAccessor(), tRef.getTupleIndex(), (IFrameTupleAccessor)this.ta, t)) continue;
                        FrameUtils.flushFrame((ByteBuffer)frame, (IFrameWriter)writer);
                        appender.reset(frame, true);
                        if (appender.appendConcat(tRef.getFrameTupleAccessor(), tRef.getTupleIndex(), (IFrameTupleAccessor)this.ta, t)) continue;
                        throw new HyracksDataException("Could not write frame: subplan result is larger than the single-frame limit.");
                    }
                    this.smthWasWritten = true;
                }

                public void close() throws HyracksDataException {
                    if (!this.smthWasWritten) {
                        this.appendNullsToTuple();
                        this.appendToFrameFromTupleBuilder(this.tb);
                    }
                }

                public void fail() throws HyracksDataException {
                    writer.fail();
                }

                private void appendNullsToTuple() throws HyracksDataException {
                    this.tb.reset();
                    int n0 = tRef.getFieldCount();
                    for (int f = 0; f < n0; ++f) {
                        this.tb.addField(tRef.getFrameTupleAccessor(), tRef.getTupleIndex(), f);
                    }
                    DataOutput dos = this.tb.getDataOutput();
                    for (int i = 0; i < nullWriters.length; ++i) {
                        nullWriters[i].writeNull(dos);
                        this.tb.addFieldEndOffset();
                    }
                }
            }
        };
    }
}

