/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.meta;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import edu.uci.ics.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import edu.uci.ics.hyracks.algebricks.runtime.operators.meta.PipelineAssembler;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import java.nio.ByteBuffer;
import org.json.JSONException;
import org.json.JSONObject;

public class AlgebricksMetaOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final AlgebricksPipeline pipeline;

    public AlgebricksMetaOperatorDescriptor(IOperatorDescriptorRegistry spec, int inputArity, int outputArity, IPushRuntimeFactory[] runtimeFactories, RecordDescriptor[] internalRecordDescriptors) {
        super(spec, inputArity, outputArity);
        if (outputArity == 1) {
            this.recordDescriptors[0] = internalRecordDescriptors[internalRecordDescriptors.length - 1];
        }
        this.pipeline = new AlgebricksPipeline(runtimeFactories, internalRecordDescriptors);
    }

    public AlgebricksPipeline getPipeline() {
        return this.pipeline;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject json = super.toJSON();
        json.put("micro-operators", (Object)this.pipeline.getRuntimeFactories());
        return json;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Asterix { \n");
        for (IPushRuntimeFactory f : this.pipeline.getRuntimeFactories()) {
            sb.append("  " + f.toString() + ";\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
        if (this.inputArity == 0) {
            return this.createSourceInputPushRuntime(ctx, recordDescProvider, partition, nPartitions);
        }
        return this.createOneInputOneOutputPushRuntime(ctx, recordDescProvider, partition, nPartitions);
    }

    private IOperatorNodePushable createSourceInputPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
        return new AbstractUnaryOutputSourceOperatorNodePushable(){

            public void initialize() throws HyracksDataException {
                IFrameWriter startOfPipeline;
                RecordDescriptor pipelineOutputRecordDescriptor = AlgebricksMetaOperatorDescriptor.this.outputArity > 0 ? AlgebricksMetaOperatorDescriptor.this.recordDescriptors[0] : null;
                PipelineAssembler pa = new PipelineAssembler(AlgebricksMetaOperatorDescriptor.this.pipeline, AlgebricksMetaOperatorDescriptor.this.inputArity, AlgebricksMetaOperatorDescriptor.this.outputArity, null, pipelineOutputRecordDescriptor);
                try {
                    startOfPipeline = pa.assemblePipeline(this.writer, ctx);
                }
                catch (AlgebricksException e) {
                    throw new HyracksDataException((Throwable)e);
                }
                startOfPipeline.open();
                startOfPipeline.close();
            }
        };
    }

    private IOperatorNodePushable createOneInputOneOutputPushRuntime(final IHyracksTaskContext ctx, final IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
        return new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
            private IFrameWriter startOfPipeline;

            public void open() throws HyracksDataException {
                if (this.startOfPipeline == null) {
                    RecordDescriptor pipelineOutputRecordDescriptor = AlgebricksMetaOperatorDescriptor.this.outputArity > 0 ? AlgebricksMetaOperatorDescriptor.this.recordDescriptors[0] : null;
                    RecordDescriptor pipelineInputRecordDescriptor = recordDescProvider.getInputRecordDescriptor(AlgebricksMetaOperatorDescriptor.this.getActivityId(), 0);
                    PipelineAssembler pa = new PipelineAssembler(AlgebricksMetaOperatorDescriptor.this.pipeline, AlgebricksMetaOperatorDescriptor.this.inputArity, AlgebricksMetaOperatorDescriptor.this.outputArity, pipelineInputRecordDescriptor, pipelineOutputRecordDescriptor);
                    try {
                        this.startOfPipeline = pa.assemblePipeline(this.writer, ctx);
                    }
                    catch (AlgebricksException ae) {
                        throw new HyracksDataException((Throwable)ae);
                    }
                }
                this.startOfPipeline.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.startOfPipeline.nextFrame(buffer);
            }

            public void close() throws HyracksDataException {
                this.startOfPipeline.close();
            }

            public void fail() throws HyracksDataException {
                this.startOfPipeline.fail();
            }
        };
    }
}

