/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.group;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.exceptions.NotImplementedException;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputPushRuntime;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import edu.uci.ics.hyracks.dataflow.std.group.preclustered.PreclusteredGroupWriter;
import java.nio.ByteBuffer;

public class MicroPreClusteredGroupRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final int[] groupFields;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final IAggregatorDescriptorFactory aggregatorFactory;
    private final RecordDescriptor inRecordDesc;
    private final RecordDescriptor outRecordDesc;

    public MicroPreClusteredGroupRuntimeFactory(int[] groupFields, IBinaryComparatorFactory[] comparatorFactories, IAggregatorDescriptorFactory aggregatorFactory, RecordDescriptor inRecordDesc, RecordDescriptor outRecordDesc, int[] projectionList) {
        super(projectionList);
        if (projectionList != null) {
            throw new NotImplementedException("Cannot push projection into InMemorySortRuntime.");
        }
        this.groupFields = groupFields;
        this.comparatorFactories = comparatorFactories;
        this.aggregatorFactory = aggregatorFactory;
        this.inRecordDesc = inRecordDesc;
        this.outRecordDesc = outRecordDesc;
    }

    @Override
    public AbstractOneInputOneOutputPushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) throws AlgebricksException {
        try {
            final IBinaryComparator[] comparators = new IBinaryComparator[this.comparatorFactories.length];
            for (int i = 0; i < this.comparatorFactories.length; ++i) {
                comparators[i] = this.comparatorFactories[i].createBinaryComparator();
            }
            ByteBuffer copyFrame = ctx.allocateFrame();
            FrameTupleAccessor copyFrameAccessor = new FrameTupleAccessor(ctx.getFrameSize(), this.inRecordDesc);
            copyFrameAccessor.reset(copyFrame);
            ByteBuffer outFrame = ctx.allocateFrame();
            FrameTupleAppender appender = new FrameTupleAppender(ctx.getFrameSize());
            appender.reset(outFrame, true);
            return new AbstractOneInputOneOutputPushRuntime(){
                private PreclusteredGroupWriter pgw;

                public void open() throws HyracksDataException {
                    IAggregatorDescriptor aggregator = MicroPreClusteredGroupRuntimeFactory.this.aggregatorFactory.createAggregator(ctx, MicroPreClusteredGroupRuntimeFactory.this.inRecordDesc, MicroPreClusteredGroupRuntimeFactory.this.outRecordDesc, MicroPreClusteredGroupRuntimeFactory.this.groupFields, MicroPreClusteredGroupRuntimeFactory.this.groupFields, this.writer);
                    this.pgw = new PreclusteredGroupWriter(ctx, MicroPreClusteredGroupRuntimeFactory.this.groupFields, comparators, aggregator, MicroPreClusteredGroupRuntimeFactory.this.inRecordDesc, MicroPreClusteredGroupRuntimeFactory.this.outRecordDesc, this.writer);
                    this.pgw.open();
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.pgw.nextFrame(buffer);
                }

                @Override
                public void fail() throws HyracksDataException {
                    this.pgw.fail();
                }

                public void close() throws HyracksDataException {
                    this.pgw.close();
                }
            };
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }
}

