/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.base;

import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputPushRuntime;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import java.nio.ByteBuffer;

public abstract class AbstractOneInputOneOutputOneFramePushRuntime
extends AbstractOneInputOneOutputPushRuntime {
    protected FrameTupleAppender appender;
    protected ByteBuffer frame;
    protected FrameTupleAccessor tAccess;
    protected FrameTupleReference tRef;

    public void close() throws HyracksDataException {
        if (!this.failed && this.appender.getTupleCount() > 0) {
            FrameUtils.flushFrame((ByteBuffer)this.frame, (IFrameWriter)this.writer);
        }
        this.writer.close();
        this.appender.reset(this.frame, true);
    }

    protected void appendToFrameFromTupleBuilder(ArrayTupleBuilder tb) throws HyracksDataException {
        this.appendToFrameFromTupleBuilder(tb, false);
    }

    protected void appendToFrameFromTupleBuilder(ArrayTupleBuilder tb, boolean flushFrame) throws HyracksDataException {
        if (!this.appender.append(tb.getFieldEndOffsets(), tb.getByteArray(), 0, tb.getSize())) {
            FrameUtils.flushFrame((ByteBuffer)this.frame, (IFrameWriter)this.writer);
            this.appender.reset(this.frame, true);
            if (!this.appender.append(tb.getFieldEndOffsets(), tb.getByteArray(), 0, tb.getSize())) {
                throw new HyracksDataException("Could not write frame: the size of the tuple is too long to be fit into a single frame. (AbstractOneInputOneOutputOneFramePushRuntime.appendToFrameFromTupleBuilder)");
            }
        }
        if (flushFrame) {
            FrameUtils.flushFrame((ByteBuffer)this.frame, (IFrameWriter)this.writer);
            this.appender.reset(this.frame, true);
        }
    }

    protected void appendProjectionToFrame(int tIndex, int[] projectionList) throws HyracksDataException {
        this.appendProjectionToFrame(tIndex, projectionList, false);
    }

    protected void appendProjectionToFrame(int tIndex, int[] projectionList, boolean flushFrame) throws HyracksDataException {
        if (!this.appender.appendProjection((IFrameTupleAccessor)this.tAccess, tIndex, projectionList)) {
            FrameUtils.flushFrame((ByteBuffer)this.frame, (IFrameWriter)this.writer);
            this.appender.reset(this.frame, true);
            if (!this.appender.appendProjection((IFrameTupleAccessor)this.tAccess, tIndex, projectionList)) {
                throw new IllegalStateException("Could not write frame (AbstractOneInputOneOutputOneFramePushRuntime.appendProjectionToFrame).");
            }
            return;
        }
        if (flushFrame) {
            FrameUtils.flushFrame((ByteBuffer)this.frame, (IFrameWriter)this.writer);
            this.appender.reset(this.frame, true);
        }
    }

    protected void appendTupleToFrame(int tIndex) throws HyracksDataException {
        if (!this.appender.append((IFrameTupleAccessor)this.tAccess, tIndex)) {
            FrameUtils.flushFrame((ByteBuffer)this.frame, (IFrameWriter)this.writer);
            this.appender.reset(this.frame, true);
            if (!this.appender.append((IFrameTupleAccessor)this.tAccess, tIndex)) {
                throw new IllegalStateException("Could not write frame (AbstractOneInputOneOutputOneFramePushRuntime.appendTupleToFrame).");
            }
        }
    }

    protected final void initAccessAppend(IHyracksTaskContext ctx) throws HyracksDataException {
        this.frame = ctx.allocateFrame();
        this.appender = new FrameTupleAppender(ctx.getFrameSize());
        this.appender.reset(this.frame, true);
        this.tAccess = new FrameTupleAccessor(ctx.getFrameSize(), this.inputRecordDesc);
    }

    protected final void initAccessAppendRef(IHyracksTaskContext ctx) throws HyracksDataException {
        this.initAccessAppend(ctx);
        this.tRef = new FrameTupleReference();
    }
}

