/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.aggreg;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.ICopySerializableAggregateFunction;
import edu.uci.ics.hyracks.algebricks.runtime.base.ICopySerializableAggregateFunctionFactory;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import edu.uci.ics.hyracks.dataflow.std.group.AbstractAccumulatingAggregatorDescriptorFactory;
import edu.uci.ics.hyracks.dataflow.std.group.AggregateState;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptor;
import java.io.DataOutput;

public class SerializableAggregatorDescriptorFactory
extends AbstractAccumulatingAggregatorDescriptorFactory {
    private static final long serialVersionUID = 1L;
    private ICopySerializableAggregateFunctionFactory[] aggFactories;

    public SerializableAggregatorDescriptorFactory(ICopySerializableAggregateFunctionFactory[] aggFactories) {
        this.aggFactories = aggFactories;
    }

    public IAggregatorDescriptor createAggregator(IHyracksTaskContext ctx, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor, int[] keyFields, int[] keyFieldsInPartialResults) throws HyracksDataException {
        final int[] keys = keyFields;
        return new IAggregatorDescriptor(){
            private FrameTupleReference ftr = new FrameTupleReference();
            private ICopySerializableAggregateFunction[] aggs = new ICopySerializableAggregateFunction[SerializableAggregatorDescriptorFactory.access$000(SerializableAggregatorDescriptorFactory.this).length];
            private int offsetFieldIndex = keys.length;
            private int[] stateFieldLength = new int[SerializableAggregatorDescriptorFactory.access$000(SerializableAggregatorDescriptorFactory.this).length];

            public AggregateState createAggregateStates() {
                return new AggregateState();
            }

            public void init(ArrayTupleBuilder tb, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                int i;
                DataOutput output = tb.getDataOutput();
                this.ftr.reset(accessor, tIndex);
                for (i = 0; i < this.aggs.length; ++i) {
                    try {
                        int begin = tb.getSize();
                        if (this.aggs[i] == null) {
                            this.aggs[i] = SerializableAggregatorDescriptorFactory.this.aggFactories[i].createAggregateFunction();
                        }
                        this.aggs[i].init(output);
                        tb.addFieldEndOffset();
                        this.stateFieldLength[i] = tb.getSize() - begin;
                        continue;
                    }
                    catch (AlgebricksException e) {
                        throw new HyracksDataException((Throwable)e);
                    }
                }
                this.ftr.reset(accessor, tIndex);
                for (i = 0; i < this.aggs.length; ++i) {
                    try {
                        byte[] data = tb.getByteArray();
                        int prevFieldPos = i + keys.length - 1;
                        int start = prevFieldPos >= 0 ? tb.getFieldEndOffsets()[prevFieldPos] : 0;
                        this.aggs[i].step((IFrameTupleReference)this.ftr, data, start, this.stateFieldLength[i]);
                        continue;
                    }
                    catch (AlgebricksException e) {
                        throw new HyracksDataException((Throwable)e);
                    }
                }
            }

            public void aggregate(IFrameTupleAccessor accessor, int tIndex, IFrameTupleAccessor stateAccessor, int stateTupleIndex, AggregateState state) throws HyracksDataException {
                this.ftr.reset(accessor, tIndex);
                int stateTupleStart = stateAccessor.getTupleStartOffset(stateTupleIndex);
                int fieldSlotLength = stateAccessor.getFieldSlotsLength();
                for (int i = 0; i < this.aggs.length; ++i) {
                    try {
                        byte[] data = stateAccessor.getBuffer().array();
                        int start = stateAccessor.getFieldStartOffset(stateTupleIndex, i + keys.length) + stateTupleStart + fieldSlotLength;
                        this.aggs[i].step((IFrameTupleReference)this.ftr, data, start, this.stateFieldLength[i]);
                        continue;
                    }
                    catch (AlgebricksException e) {
                        throw new HyracksDataException((Throwable)e);
                    }
                }
            }

            public boolean outputPartialResult(ArrayTupleBuilder tb, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                int refOffset;
                byte[] data = accessor.getBuffer().array();
                int startOffset = accessor.getTupleStartOffset(tIndex);
                int aggFieldOffset = accessor.getFieldStartOffset(tIndex, this.offsetFieldIndex);
                int start = refOffset = startOffset + accessor.getFieldSlotsLength() + aggFieldOffset;
                for (int i = 0; i < this.aggs.length; ++i) {
                    try {
                        this.aggs[i].finishPartial(data, start, this.stateFieldLength[i], tb.getDataOutput());
                        start += this.stateFieldLength[i];
                        tb.addFieldEndOffset();
                        continue;
                    }
                    catch (AlgebricksException e) {
                        throw new HyracksDataException((Throwable)e);
                    }
                }
                return true;
            }

            public boolean outputFinalResult(ArrayTupleBuilder tb, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                int refOffset;
                byte[] data = accessor.getBuffer().array();
                int startOffset = accessor.getTupleStartOffset(tIndex);
                int aggFieldOffset = accessor.getFieldStartOffset(tIndex, this.offsetFieldIndex);
                int start = refOffset = startOffset + accessor.getFieldSlotsLength() + aggFieldOffset;
                for (int i = 0; i < this.aggs.length; ++i) {
                    try {
                        this.aggs[i].finish(data, start, this.stateFieldLength[i], tb.getDataOutput());
                        start += this.stateFieldLength[i];
                        tb.addFieldEndOffset();
                        continue;
                    }
                    catch (AlgebricksException e) {
                        throw new HyracksDataException((Throwable)e);
                    }
                }
                return true;
            }

            public void reset() {
            }

            public void close() {
                this.reset();
            }
        };
    }
}

