/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.aggreg;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import edu.uci.ics.hyracks.algebricks.runtime.base.IPushRuntime;
import edu.uci.ics.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import edu.uci.ics.hyracks.algebricks.runtime.operators.std.NestedTupleSourceRuntimeFactory;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.std.group.AggregateState;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import java.nio.ByteBuffer;

public class NestedPlansRunningAggregatorFactory
implements IAggregatorDescriptorFactory {
    private static final long serialVersionUID = 1L;
    private AlgebricksPipeline[] subplans;
    private int[] keyFieldIdx;
    private int[] decorFieldIdx;

    public NestedPlansRunningAggregatorFactory(AlgebricksPipeline[] subplans, int[] keyFieldIdx, int[] decorFieldIdx) {
        this.subplans = subplans;
        this.keyFieldIdx = keyFieldIdx;
        this.decorFieldIdx = decorFieldIdx;
    }

    public IAggregatorDescriptor createAggregator(IHyracksTaskContext ctx, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor, int[] keyFields, int[] keyFieldsInPartialResults, IFrameWriter writer) throws HyracksDataException {
        final RunningAggregatorOutput outputWriter = new RunningAggregatorOutput(ctx, this.subplans, this.keyFieldIdx.length, this.decorFieldIdx.length, writer);
        final NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[] pipelines = new NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[this.subplans.length];
        for (int i = 0; i < this.subplans.length; ++i) {
            try {
                pipelines[i] = (NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime)this.assemblePipeline(this.subplans[i], outputWriter, ctx);
                continue;
            }
            catch (AlgebricksException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        final ArrayTupleBuilder gbyTb = outputWriter.getGroupByTupleBuilder();
        ByteBuffer outputFrame = ctx.allocateFrame();
        FrameTupleAppender outputAppender = new FrameTupleAppender(ctx.getFrameSize());
        outputAppender.reset(outputFrame, true);
        return new IAggregatorDescriptor(){

            public void init(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                int i;
                for (i = 0; i < pipelines.length; ++i) {
                    pipelines[i].open();
                }
                gbyTb.reset();
                for (i = 0; i < NestedPlansRunningAggregatorFactory.this.keyFieldIdx.length; ++i) {
                    gbyTb.addField(accessor, tIndex, NestedPlansRunningAggregatorFactory.this.keyFieldIdx[i]);
                }
                for (i = 0; i < NestedPlansRunningAggregatorFactory.this.decorFieldIdx.length; ++i) {
                    gbyTb.addField(accessor, tIndex, NestedPlansRunningAggregatorFactory.this.decorFieldIdx[i]);
                }
                for (i = 0; i < pipelines.length; ++i) {
                    outputWriter.setInputIdx(i);
                    pipelines[i].writeTuple(accessor.getBuffer(), tIndex);
                    pipelines[i].forceFlush();
                }
            }

            public void aggregate(IFrameTupleAccessor accessor, int tIndex, IFrameTupleAccessor stateAccessor, int stateTupleIndex, AggregateState state) throws HyracksDataException {
                for (int i = 0; i < pipelines.length; ++i) {
                    outputWriter.setInputIdx(i);
                    pipelines[i].writeTuple(accessor.getBuffer(), tIndex);
                    pipelines[i].forceFlush();
                }
            }

            public boolean outputFinalResult(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                return false;
            }

            public AggregateState createAggregateStates() {
                return new AggregateState();
            }

            public void reset() {
            }

            public boolean outputPartialResult(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                throw new IllegalStateException("this method should not be called");
            }

            public void close() {
                for (int i = 0; i < pipelines.length; ++i) {
                    try {
                        outputWriter.setInputIdx(i);
                        pipelines[i].close();
                        continue;
                    }
                    catch (HyracksDataException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        };
    }

    private IFrameWriter assemblePipeline(AlgebricksPipeline subplan, IFrameWriter writer, IHyracksTaskContext ctx) throws AlgebricksException, HyracksDataException {
        IFrameWriter start = writer;
        IPushRuntimeFactory[] runtimeFactories = subplan.getRuntimeFactories();
        RecordDescriptor[] recordDescriptors = subplan.getRecordDescriptors();
        for (int i = runtimeFactories.length - 1; i >= 0; --i) {
            IPushRuntime newRuntime = runtimeFactories[i].createPushRuntime(ctx);
            newRuntime.setFrameWriter(0, start, recordDescriptors[i]);
            if (i > 0) {
                newRuntime.setInputRecordDescriptor(0, recordDescriptors[i - 1]);
            } else {
                newRuntime.setInputRecordDescriptor(0, recordDescriptors[0]);
            }
            start = newRuntime;
        }
        return start;
    }

    private static class RunningAggregatorOutput
    implements IFrameWriter {
        private FrameTupleAccessor[] tAccess;
        private RecordDescriptor[] inputRecDesc;
        private int inputIdx;
        private ArrayTupleBuilder tb;
        private ArrayTupleBuilder gbyTb;
        private AlgebricksPipeline[] subplans;
        private IFrameWriter outputWriter;
        private ByteBuffer outputFrame;
        private FrameTupleAppender outputAppender;

        public RunningAggregatorOutput(IHyracksTaskContext ctx, AlgebricksPipeline[] subplans, int numKeys, int numDecors, IFrameWriter outputWriter) throws HyracksDataException {
            int i;
            this.subplans = subplans;
            this.outputWriter = outputWriter;
            int totalAggFields = 0;
            this.inputRecDesc = new RecordDescriptor[subplans.length];
            for (i = 0; i < subplans.length; ++i) {
                RecordDescriptor[] rd = subplans[i].getRecordDescriptors();
                this.inputRecDesc[i] = rd[rd.length - 1];
                totalAggFields += subplans[i].getOutputWidth();
            }
            this.tb = new ArrayTupleBuilder(numKeys + numDecors + totalAggFields);
            this.gbyTb = new ArrayTupleBuilder(numKeys + numDecors);
            this.tAccess = new FrameTupleAccessor[this.inputRecDesc.length];
            for (i = 0; i < this.inputRecDesc.length; ++i) {
                this.tAccess[i] = new FrameTupleAccessor(ctx.getFrameSize(), this.inputRecDesc[i]);
            }
            this.outputFrame = ctx.allocateFrame();
            this.outputAppender = new FrameTupleAppender(ctx.getFrameSize());
            this.outputAppender.reset(this.outputFrame, true);
        }

        public void open() throws HyracksDataException {
        }

        public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
            int w = this.subplans[this.inputIdx].getOutputWidth();
            FrameTupleAccessor accessor = this.tAccess[this.inputIdx];
            accessor.reset(buffer);
            for (int tIndex = 0; tIndex < accessor.getTupleCount(); ++tIndex) {
                this.tb.reset();
                byte[] data = this.gbyTb.getByteArray();
                int[] fieldEnds = this.gbyTb.getFieldEndOffsets();
                int start = 0;
                int offset = 0;
                for (int i = 0; i < fieldEnds.length; ++i) {
                    if (i > 0) {
                        start = fieldEnds[i - 1];
                    }
                    offset = fieldEnds[i] - start;
                    this.tb.addField(data, start, offset);
                }
                for (int f = 0; f < w; ++f) {
                    this.tb.addField((IFrameTupleAccessor)accessor, tIndex, f);
                }
                if (this.outputAppender.append(this.tb.getFieldEndOffsets(), this.tb.getByteArray(), 0, this.tb.getSize())) continue;
                FrameUtils.flushFrame((ByteBuffer)this.outputFrame, (IFrameWriter)this.outputWriter);
                this.outputAppender.reset(this.outputFrame, true);
                if (this.outputAppender.append(this.tb.getFieldEndOffsets(), this.tb.getByteArray(), 0, this.tb.getSize())) continue;
                throw new HyracksDataException("Failed to write a running aggregation result into an empty frame: possibly the size of the result is too large.");
            }
        }

        public void close() throws HyracksDataException {
            if (this.outputAppender.getTupleCount() > 0) {
                FrameUtils.flushFrame((ByteBuffer)this.outputFrame, (IFrameWriter)this.outputWriter);
                this.outputAppender.reset(this.outputFrame, true);
            }
        }

        public void setInputIdx(int inputIdx) {
            this.inputIdx = inputIdx;
        }

        public ArrayTupleBuilder getGroupByTupleBuilder() {
            return this.gbyTb;
        }

        public void fail() throws HyracksDataException {
        }
    }
}

