/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.aggreg;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import java.nio.ByteBuffer;

public class AggregateRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private IAggregateEvaluatorFactory[] aggregFactories;

    public AggregateRuntimeFactory(IAggregateEvaluatorFactory[] aggregFactories) {
        super(null);
        this.aggregFactories = aggregFactories;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("assign [");
        for (int i = 0; i < this.aggregFactories.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.aggregFactories[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public AbstractOneInputOneOutputOneFramePushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) throws AlgebricksException {
        return new AbstractOneInputOneOutputOneFramePushRuntime(){
            private IAggregateEvaluator[] aggregs;
            private IPointable result;
            private ArrayTupleBuilder tupleBuilder;
            private boolean first;
            {
                this.aggregs = new IAggregateEvaluator[AggregateRuntimeFactory.this.aggregFactories.length];
                this.result = VoidPointable.FACTORY.createPointable();
                this.tupleBuilder = new ArrayTupleBuilder(this.aggregs.length);
                this.first = true;
            }

            public void open() throws HyracksDataException {
                try {
                    int i;
                    if (this.first) {
                        this.first = false;
                        this.initAccessAppendRef(ctx);
                        for (i = 0; i < AggregateRuntimeFactory.this.aggregFactories.length; ++i) {
                            this.aggregs[i] = AggregateRuntimeFactory.this.aggregFactories[i].createAggregateEvaluator(ctx);
                        }
                    }
                    for (i = 0; i < AggregateRuntimeFactory.this.aggregFactories.length; ++i) {
                        this.aggregs[i].init();
                    }
                }
                catch (AlgebricksException e) {
                    throw new HyracksDataException((Throwable)e);
                }
                this.writer.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.tAccess.reset(buffer);
                int nTuple = this.tAccess.getTupleCount();
                for (int t = 0; t < nTuple; ++t) {
                    this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
                    this.processTuple(this.tRef);
                }
            }

            @Override
            public void close() throws HyracksDataException {
                this.computeAggregate();
                this.appendToFrameFromTupleBuilder(this.tupleBuilder);
                super.close();
            }

            private void computeAggregate() throws HyracksDataException {
                this.tupleBuilder.reset();
                for (int f = 0; f < this.aggregs.length; ++f) {
                    try {
                        this.aggregs[f].finish(this.result);
                    }
                    catch (AlgebricksException e) {
                        throw new HyracksDataException((Throwable)e);
                    }
                    this.tupleBuilder.addField(this.result.getByteArray(), this.result.getStartOffset(), this.result.getLength());
                }
            }

            private void processTuple(FrameTupleReference tupleRef) throws HyracksDataException {
                for (int f = 0; f < this.aggregs.length; ++f) {
                    try {
                        this.aggregs[f].step((IFrameTupleReference)tupleRef);
                        continue;
                    }
                    catch (AlgebricksException e) {
                        throw new HyracksDataException((Throwable)e);
                    }
                }
            }

            @Override
            public void fail() throws HyracksDataException {
                this.writer.fail();
            }
        };
    }
}

