/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.evaluators;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.ICopyEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.ICopyEvaluatorFactory;
import edu.uci.ics.hyracks.data.std.api.IDataOutputProvider;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import java.io.DataOutput;
import java.io.IOException;

public class ColumnAccessEvalFactory
implements ICopyEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private final int fieldIndex;

    public ColumnAccessEvalFactory(int fieldIndex) {
        this.fieldIndex = fieldIndex;
    }

    public String toString() {
        return "ColumnAccess(" + this.fieldIndex + ")";
    }

    @Override
    public ICopyEvaluator createEvaluator(final IDataOutputProvider output) throws AlgebricksException {
        return new ICopyEvaluator(){
            private DataOutput out;
            {
                this.out = output.getDataOutput();
            }

            @Override
            public void evaluate(IFrameTupleReference tuple) throws AlgebricksException {
                byte[] buffer = tuple.getFieldData(ColumnAccessEvalFactory.this.fieldIndex);
                int start = tuple.getFieldStart(ColumnAccessEvalFactory.this.fieldIndex);
                int length = tuple.getFieldLength(ColumnAccessEvalFactory.this.fieldIndex);
                try {
                    this.out.write(buffer, start, length);
                }
                catch (IOException ioe) {
                    throw new AlgebricksException((Throwable)ioe);
                }
            }
        };
    }
}

