/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.common.work;

import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.control.common.work.AbstractWork;
import edu.uci.ics.hyracks.control.common.work.SynchronizableWork;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorkQueue {
    private static final Logger LOGGER = Logger.getLogger(WorkQueue.class.getName());
    private final LinkedBlockingQueue<AbstractWork> queue = new LinkedBlockingQueue();
    private final WorkerThread thread = new WorkerThread();
    private final Semaphore stopSemaphore = new Semaphore(1);
    private boolean stopped;
    private final AtomicInteger enqueueCount = new AtomicInteger();
    private final AtomicInteger dequeueCount = new AtomicInteger();

    public void start() throws HyracksException {
        this.stopped = false;
        this.enqueueCount.set(0);
        this.dequeueCount.set(0);
        try {
            this.stopSemaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new HyracksException((Throwable)e);
        }
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws HyracksException {
        WorkQueue workQueue = this;
        synchronized (workQueue) {
            this.stopped = true;
        }
        this.schedule(new AbstractWork(){

            @Override
            public void run() {
            }
        });
        try {
            this.stopSemaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new HyracksException((Throwable)e);
        }
    }

    public void schedule(AbstractWork event) {
        this.enqueueCount.incrementAndGet();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Enqueue: " + this.enqueueCount);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Scheduling: " + event);
        }
        this.queue.offer(event);
    }

    public void scheduleAndSync(SynchronizableWork sRunnable) throws Exception {
        this.schedule(sRunnable);
        sRunnable.sync();
    }

    private class WorkerThread
    extends Thread {
        WorkerThread() {
            this.setDaemon(true);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    AbstractWork r;
                    WorkQueue workQueue = WorkQueue.this;
                    synchronized (workQueue) {
                        if (WorkQueue.this.stopped) {
                            return;
                        }
                    }
                    try {
                        r = (AbstractWork)WorkQueue.this.queue.take();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    WorkQueue.this.dequeueCount.incrementAndGet();
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Dequeue: " + WorkQueue.this.dequeueCount + "/" + WorkQueue.this.enqueueCount);
                    }
                    try {
                        if (LOGGER.isLoggable(r.logLevel())) {
                            LOGGER.log(r.logLevel(), "Executing: " + r);
                        }
                        r.run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                WorkQueue.this.stopSemaphore.release();
            }
        }
    }
}

