/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.common.utils;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExceptionUtils {
    public static List<Exception> getActualExceptions(List<Exception> allExceptions) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Exception exception : allExceptions) {
            if (!ExceptionUtils.possibleRootCause(exception)) continue;
            exceptions.add(exception);
        }
        return exceptions;
    }

    public static void setNodeIds(Collection<Exception> exceptions, String nodeId) {
        ArrayList<HyracksDataException> newExceptions = new ArrayList<HyracksDataException>();
        for (Exception e : exceptions) {
            HyracksDataException newException = new HyracksDataException((Throwable)e);
            newException.setNodeId(nodeId);
            newExceptions.add(newException);
        }
        exceptions.clear();
        exceptions.addAll(newExceptions);
    }

    private static boolean possibleRootCause(Throwable exception) {
        Throwable cause = exception;
        while ((cause = cause.getCause()) != null) {
            if (!(cause instanceof InterruptedException) && !(cause instanceof ClosedChannelException)) continue;
            return false;
        }
        return true;
    }
}

