/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.common.job.profiling.om;

import edu.uci.ics.hyracks.api.dataflow.TaskAttemptId;
import edu.uci.ics.hyracks.api.partitions.PartitionId;
import edu.uci.ics.hyracks.control.common.job.profiling.counters.MultiResolutionEventProfiler;
import edu.uci.ics.hyracks.control.common.job.profiling.om.AbstractProfile;
import edu.uci.ics.hyracks.control.common.job.profiling.om.PartitionProfile;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskProfile
extends AbstractProfile {
    private static final long serialVersionUID = 1L;
    private final TaskAttemptId taskAttemptId;
    private final Map<PartitionId, PartitionProfile> partitionSendProfile;

    public TaskProfile(TaskAttemptId taskAttemptId, Map<PartitionId, PartitionProfile> partitionSendProfile) {
        this.taskAttemptId = taskAttemptId;
        this.partitionSendProfile = new HashMap<PartitionId, PartitionProfile>(partitionSendProfile);
    }

    public TaskAttemptId getTaskId() {
        return this.taskAttemptId;
    }

    public Map<PartitionId, PartitionProfile> getPartitionSendProfile() {
        return this.partitionSendProfile;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("activity-id", (Object)this.taskAttemptId.getTaskId().getActivityId().toString());
        json.put("partition", this.taskAttemptId.getTaskId().getPartition());
        json.put("attempt", this.taskAttemptId.getAttempt());
        if (this.partitionSendProfile != null) {
            JSONArray pspArray = new JSONArray();
            for (PartitionProfile pp : this.partitionSendProfile.values()) {
                JSONObject ppObj = new JSONObject();
                PartitionId pid = pp.getPartitionId();
                JSONObject pidObj = new JSONObject();
                pidObj.put("job-id", (Object)pid.getJobId());
                pidObj.put("connector-id", (Object)pid.getConnectorDescriptorId());
                pidObj.put("sender-index", pid.getSenderIndex());
                pidObj.put("receiver-index", pid.getReceiverIndex());
                ppObj.put("partition-id", (Object)pidObj);
                ppObj.put("open-time", pp.getOpenTime());
                ppObj.put("close-time", pp.getCloseTime());
                MultiResolutionEventProfiler samples = pp.getSamples();
                ppObj.put("offset", samples.getOffset());
                int resolution = samples.getResolution();
                int sampleCount = samples.getCount();
                JSONArray ftA = new JSONArray();
                int[] ft = samples.getSamples();
                for (int i = 0; i < sampleCount; ++i) {
                    ftA.put(ft[i]);
                }
                ppObj.put("frame-times", (Object)ftA);
                ppObj.put("resolution", resolution);
                pspArray.put((Object)ppObj);
            }
            json.put("partition-send-profile", (Object)pspArray);
        }
        this.populateCounters(json);
        return json;
    }
}

