/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.common.job.profiling.om;

import edu.uci.ics.hyracks.api.dataflow.TaskAttemptId;
import edu.uci.ics.hyracks.control.common.job.profiling.om.AbstractProfile;
import edu.uci.ics.hyracks.control.common.job.profiling.om.TaskProfile;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JobletProfile
extends AbstractProfile {
    private static final long serialVersionUID = 1L;
    private final String nodeId;
    private final Map<TaskAttemptId, TaskProfile> taskProfiles;

    public JobletProfile(String nodeId) {
        this.nodeId = nodeId;
        this.taskProfiles = new HashMap<TaskAttemptId, TaskProfile>();
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Map<TaskAttemptId, TaskProfile> getTaskProfiles() {
        return this.taskProfiles;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("node-id", (Object)this.nodeId.toString());
        this.populateCounters(json);
        JSONArray tasks = new JSONArray();
        for (TaskProfile p : this.taskProfiles.values()) {
            tasks.put((Object)p.toJSON());
        }
        json.put("tasks", (Object)tasks);
        return json;
    }

    public void merge(JobletProfile jp) {
        super.merge(this);
        for (TaskProfile tp : jp.taskProfiles.values()) {
            if (this.taskProfiles.containsKey(tp.getTaskId())) {
                this.taskProfiles.get(tp.getTaskId()).merge(tp);
                continue;
            }
            this.taskProfiles.put(tp.getTaskId(), tp);
        }
    }
}

