/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.common.job.profiling.om;

import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.common.job.profiling.om.AbstractProfile;
import edu.uci.ics.hyracks.control.common.job.profiling.om.JobletProfile;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JobProfile
extends AbstractProfile {
    private static final long serialVersionUID = 1L;
    private final JobId jobId;
    private final Map<String, JobletProfile> jobletProfiles;

    public JobProfile(JobId jobId) {
        this.jobId = jobId;
        this.jobletProfiles = new HashMap<String, JobletProfile>();
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public Map<String, JobletProfile> getJobletProfiles() {
        return this.jobletProfiles;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("job-id", (Object)this.jobId.toString());
        this.populateCounters(json);
        JSONArray jobletsArray = new JSONArray();
        for (JobletProfile p : this.jobletProfiles.values()) {
            jobletsArray.put((Object)p.toJSON());
        }
        json.put("joblets", (Object)jobletsArray);
        return json;
    }

    public void merge(JobProfile other) {
        super.merge(this);
        for (JobletProfile jp : other.jobletProfiles.values()) {
            if (this.jobletProfiles.containsKey(jp.getNodeId())) {
                this.jobletProfiles.get(jp.getNodeId()).merge(jp);
                continue;
            }
            this.jobletProfiles.put(jp.getNodeId(), jp);
        }
    }
}

