/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.common.job.profiling.counters;

import java.io.Serializable;

public class MultiResolutionEventProfiler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int[] times;
    private long offset;
    private int ptr;
    private int resolution;
    private int eventCounter;

    public MultiResolutionEventProfiler(int nSamples) {
        this.times = new int[nSamples];
        this.offset = -1L;
        this.ptr = 0;
        this.resolution = 1;
        this.eventCounter = 0;
    }

    public void reportEvent() {
        ++this.eventCounter;
        if (this.eventCounter % this.resolution != 0) {
            return;
        }
        if (this.ptr >= this.times.length) {
            this.compact();
            return;
        }
        this.eventCounter = 0;
        long time = System.currentTimeMillis();
        if (this.offset < 0L) {
            this.offset = time;
        }
        int value = (int)(time - this.offset);
        this.times[this.ptr++] = value;
    }

    private void compact() {
        for (int i = 1; i < this.ptr / 2; ++i) {
            this.times[i] = this.times[i * 2];
        }
        this.resolution <<= 1;
        this.ptr >>= 1;
    }

    public int getResolution() {
        return this.resolution;
    }

    public int getCount() {
        return this.ptr;
    }

    public int[] getSamples() {
        return this.times;
    }

    public long getOffset() {
        return this.offset;
    }
}

