/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.common.deployment;

import edu.uci.ics.hyracks.api.application.IApplicationContext;
import edu.uci.ics.hyracks.api.deployment.DeploymentId;
import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.job.IJobSerializerDeserializer;
import edu.uci.ics.hyracks.api.job.IJobSerializerDeserializerContainer;
import edu.uci.ics.hyracks.api.util.JavaSerializationUtils;
import edu.uci.ics.hyracks.control.common.context.ServerContext;
import edu.uci.ics.hyracks.control.common.deployment.ClassLoaderJobSerializerDeserializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class DeploymentUtils {
    private static final String DEPLOYMENT = "applications";

    public static void undeploy(DeploymentId deploymentId, IJobSerializerDeserializerContainer container, ServerContext ctx) throws HyracksException {
        container.removeJobSerializerDeserializer(deploymentId);
        String rootDir = ctx.getBaseDir().toString();
        String deploymentDir = rootDir.endsWith(File.separator) ? rootDir + DEPLOYMENT + File.separator + deploymentId : rootDir + File.separator + DEPLOYMENT + File.separator + deploymentId;
        try {
            File dFile = new File(deploymentDir);
            if (dFile.exists()) {
                FileUtils.forceDelete((File)dFile);
            }
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
    }

    public static void deploy(DeploymentId deploymentId, List<URL> urls, IJobSerializerDeserializerContainer container, ServerContext ctx, boolean isNC) throws HyracksException {
        String rootDir;
        IJobSerializerDeserializer jobSerDe = container.getJobSerializerDeserializer(deploymentId);
        if (jobSerDe == null) {
            jobSerDe = new ClassLoaderJobSerializerDeserializer();
            container.addJobSerializerDeserializer(deploymentId, jobSerDe);
        }
        String deploymentDir = (rootDir = ctx.getBaseDir().toString()).endsWith(File.separator) ? rootDir + DEPLOYMENT + File.separator + deploymentId : rootDir + File.separator + DEPLOYMENT + File.separator + deploymentId;
        jobSerDe.addClassPathURLs(DeploymentUtils.downloadURLs(urls, deploymentDir, isNC));
    }

    public static Object deserialize(byte[] bytes, DeploymentId deploymentId, IApplicationContext appCtx) throws HyracksException {
        try {
            IJobSerializerDeserializerContainer jobSerDeContainer = appCtx.getJobSerializerDeserializerContainer();
            IJobSerializerDeserializer jobSerDe = deploymentId == null ? null : jobSerDeContainer.getJobSerializerDeserializer(deploymentId);
            Object obj = jobSerDe == null ? JavaSerializationUtils.deserialize((byte[])bytes) : jobSerDe.deserialize(bytes);
            return obj;
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
    }

    public static Class<?> loadClass(String className, DeploymentId deploymentId, IApplicationContext appCtx) throws HyracksException {
        try {
            IJobSerializerDeserializerContainer jobSerDeContainer = appCtx.getJobSerializerDeserializerContainer();
            IJobSerializerDeserializer jobSerDe = deploymentId == null ? null : jobSerDeContainer.getJobSerializerDeserializer(deploymentId);
            Class cl = jobSerDe == null ? JavaSerializationUtils.loadClass((String)className) : jobSerDe.loadClass(className);
            return cl;
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
    }

    public static ClassLoader getClassLoader(DeploymentId deploymentId, IApplicationContext appCtx) throws HyracksException {
        try {
            IJobSerializerDeserializerContainer jobSerDeContainer = appCtx.getJobSerializerDeserializerContainer();
            IJobSerializerDeserializer jobSerDe = deploymentId == null ? null : jobSerDeContainer.getJobSerializerDeserializer(deploymentId);
            ClassLoader cl = jobSerDe == null ? DeploymentUtils.class.getClassLoader() : jobSerDe.getClassLoader();
            return cl;
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<URL> downloadURLs(List<URL> urls, String deploymentDir, boolean isNC) throws HyracksException {
        int retryCount = 10;
        int tried = 0;
        Exception trace = null;
        while (tried < retryCount) {
            try {
                ++tried;
                ArrayList<URL> downloadedFileURLs = new ArrayList<URL>();
                File dir = new File(deploymentDir);
                if (!dir.exists()) {
                    FileUtils.forceMkdir((File)dir);
                }
                for (URL url : urls) {
                    String urlString = url.toString();
                    int slashIndex = urlString.lastIndexOf(47);
                    String fileName = urlString.substring(slashIndex + 1).split("&")[1];
                    String filePath = deploymentDir + File.separator + fileName;
                    File targetFile = new File(filePath);
                    if (isNC) {
                        DefaultHttpClient hc = new DefaultHttpClient();
                        HttpGet get = new HttpGet(url.toString());
                        HttpResponse response = hc.execute((HttpUriRequest)get);
                        InputStream is = response.getEntity().getContent();
                        FileOutputStream os = new FileOutputStream(targetFile);
                        try {
                            IOUtils.copyLarge((InputStream)is, (OutputStream)os);
                        }
                        finally {
                            ((OutputStream)os).close();
                            is.close();
                        }
                    }
                    downloadedFileURLs.add(targetFile.toURI().toURL());
                }
                return downloadedFileURLs;
            }
            catch (Exception e) {
                trace = e;
            }
        }
        throw new HyracksException(trace);
    }
}

