/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.common.deployment;

import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.job.IJobSerializerDeserializer;
import edu.uci.ics.hyracks.api.util.JavaSerializationUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ClassLoaderJobSerializerDeserializer
implements IJobSerializerDeserializer {
    private URLClassLoader classLoader;

    public Object deserialize(byte[] jsBytes) throws HyracksException {
        try {
            if (this.classLoader == null) {
                return JavaSerializationUtils.deserialize((byte[])jsBytes);
            }
            return JavaSerializationUtils.deserialize((byte[])jsBytes, (ClassLoader)this.classLoader);
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
    }

    public byte[] serialize(Serializable jobSpec) throws HyracksException {
        try {
            if (this.classLoader == null) {
                return JavaSerializationUtils.serialize((Serializable)jobSpec);
            }
            return JavaSerializationUtils.serialize((Serializable)jobSpec, (ClassLoader)this.classLoader);
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
    }

    public void addClassPathURLs(List<URL> binaryURLs) throws HyracksException {
        Collections.sort(binaryURLs, new Comparator<URL>(){

            @Override
            public int compare(URL o1, URL o2) {
                return o1.getFile().compareTo(o2.getFile());
            }
        });
        try {
            if (this.classLoader == null) {
                URL[] urls = binaryURLs.toArray(new URL[binaryURLs.size()]);
                this.classLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
            } else {
                Object[] urls = binaryURLs.toArray(new URL[binaryURLs.size()]);
                Method method = this.classLoader.getClass().getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)this.classLoader, urls);
            }
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
    }

    public Class<?> loadClass(String className) throws HyracksException {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
    }

    public ClassLoader getClassLoader() throws HyracksException {
        return this.classLoader;
    }

    public String toString() {
        return this.classLoader.toString();
    }
}

