/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.common.dataset;

import edu.uci.ics.hyracks.api.dataset.IDatasetManager;
import edu.uci.ics.hyracks.api.dataset.IDatasetStateRecord;
import edu.uci.ics.hyracks.api.job.JobId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResultStateSweeper
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ResultStateSweeper.class.getName());
    private final IDatasetManager datasetManager;
    private final long resultTTL;
    private final long resultSweepThreshold;
    private final List<JobId> toBeCollected;

    public ResultStateSweeper(IDatasetManager datasetManager, long resultTTL, long resultSweepThreshold) {
        this.datasetManager = datasetManager;
        this.resultTTL = resultTTL;
        this.resultSweepThreshold = resultSweepThreshold;
        this.toBeCollected = new ArrayList<JobId>();
    }

    @Override
    public void run() {
        try {
            while (true) {
                Thread.sleep(this.resultSweepThreshold);
                this.sweep();
            }
        }
        catch (InterruptedException e) {
            LOGGER.severe("Result cleaner thread interrupted, but we continue running it.");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sweep() {
        IDatasetManager iDatasetManager = this.datasetManager;
        synchronized (iDatasetManager) {
            this.toBeCollected.clear();
            for (Map.Entry entry : this.datasetManager.getStateMap().entrySet()) {
                if (System.currentTimeMillis() <= ((IDatasetStateRecord)entry.getValue()).getTimestamp() + this.resultTTL) continue;
                this.toBeCollected.add((JobId)entry.getKey());
            }
            for (JobId jobId : this.toBeCollected) {
                this.datasetManager.deinitState(jobId);
            }
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Result state cleanup instance successfully completed.");
        }
    }
}

