/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.common.controllers;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StopOptionHandler;

public class NCConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Option(name="-cc-host", usage="Cluster Controller host name", required=true)
    public String ccHost;
    @Option(name="-cc-port", usage="Cluster Controller port (default: 1099)")
    public int ccPort = 1099;
    @Option(name="-cluster-net-ip-address", usage="IP Address to bind cluster listener", required=true)
    public String clusterNetIPAddress;
    @Option(name="-node-id", usage="Logical name of node controller unique within the cluster", required=true)
    public String nodeId;
    @Option(name="-data-ip-address", usage="IP Address to bind data listener", required=true)
    public String dataIPAddress;
    @Option(name="-result-ip-address", usage="IP Address to bind dataset result distribution listener", required=true)
    public String datasetIPAddress;
    @Option(name="-iodevices", usage="Comma separated list of IO Device mount points (default: One device in default temp folder)", required=false)
    public String ioDevices = System.getProperty("java.io.tmpdir");
    @Option(name="-net-thread-count", usage="Number of threads to use for Network I/O (default: 1)")
    public int nNetThreads = 1;
    @Option(name="-max-memory", usage="Maximum memory usable at this Node Controller in bytes (default: -1 auto)")
    public int maxMemory = -1;
    @Option(name="-result-time-to-live", usage="Limits the amount of time results for asynchronous jobs should be retained by the system in milliseconds. (default: 24 hours)")
    public long resultTTL = 86400000L;
    @Option(name="-result-sweep-threshold", usage="The duration within which an instance of the result cleanup should be invoked in milliseconds. (default: 1 minute)")
    public long resultSweepThreshold = 60000L;
    @Option(name="-result-manager-memory", usage="Memory usable for result caching at this Node Controller in bytes (default: -1 auto)")
    public int resultManagerMemory = -1;
    @Option(name="-app-nc-main-class", usage="Application NC Main Class")
    public String appNCMainClass;
    @Argument
    @Option(name="--", handler=StopOptionHandler.class)
    public List<String> appArgs;

    public void toCommandLine(List<String> cList) {
        cList.add("-cc-host");
        cList.add(this.ccHost);
        cList.add("-cc-port");
        cList.add(String.valueOf(this.ccPort));
        cList.add("-cluster-net-ip-address");
        cList.add(this.clusterNetIPAddress);
        cList.add("-node-id");
        cList.add(this.nodeId);
        cList.add("-data-ip-address");
        cList.add(this.dataIPAddress);
        cList.add(this.datasetIPAddress);
        cList.add("-iodevices");
        cList.add(this.ioDevices);
        cList.add("-net-thread-count");
        cList.add(String.valueOf(this.nNetThreads));
        cList.add("-max-memory");
        cList.add(String.valueOf(this.maxMemory));
        cList.add("-result-time-to-live");
        cList.add(String.valueOf(this.resultTTL));
        cList.add("-result-sweep-threshold");
        cList.add(String.valueOf(this.resultSweepThreshold));
        cList.add("-result-manager-memory");
        cList.add(String.valueOf(this.resultManagerMemory));
        if (this.appNCMainClass != null) {
            cList.add("-app-nc-main-class");
            cList.add(this.appNCMainClass);
        }
        if (this.appArgs != null && !this.appArgs.isEmpty()) {
            cList.add("--");
            for (String appArg : this.appArgs) {
                cList.add(appArg);
            }
        }
    }

    public void toMap(Map<String, String> configuration) {
        configuration.put("cc-host", this.ccHost);
        configuration.put("cc-port", String.valueOf(this.ccPort));
        configuration.put("cluster-net-ip-address", this.clusterNetIPAddress);
        configuration.put("node-id", this.nodeId);
        configuration.put("data-ip-address", this.dataIPAddress);
        configuration.put("iodevices", this.ioDevices);
        configuration.put("net-thread-count", String.valueOf(this.nNetThreads));
        configuration.put("max-memory", String.valueOf(this.maxMemory));
        configuration.put("result-time-to-live", String.valueOf(this.resultTTL));
        configuration.put("result-sweep-threshold", String.valueOf(this.resultSweepThreshold));
        configuration.put("result-manager-memory", String.valueOf(this.resultManagerMemory));
        if (this.appNCMainClass != null) {
            configuration.put("app-nc-main-class", this.appNCMainClass);
        }
    }
}

