/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.data.impl;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.data.IPrinter;
import edu.uci.ics.hyracks.algebricks.data.IPrinterFactory;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import java.io.PrintStream;

public class UTF8StringPrinterFactory
implements IPrinterFactory {
    private static final long serialVersionUID = 1L;
    public static final UTF8StringPrinterFactory INSTANCE = new UTF8StringPrinterFactory();

    private UTF8StringPrinterFactory() {
    }

    @Override
    public IPrinter createPrinter() {
        return new IPrinter(){

            @Override
            public void print(byte[] b, int s, int l, PrintStream ps) throws AlgebricksException {
                int pos;
                int strlen = UTF8StringPointable.getUTFLength((byte[])b, (int)s);
                int maxPos = pos + strlen;
                ps.print("\"");
                for (pos = s + 2; pos < maxPos; pos += UTF8StringPointable.charSize((byte[])b, (int)pos)) {
                    char c = UTF8StringPointable.charAt((byte[])b, (int)pos);
                    switch (c) {
                        case '\"': 
                        case '\\': {
                            ps.print('\\');
                        }
                    }
                    ps.print(c);
                }
                ps.print("\"");
            }

            @Override
            public void init() throws AlgebricksException {
            }
        };
    }
}

