/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.util;

import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputer;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;

public class ReferenceEntry {
    private final int runid;
    private FrameTupleAccessor acccessor;
    private int tupleIndex;
    private int[] tPointers;

    public ReferenceEntry(int runid, FrameTupleAccessor fta, int tupleIndex, int[] keyFields, INormalizedKeyComputer nmkComputer) {
        this.runid = runid;
        this.acccessor = fta;
        this.tPointers = new int[1 + 2 * keyFields.length];
        if (fta != null) {
            this.initTPointer(fta, tupleIndex, keyFields, nmkComputer);
        }
    }

    public int getRunid() {
        return this.runid;
    }

    public FrameTupleAccessor getAccessor() {
        return this.acccessor;
    }

    public void setAccessor(FrameTupleAccessor fta) {
        this.acccessor = fta;
    }

    public int[] getTPointers() {
        return this.tPointers;
    }

    public int getTupleIndex() {
        return this.tupleIndex;
    }

    public int getNormalizedKey() {
        return this.tPointers[0];
    }

    public void setTupleIndex(int tupleIndex, int[] keyFields, INormalizedKeyComputer nmkComputer) {
        this.initTPointer(this.acccessor, tupleIndex, keyFields, nmkComputer);
    }

    private void initTPointer(FrameTupleAccessor fta, int tupleIndex, int[] keyFields, INormalizedKeyComputer nmkComputer) {
        this.tupleIndex = tupleIndex;
        byte[] b1 = fta.getBuffer().array();
        for (int f = 0; f < keyFields.length; ++f) {
            int fIdx = keyFields[f];
            this.tPointers[2 * f + 1] = fta.getTupleStartOffset(tupleIndex) + fta.getFieldSlotsLength() + fta.getFieldStartOffset(tupleIndex, fIdx);
            this.tPointers[2 * f + 2] = fta.getFieldEndOffset(tupleIndex, fIdx) - fta.getFieldStartOffset(tupleIndex, fIdx);
            if (f != 0) continue;
            this.tPointers[0] = nmkComputer != null ? nmkComputer.normalize(b1, this.tPointers[1], this.tPointers[2]) : 0;
        }
    }
}

