/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.util;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOpenableDataWriter;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameDeserializer;
import edu.uci.ics.hyracks.dataflow.common.comm.io.SerializingDataWriter;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.base.IOpenableDataWriterOperator;
import java.nio.ByteBuffer;

public final class DeserializedOperatorNodePushable
extends AbstractUnaryInputOperatorNodePushable {
    private final IHyracksTaskContext ctx;
    private final IOpenableDataWriterOperator delegate;
    private final FrameDeserializer deserializer;

    public DeserializedOperatorNodePushable(IHyracksTaskContext ctx, IOpenableDataWriterOperator delegate, RecordDescriptor inRecordDesc) {
        this.ctx = ctx;
        this.delegate = delegate;
        this.deserializer = inRecordDesc == null ? null : new FrameDeserializer(ctx.getFrameSize(), inRecordDesc);
    }

    public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) throws HyracksDataException {
        this.delegate.setDataWriter(index, (IOpenableDataWriter<Object[]>)new SerializingDataWriter(this.ctx, recordDesc, writer));
    }

    public void close() throws HyracksDataException {
        this.delegate.close();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.deserializer.reset(buffer);
        while (!this.deserializer.done()) {
            this.delegate.writeData(this.deserializer.deserializeRecord());
        }
    }

    public void open() throws HyracksDataException {
        this.delegate.open();
    }

    public void fail() throws HyracksDataException {
        this.delegate.fail();
    }

    @Override
    public String getDisplayName() {
        return "Deserialized(" + this.delegate + ")";
    }
}

