/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.structures;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.std.structures.ISerializableTable;
import edu.uci.ics.hyracks.dataflow.std.structures.IntSerDeBuffer;
import edu.uci.ics.hyracks.dataflow.std.structures.TuplePointer;
import java.util.ArrayList;
import java.util.List;

public class SerializableHashTable
implements ISerializableTable {
    private static final int INT_SIZE = 4;
    private static final int INIT_ENTRY_SIZE = 4;
    private IntSerDeBuffer[] headers;
    private List<IntSerDeBuffer> contents = new ArrayList<IntSerDeBuffer>();
    private List<Integer> frameCurrentIndex = new ArrayList<Integer>();
    private final IHyracksTaskContext ctx;
    private int frameCapacity = 0;
    private int currentLargestFrameIndex = 0;
    private int tupleCount = 0;
    private int headerFrameCount = 0;
    private TuplePointer tempTuplePointer = new TuplePointer();

    public SerializableHashTable(int tableSize, IHyracksTaskContext ctx) throws HyracksDataException {
        this.ctx = ctx;
        int frameSize = ctx.getFrameSize();
        int residual = tableSize * 4 * 2 % frameSize == 0 ? 0 : 1;
        int headerSize = tableSize * 4 * 2 / frameSize + residual;
        this.headers = new IntSerDeBuffer[headerSize];
        IntSerDeBuffer frame = new IntSerDeBuffer(ctx.allocateFrame().array());
        this.contents.add(frame);
        this.frameCurrentIndex.add(0);
        this.frameCapacity = frame.capacity();
    }

    @Override
    public void insert(int entry, TuplePointer pointer) throws HyracksDataException {
        int hFrameIndex = this.getHeaderFrameIndex(entry);
        int headerOffset = this.getHeaderFrameOffset(entry);
        IntSerDeBuffer header = this.headers[hFrameIndex];
        if (header == null) {
            this.headers[hFrameIndex] = header = new IntSerDeBuffer(this.ctx.allocateFrame().array());
            this.resetFrame(header);
            ++this.headerFrameCount;
        }
        int frameIndex = header.getInt(headerOffset);
        int offsetIndex = header.getInt(headerOffset + 1);
        if (frameIndex < 0) {
            this.insertNewEntry(header, headerOffset, 4, pointer);
        } else {
            this.insertNonFirstTuple(header, headerOffset, frameIndex, offsetIndex, pointer);
        }
        ++this.tupleCount;
    }

    @Override
    public void getTuplePointer(int entry, int offset, TuplePointer dataPointer) {
        int startIndex;
        int hFrameIndex = this.getHeaderFrameIndex(entry);
        int headerOffset = this.getHeaderFrameOffset(entry);
        IntSerDeBuffer header = this.headers[hFrameIndex];
        if (header == null) {
            dataPointer.frameIndex = -1;
            dataPointer.tupleIndex = -1;
            return;
        }
        int frameIndex = header.getInt(headerOffset);
        int offsetIndex = header.getInt(headerOffset + 1);
        if (frameIndex < 0) {
            dataPointer.frameIndex = -1;
            dataPointer.tupleIndex = -1;
            return;
        }
        IntSerDeBuffer frame = this.contents.get(frameIndex);
        int entryUsedItems = frame.getInt(offsetIndex + 1);
        if (offset > entryUsedItems - 1) {
            dataPointer.frameIndex = -1;
            dataPointer.tupleIndex = -1;
            return;
        }
        for (startIndex = offsetIndex + 2 + offset * 2; startIndex >= this.frameCapacity; startIndex -= this.frameCapacity) {
            ++frameIndex;
        }
        frame = this.contents.get(frameIndex);
        dataPointer.frameIndex = frame.getInt(startIndex);
        dataPointer.tupleIndex = frame.getInt(startIndex + 1);
    }

    @Override
    public void reset() {
        for (IntSerDeBuffer frame : this.headers) {
            if (frame == null) continue;
            this.resetFrame(frame);
        }
        this.frameCurrentIndex.clear();
        for (int i = 0; i < this.contents.size(); ++i) {
            this.frameCurrentIndex.add(0);
        }
        this.currentLargestFrameIndex = 0;
        this.tupleCount = 0;
    }

    @Override
    public int getFrameCount() {
        return this.headerFrameCount + this.contents.size();
    }

    @Override
    public int getTupleCount() {
        return this.tupleCount;
    }

    @Override
    public void close() {
        int nFrames = this.contents.size();
        for (int i = 0; i < this.headers.length; ++i) {
            this.headers[i] = null;
        }
        this.contents.clear();
        this.frameCurrentIndex.clear();
        this.tupleCount = 0;
        this.currentLargestFrameIndex = 0;
        this.ctx.deallocateFrames(nFrames);
    }

    private void insertNewEntry(IntSerDeBuffer header, int headerOffset, int entryCapacity, TuplePointer pointer) throws HyracksDataException {
        IntSerDeBuffer lastFrame = this.contents.get(this.currentLargestFrameIndex);
        int lastIndex = this.frameCurrentIndex.get(this.currentLargestFrameIndex);
        int requiredIntCapacity = entryCapacity * 2;
        int startFrameIndex = this.currentLargestFrameIndex;
        if (lastIndex + requiredIntCapacity >= this.frameCapacity) {
            ++startFrameIndex;
            do {
                if (this.currentLargestFrameIndex >= this.contents.size() - 1) {
                    IntSerDeBuffer newFrame = new IntSerDeBuffer(this.ctx.allocateFrame().array());
                    ++this.currentLargestFrameIndex;
                    this.contents.add(newFrame);
                    this.frameCurrentIndex.add(0);
                    continue;
                }
                ++this.currentLargestFrameIndex;
                this.frameCurrentIndex.set(this.currentLargestFrameIndex, 0);
            } while ((requiredIntCapacity -= this.frameCapacity) > 0);
            lastIndex = 0;
            lastFrame = this.contents.get(startFrameIndex);
        }
        header.writeInt(headerOffset, startFrameIndex);
        header.writeInt(headerOffset + 1, lastIndex);
        lastFrame.writeInt(lastIndex, entryCapacity - 1);
        lastFrame.writeInt(lastIndex + 1, 1);
        lastFrame.writeInt(lastIndex + 2, pointer.frameIndex);
        lastFrame.writeInt(lastIndex + 3, pointer.tupleIndex);
        int newLastIndex = lastIndex + entryCapacity * 2;
        newLastIndex = newLastIndex < this.frameCapacity ? newLastIndex : this.frameCapacity - 1;
        this.frameCurrentIndex.set(startFrameIndex, newLastIndex);
        requiredIntCapacity = entryCapacity * 2 - (this.frameCapacity - lastIndex);
        while (requiredIntCapacity > 0) {
            newLastIndex = (requiredIntCapacity -= this.frameCapacity) < 0 ? requiredIntCapacity + this.frameCapacity : this.frameCapacity - 1;
            this.frameCurrentIndex.set(++startFrameIndex, newLastIndex);
        }
    }

    private void insertNonFirstTuple(IntSerDeBuffer header, int headerOffset, int frameIndex, int offsetIndex, TuplePointer pointer) throws HyracksDataException {
        IntSerDeBuffer frame = this.contents.get(frameIndex);
        int entryItems = frame.getInt(offsetIndex);
        int entryUsedItems = frame.getInt(offsetIndex + 1);
        if (entryUsedItems < entryItems) {
            int startIndex;
            frame.writeInt(offsetIndex + 1, entryUsedItems + 1);
            for (startIndex = offsetIndex + 2 + entryUsedItems * 2; startIndex >= this.frameCapacity; startIndex -= this.frameCapacity) {
                ++frameIndex;
            }
            frame = this.contents.get(frameIndex);
            frame.writeInt(startIndex, pointer.frameIndex);
            frame.writeInt(startIndex + 1, pointer.tupleIndex);
        } else {
            int capacity = (entryItems + 1) * 2;
            header.writeInt(headerOffset, -1);
            header.writeInt(headerOffset + 1, -1);
            int fIndex = frame.getInt(offsetIndex + 2);
            int tIndex = frame.getInt(offsetIndex + 3);
            this.tempTuplePointer.frameIndex = fIndex;
            this.tempTuplePointer.tupleIndex = tIndex;
            this.insertNewEntry(header, headerOffset, capacity, this.tempTuplePointer);
            int newFrameIndex = header.getInt(headerOffset);
            int newTupleIndex = header.getInt(headerOffset + 1);
            for (int i = 1; i < entryUsedItems; ++i) {
                int startIndex;
                int startFrameIndex = frameIndex;
                for (startIndex = offsetIndex + 2 + i * 2; startIndex >= this.frameCapacity; startIndex -= this.frameCapacity) {
                    ++startFrameIndex;
                }
                frame = this.contents.get(startFrameIndex);
                fIndex = frame.getInt(startIndex);
                tIndex = frame.getInt(startIndex + 1);
                this.tempTuplePointer.frameIndex = fIndex;
                this.tempTuplePointer.tupleIndex = tIndex;
                this.insertNonFirstTuple(header, headerOffset, newFrameIndex, newTupleIndex, this.tempTuplePointer);
            }
            this.insertNonFirstTuple(header, headerOffset, newFrameIndex, newTupleIndex, pointer);
        }
    }

    private void resetFrame(IntSerDeBuffer frame) {
        for (int i = 0; i < this.frameCapacity; ++i) {
            frame.writeInt(i, -1);
        }
    }

    private int getHeaderFrameIndex(int entry) {
        int frameIndex = entry * 2 / this.frameCapacity;
        return frameIndex;
    }

    private int getHeaderFrameOffset(int entry) {
        int offset = entry * 2 % this.frameCapacity;
        return offset;
    }
}

