/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.sort;

import edu.uci.ics.hyracks.api.context.IHyracksCommonContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.std.sort.IMemoryManager;
import edu.uci.ics.hyracks.dataflow.std.sort.ISelectionTree;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SortMinMaxHeap
implements ISelectionTree {
    static final int RUN_ID_IX = 0;
    static final int FRAME_IX = 1;
    static final int OFFSET_IX = 2;
    private static final int PNK_IX = 3;
    private static final int NOT_EXIST = -1;
    private static final int ELEMENT_SIZE = 4;
    private static final int INIT_ARRAY_SIZE = 512;
    private final int[] sortFields;
    private final IBinaryComparator[] comparators;
    private final RecordDescriptor recordDescriptor;
    private final FrameTupleAccessor fta1;
    private final FrameTupleAccessor fta2;
    private int[] elements;
    private int nextIx;
    private final IMemoryManager memMgr;

    public SortMinMaxHeap(IHyracksCommonContext ctx, int[] sortFields, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDesc, IMemoryManager memMgr) {
        this.sortFields = sortFields;
        this.comparators = new IBinaryComparator[comparatorFactories.length];
        for (int i = 0; i < comparatorFactories.length; ++i) {
            this.comparators[i] = comparatorFactories[i].createBinaryComparator();
        }
        this.recordDescriptor = recordDesc;
        this.fta1 = new FrameTupleAccessor(ctx.getFrameSize(), this.recordDescriptor);
        this.fta2 = new FrameTupleAccessor(ctx.getFrameSize(), this.recordDescriptor);
        this.memMgr = memMgr;
        this.elements = new int[512];
        Arrays.fill(this.elements, -1);
        this.nextIx = 0;
    }

    @Override
    public void insert(int[] element) {
        if (this.nextIx >= this.elements.length) {
            this.elements = Arrays.copyOf(this.elements, this.elements.length * 2);
        }
        for (int i = 0; i < 4; ++i) {
            this.elements[this.nextIx + i] = element[i];
        }
        this.nextIx += 4;
        this.bubbleUp(this.nextIx - 4);
    }

    @Override
    public void getMin(int[] result) {
        if (this.nextIx == 0) {
            result[3] = -1;
            result[2] = -1;
            result[1] = -1;
            result[0] = -1;
            return;
        }
        int[] topElem = this.delete(0);
        for (int x = 0; x < 4; ++x) {
            result[x] = topElem[x];
        }
    }

    @Override
    public void reset() {
        Arrays.fill(this.elements, -1);
        this.nextIx = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.nextIx < 4;
    }

    @Override
    public void peekMin(int[] result) {
        if (this.nextIx == 0) {
            result[3] = -1;
            result[2] = -1;
            result[1] = -1;
            result[0] = -1;
            return;
        }
        for (int x = 0; x < 4; ++x) {
            result[x] = this.elements[x];
        }
    }

    @Override
    public void getMax(int[] result) {
        if (this.nextIx == 4) {
            int[] topElement = this.removeLast();
            for (int x = 0; x < 4; ++x) {
                result[x] = topElement[x];
            }
            return;
        }
        if (this.nextIx > 4) {
            int lc = this.getLeftChild(0);
            int rc = this.getRightChild(0);
            int maxIx = lc;
            if (rc != -1) {
                maxIx = this.compare(lc, rc) < 0 ? rc : lc;
            }
            int[] maxElem = this.delete(maxIx);
            for (int x = 0; x < 4; ++x) {
                result[x] = maxElem[x];
            }
            return;
        }
        result[3] = -1;
        result[2] = -1;
        result[1] = -1;
        result[0] = -1;
    }

    @Override
    public void peekMax(int[] result) {
        if (this.nextIx == 4) {
            for (int i = 0; i < 4; ++i) {
                result[i] = this.elements[i];
            }
            return;
        }
        if (this.nextIx > 4) {
            int lc = this.getLeftChild(0);
            int rc = this.getRightChild(0);
            int maxIx = lc;
            if (rc != -1) {
                maxIx = this.compare(lc, rc) < 0 ? rc : lc;
            }
            for (int x = 0; x < 4; ++x) {
                result[x] = this.elements[maxIx + x];
            }
            return;
        }
        result[3] = -1;
        result[2] = -1;
        result[1] = -1;
        result[0] = -1;
    }

    private int[] delete(int delIx) {
        int s = this.nextIx;
        if (this.nextIx > 4) {
            int[] delEntry = Arrays.copyOfRange(this.elements, delIx, delIx + 4);
            int[] last = this.removeLast();
            if (delIx != s - 4) {
                for (int x = 0; x < 4; ++x) {
                    this.elements[delIx + x] = last[x];
                }
                this.trickleDown(delIx);
            }
            return delEntry;
        }
        if (this.nextIx == 4) {
            return this.removeLast();
        }
        return null;
    }

    private int[] removeLast() {
        if (this.nextIx < 4) {
            return new int[]{-1, -1, -1, -1};
        }
        int[] l = Arrays.copyOfRange(this.elements, this.nextIx - 4, this.nextIx);
        Arrays.fill(this.elements, this.nextIx - 4, this.nextIx, -1);
        this.nextIx -= 4;
        return l;
    }

    private void bubbleUp(int ix) {
        int p = this.getParentIx(ix);
        if (this.isAtMinLevel(ix)) {
            if (p != -1 && this.compare(p, ix) < 0) {
                this.swap(ix, p);
                this.bubbleUpMax(p);
            } else {
                this.bubbleUpMin(ix);
            }
        } else if (p != -1 && this.compare(ix, p) < 0) {
            this.swap(ix, p);
            this.bubbleUpMin(p);
        } else {
            this.bubbleUpMax(ix);
        }
    }

    private void bubbleUpMax(int ix) {
        int gp = this.getGrandParent(ix);
        if (gp != -1 && this.compare(gp, ix) < 0) {
            this.swap(ix, gp);
            this.bubbleUpMax(gp);
        }
    }

    private void bubbleUpMin(int ix) {
        int gp = this.getGrandParent(ix);
        if (gp != -1 && this.compare(ix, gp) < 0) {
            this.swap(ix, gp);
            this.bubbleUpMin(gp);
        }
    }

    private void trickleDown(int ix) {
        if (this.isAtMinLevel(ix)) {
            this.trickleDownMin(ix);
        } else {
            this.trickleDownMax(ix);
        }
    }

    private void trickleDownMax(int ix) {
        int maxIx = this.getMaxOfDescendents(ix);
        if (maxIx == -1) {
            return;
        }
        if (maxIx > this.getLeftChild(ix) && maxIx > this.getRightChild(ix)) {
            if (this.compare(ix, maxIx) < 0) {
                this.swap(maxIx, ix);
                int p = this.getParentIx(maxIx);
                if (p != -1 && this.compare(maxIx, p) < 0) {
                    this.swap(maxIx, p);
                }
                this.trickleDownMax(maxIx);
            }
        } else if (this.compare(ix, maxIx) < 0) {
            this.swap(ix, maxIx);
        }
    }

    private void trickleDownMin(int ix) {
        int minIx = this.getMinOfDescendents(ix);
        if (minIx == -1) {
            return;
        }
        if (minIx > this.getLeftChild(ix) && minIx > this.getRightChild(ix)) {
            if (this.compare(minIx, ix) < 0) {
                this.swap(minIx, ix);
                int p = this.getParentIx(minIx);
                if (p != -1 && this.compare(p, minIx) < 0) {
                    this.swap(minIx, p);
                }
                this.trickleDownMin(minIx);
            }
        } else if (this.compare(minIx, ix) < 0) {
            this.swap(ix, minIx);
        }
    }

    private int getMinOfDescendents(int ix) {
        int lc = this.getLeftChild(ix);
        if (lc == -1) {
            return -1;
        }
        int rc = this.getRightChild(ix);
        if (rc == -1) {
            return lc;
        }
        int min = this.compare(lc, rc) < 0 ? lc : rc;
        int[] lgc = this.getLeftGrandChildren(ix);
        int[] rgc = this.getRightGrandChildren(ix);
        for (int k = 0; k < 2; ++k) {
            if (lgc[k] != -1 && this.compare(lgc[k], min) < 0) {
                min = lgc[k];
            }
            if (rgc[k] == -1 || this.compare(rgc[k], min) >= 0) continue;
            min = rgc[k];
        }
        return min;
    }

    private int getMaxOfDescendents(int ix) {
        int lc = this.getLeftChild(ix);
        if (lc == -1) {
            return -1;
        }
        int rc = this.getRightChild(ix);
        if (rc == -1) {
            return lc;
        }
        int max = this.compare(lc, rc) < 0 ? rc : lc;
        int[] lgc = this.getLeftGrandChildren(ix);
        int[] rgc = this.getRightGrandChildren(ix);
        for (int k = 0; k < 2; ++k) {
            if (lgc[k] != -1 && this.compare(max, lgc[k]) < 0) {
                max = lgc[k];
            }
            if (rgc[k] == -1 || this.compare(max, rgc[k]) >= 0) continue;
            max = rgc[k];
        }
        return max;
    }

    private void swap(int n1Ix, int n2Ix) {
        int[] temp = Arrays.copyOfRange(this.elements, n1Ix, n1Ix + 4);
        for (int i = 0; i < 4; ++i) {
            this.elements[n1Ix + i] = this.elements[n2Ix + i];
            this.elements[n2Ix + i] = temp[i];
        }
    }

    private int getParentIx(int i) {
        if (i < 4) {
            return -1;
        }
        return (i - 4) / 8 * 4;
    }

    private int getGrandParent(int i) {
        int p = this.getParentIx(i);
        return p != -1 ? this.getParentIx(p) : -1;
    }

    private int getLeftChild(int i) {
        int lc = 8 * (i / 4) + 4;
        return lc < this.nextIx ? lc : -1;
    }

    private int[] getLeftGrandChildren(int i) {
        int[] nArray;
        int lc = this.getLeftChild(i);
        if (lc != -1) {
            int[] nArray2 = new int[2];
            nArray2[0] = this.getLeftChild(lc);
            nArray = nArray2;
            nArray2[1] = this.getRightChild(lc);
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = -1;
            nArray = nArray3;
            nArray3[1] = -1;
        }
        return nArray;
    }

    private int getRightChild(int i) {
        int rc = 8 * (i / 4) + 8;
        return rc < this.nextIx ? rc : -1;
    }

    private int[] getRightGrandChildren(int i) {
        int[] nArray;
        int rc = this.getRightChild(i);
        if (rc != -1) {
            int[] nArray2 = new int[2];
            nArray2[0] = this.getLeftChild(rc);
            nArray = nArray2;
            nArray2[1] = this.getRightChild(rc);
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = -1;
            nArray = nArray3;
            nArray3[1] = -1;
        }
        return nArray;
    }

    private boolean isAtMinLevel(int i) {
        int l = this.getLevel(i);
        return l % 2 == 0;
    }

    private int getLevel(int i) {
        if (i < 4) {
            return 0;
        }
        int cnv = i / 4;
        int l = (int)Math.floor(Math.log(cnv) / Math.log(2.0));
        if (cnv == (int)Math.pow(2.0, l + 1) - 1) {
            return l + 1;
        }
        return l;
    }

    private ByteBuffer getFrame(int frameIx) {
        return this.memMgr.getFrame(frameIx);
    }

    private int compare(int nodeSIx1, int nodeSIx2) {
        int[] n1 = Arrays.copyOfRange(this.elements, nodeSIx1, nodeSIx1 + 4);
        int[] n2 = Arrays.copyOfRange(this.elements, nodeSIx2, nodeSIx2 + 4);
        return this.compare(n1, n2);
    }

    private int compare(int[] n1, int[] n2) {
        if (n1[0] != n2[0]) {
            return n1[0] < n2[0] ? -1 : 1;
        }
        if (n1[3] != n2[3]) {
            return ((long)n1[3] & 0xFFFFFFFFL) < ((long)n2[3] & 0xFFFFFFFFL) ? -1 : 1;
        }
        return this.compare(this.getFrame(n1[1]), this.getFrame(n2[1]), n1[2], n2[2]);
    }

    private int compare(ByteBuffer fr1, ByteBuffer fr2, int r1StartOffset, int r2StartOffset) {
        byte[] b1 = fr1.array();
        byte[] b2 = fr2.array();
        this.fta1.reset(fr1);
        this.fta2.reset(fr2);
        int headerLen = 2;
        r1StartOffset += headerLen;
        r2StartOffset += headerLen;
        for (int f = 0; f < this.comparators.length; ++f) {
            int l2;
            int fIdx = this.sortFields[f];
            int f1Start = fIdx == 0 ? 0 : fr1.getInt(r1StartOffset + (fIdx - 1) * 4);
            int f1End = fr1.getInt(r1StartOffset + fIdx * 4);
            int s1 = r1StartOffset + this.fta1.getFieldSlotsLength() + f1Start;
            int l1 = f1End - f1Start;
            int f2Start = fIdx == 0 ? 0 : fr2.getInt(r2StartOffset + (fIdx - 1) * 4);
            int f2End = fr2.getInt(r2StartOffset + fIdx * 4);
            int s2 = r2StartOffset + this.fta2.getFieldSlotsLength() + f2Start;
            int c = this.comparators[f].compare(b1, s1, l1, b2, s2, l2 = f2End - f2Start);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }
}

