/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.sort;

import edu.uci.ics.hyracks.api.context.IHyracksCommonContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.std.sort.IMemoryManager;
import edu.uci.ics.hyracks.dataflow.std.sort.ISelectionTree;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SortMinHeap
implements ISelectionTree {
    static final int RUN_ID_IX = 0;
    static final int FRAME_IX = 1;
    static final int OFFSET_IX = 2;
    private static final int PNK_IX = 3;
    private static final int ELEMENT_SIZE = 4;
    private static final int INIT_ARRAY_SIZE = 512;
    private final int[] sortFields;
    private final IBinaryComparator[] comparators;
    private final RecordDescriptor recordDescriptor;
    private final FrameTupleAccessor fta1;
    private final FrameTupleAccessor fta2;
    private int[] elements;
    private int nextIx;
    private final IMemoryManager memMgr;
    private int[] top;

    public SortMinHeap(IHyracksCommonContext ctx, int[] sortFields, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDesc, IMemoryManager memMgr) {
        this.sortFields = sortFields;
        this.comparators = new IBinaryComparator[comparatorFactories.length];
        for (int i = 0; i < comparatorFactories.length; ++i) {
            this.comparators[i] = comparatorFactories[i].createBinaryComparator();
        }
        this.recordDescriptor = recordDesc;
        this.fta1 = new FrameTupleAccessor(ctx.getFrameSize(), this.recordDescriptor);
        this.fta2 = new FrameTupleAccessor(ctx.getFrameSize(), this.recordDescriptor);
        this.memMgr = memMgr;
        this.top = new int[4];
        Arrays.fill(this.top, -1);
        this.elements = new int[512];
        Arrays.fill(this.elements, -1);
        this.nextIx = 0;
    }

    @Override
    public void getMin(int[] result) {
        if (this.nextIx == 0) {
            result[3] = -1;
            result[2] = -1;
            result[1] = -1;
            result[0] = -1;
            return;
        }
        this.top = this.delete(0);
        for (int i = 0; i < this.top.length; ++i) {
            result[i] = this.top[i];
        }
    }

    @Override
    public void peekMin(int[] result) {
        if (this.nextIx == 0) {
            result[3] = -1;
            result[2] = -1;
            result[1] = -1;
            result[0] = -1;
            return;
        }
        for (int i = 0; i < 4; ++i) {
            result[i] = this.elements[i];
        }
    }

    @Override
    public void insert(int[] e) {
        if (this.nextIx >= this.elements.length) {
            this.elements = Arrays.copyOf(this.elements, this.elements.length * 2);
        }
        for (int i = 0; i < 4; ++i) {
            this.elements[this.nextIx + i] = e[i];
        }
        this.siftUp(this.nextIx);
        this.nextIx += 4;
    }

    @Override
    public void reset() {
        Arrays.fill(this.elements, -1);
        this.nextIx = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.nextIx < 4;
    }

    public int _debugGetSize() {
        return this.nextIx > 0 ? (this.nextIx - 1) / 4 : 0;
    }

    private int[] delete(int nix) {
        int[] nv = Arrays.copyOfRange(this.elements, nix, nix + 4);
        int[] lastElem = this.removeLast();
        if (this.nextIx == 0) {
            return nv;
        }
        for (int i = 0; i < 4; ++i) {
            this.elements[nix + i] = lastElem[i];
        }
        int pIx = this.getParent(nix);
        if (pIx > -1 && this.compare(lastElem, Arrays.copyOfRange(this.elements, pIx, pIx + 4)) < 0) {
            this.siftUp(nix);
        } else {
            this.siftDown(nix);
        }
        return nv;
    }

    private int[] removeLast() {
        if (this.nextIx < 4) {
            return new int[]{-1, -1, -1, -1};
        }
        int[] l = Arrays.copyOfRange(this.elements, this.nextIx - 4, this.nextIx);
        Arrays.fill(this.elements, this.nextIx - 4, this.nextIx, -1);
        this.nextIx -= 4;
        return l;
    }

    private void siftUp(int nodeIx) {
        int p = this.getParent(nodeIx);
        if (p < 0) {
            return;
        }
        while (p > -1 && this.compare(nodeIx, p) < 0) {
            this.swap(p, nodeIx);
            nodeIx = p;
            if ((p = this.getParent(nodeIx)) >= 0) continue;
            return;
        }
    }

    private void siftDown(int nodeIx) {
        int mix = this.getMinOfChildren(nodeIx);
        if (mix < 0) {
            return;
        }
        while (mix > -1 && this.compare(mix, nodeIx) < 0) {
            this.swap(mix, nodeIx);
            nodeIx = mix;
            if ((mix = this.getMinOfChildren(nodeIx)) >= 0) continue;
            return;
        }
    }

    private int compare(int nodeSIx1, int nodeSIx2) {
        int[] n1 = Arrays.copyOfRange(this.elements, nodeSIx1, nodeSIx1 + 4);
        int[] n2 = Arrays.copyOfRange(this.elements, nodeSIx2, nodeSIx2 + 4);
        return this.compare(n1, n2);
    }

    private int compare(int[] n1, int[] n2) {
        if (n1[0] != n2[0]) {
            return n1[0] < n2[0] ? -1 : 1;
        }
        if (n1[3] != n2[3]) {
            return ((long)n1[3] & 0xFFFFFFFFL) < ((long)n2[3] & 0xFFFFFFFFL) ? -1 : 1;
        }
        return this.compare(this.getFrame(n1[1]), this.getFrame(n2[1]), n1[2], n2[2]);
    }

    private int compare(ByteBuffer fr1, ByteBuffer fr2, int r1StartOffset, int r2StartOffset) {
        byte[] b1 = fr1.array();
        byte[] b2 = fr2.array();
        this.fta1.reset(fr1);
        this.fta2.reset(fr2);
        int headerLen = 2;
        r1StartOffset += headerLen;
        r2StartOffset += headerLen;
        for (int f = 0; f < this.comparators.length; ++f) {
            int l2;
            int fIdx = this.sortFields[f];
            int f1Start = fIdx == 0 ? 0 : fr1.getInt(r1StartOffset + (fIdx - 1) * 4);
            int f1End = fr1.getInt(r1StartOffset + fIdx * 4);
            int s1 = r1StartOffset + this.fta1.getFieldSlotsLength() + f1Start;
            int l1 = f1End - f1Start;
            int f2Start = fIdx == 0 ? 0 : fr2.getInt(r2StartOffset + (fIdx - 1) * 4);
            int f2End = fr2.getInt(r2StartOffset + fIdx * 4);
            int s2 = r2StartOffset + this.fta2.getFieldSlotsLength() + f2Start;
            int c = this.comparators[f].compare(b1, s1, l1, b2, s2, l2 = f2End - f2Start);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private int getMinOfChildren(int nix) {
        int lix = this.getLeftChild(nix);
        if (lix < 0) {
            return -1;
        }
        int rix = this.getRightChild(nix);
        if (rix < 0) {
            return lix;
        }
        return this.compare(lix, rix) < 0 ? lix : rix;
    }

    private void swap(int n1Ix, int n2Ix) {
        int[] temp = Arrays.copyOfRange(this.elements, n1Ix, n1Ix + 4);
        for (int i = 0; i < 4; ++i) {
            this.elements[n1Ix + i] = this.elements[n2Ix + i];
            this.elements[n2Ix + i] = temp[i];
        }
    }

    private int getLeftChild(int ix) {
        int lix = 8 * (ix / 4) + 4;
        return lix < this.nextIx ? lix : -1;
    }

    private int getRightChild(int ix) {
        int rix = 8 * (ix / 4) + 8;
        return rix < this.nextIx ? rix : -1;
    }

    private int getParent(int ix) {
        if (ix <= 0) {
            return -1;
        }
        return (ix - 4) / 8 * 4;
    }

    private ByteBuffer getFrame(int frameIx) {
        return this.memMgr.getFrame(frameIx);
    }

    @Override
    public void getMax(int[] result) {
        throw new IllegalStateException("getMax() method not applicable to Min Heap");
    }

    @Override
    public void peekMax(int[] result) {
        throw new IllegalStateException("getMax() method not applicable to Min Heap");
    }
}

