/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.sort;

import edu.uci.ics.hyracks.api.comm.IFrameReader;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputer;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.std.util.ReferenceEntry;
import edu.uci.ics.hyracks.dataflow.std.util.ReferencedPriorityQueue;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;

public class RunMergingFrameReader
implements IFrameReader {
    private final IHyracksTaskContext ctx;
    private final IFrameReader[] runCursors;
    private final List<ByteBuffer> inFrames;
    private final int[] sortFields;
    private final IBinaryComparator[] comparators;
    private final INormalizedKeyComputer nmkComputer;
    private final RecordDescriptor recordDesc;
    private final FrameTupleAppender outFrameAppender;
    private ReferencedPriorityQueue topTuples;
    private int[] tupleIndexes;
    private FrameTupleAccessor[] tupleAccessors;

    public RunMergingFrameReader(IHyracksTaskContext ctx, IFrameReader[] runCursors, List<ByteBuffer> inFrames, int[] sortFields, IBinaryComparator[] comparators, INormalizedKeyComputer nmkComputer, RecordDescriptor recordDesc) {
        this.ctx = ctx;
        this.runCursors = runCursors;
        this.inFrames = inFrames;
        this.sortFields = sortFields;
        this.comparators = comparators;
        this.nmkComputer = nmkComputer;
        this.recordDesc = recordDesc;
        this.outFrameAppender = new FrameTupleAppender(ctx.getFrameSize());
    }

    public void open() throws HyracksDataException {
        this.tupleAccessors = new FrameTupleAccessor[this.runCursors.length];
        Comparator<ReferenceEntry> comparator = this.createEntryComparator(this.comparators);
        this.topTuples = new ReferencedPriorityQueue(this.ctx.getFrameSize(), this.recordDesc, this.runCursors.length, comparator, this.sortFields, this.nmkComputer);
        this.tupleIndexes = new int[this.runCursors.length];
        for (int i = 0; i < this.runCursors.length; ++i) {
            this.tupleIndexes[i] = 0;
            int runIndex = this.topTuples.peek().getRunid();
            this.runCursors[runIndex].open();
            if (this.runCursors[runIndex].nextFrame(this.inFrames.get(runIndex))) {
                this.tupleAccessors[runIndex] = new FrameTupleAccessor(this.ctx.getFrameSize(), this.recordDesc);
                this.tupleAccessors[runIndex].reset(this.inFrames.get(runIndex));
                this.setNextTopTuple(runIndex, this.tupleIndexes, this.runCursors, this.tupleAccessors, this.topTuples);
                continue;
            }
            this.closeRun(runIndex, this.runCursors, (IFrameTupleAccessor[])this.tupleAccessors);
            this.topTuples.pop();
        }
    }

    public boolean nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.outFrameAppender.reset(buffer, true);
        while (!this.topTuples.areRunsExhausted()) {
            int tupleIndex;
            ReferenceEntry top = this.topTuples.peek();
            int runIndex = top.getRunid();
            FrameTupleAccessor fta = top.getAccessor();
            if (!this.outFrameAppender.append((IFrameTupleAccessor)fta, tupleIndex = top.getTupleIndex())) {
                return true;
            }
            int n = runIndex;
            this.tupleIndexes[n] = this.tupleIndexes[n] + 1;
            this.setNextTopTuple(runIndex, this.tupleIndexes, this.runCursors, this.tupleAccessors, this.topTuples);
        }
        return this.outFrameAppender.getTupleCount() > 0;
    }

    public void close() throws HyracksDataException {
        for (int i = 0; i < this.runCursors.length; ++i) {
            this.closeRun(i, this.runCursors, (IFrameTupleAccessor[])this.tupleAccessors);
        }
    }

    private void setNextTopTuple(int runIndex, int[] tupleIndexes, IFrameReader[] runCursors, FrameTupleAccessor[] tupleAccessors, ReferencedPriorityQueue topTuples) throws HyracksDataException {
        boolean exists = this.hasNextTuple(runIndex, tupleIndexes, runCursors, tupleAccessors);
        if (exists) {
            topTuples.popAndReplace(tupleAccessors[runIndex], tupleIndexes[runIndex]);
        } else {
            topTuples.pop();
            this.closeRun(runIndex, runCursors, (IFrameTupleAccessor[])tupleAccessors);
        }
    }

    private boolean hasNextTuple(int runIndex, int[] tupleIndexes, IFrameReader[] runCursors, FrameTupleAccessor[] tupleAccessors) throws HyracksDataException {
        if (tupleAccessors[runIndex] == null || runCursors[runIndex] == null) {
            return false;
        }
        if (tupleIndexes[runIndex] >= tupleAccessors[runIndex].getTupleCount()) {
            ByteBuffer buf = tupleAccessors[runIndex].getBuffer();
            if (runCursors[runIndex].nextFrame(buf)) {
                tupleIndexes[runIndex] = 0;
                return this.hasNextTuple(runIndex, tupleIndexes, runCursors, tupleAccessors);
            }
            return false;
        }
        return true;
    }

    private void closeRun(int index, IFrameReader[] runCursors, IFrameTupleAccessor[] tupleAccessors) throws HyracksDataException {
        if (runCursors[index] != null) {
            runCursors[index].close();
            runCursors[index] = null;
            tupleAccessors[index] = null;
        }
    }

    private Comparator<ReferenceEntry> createEntryComparator(final IBinaryComparator[] comparators) {
        return new Comparator<ReferenceEntry>(){

            @Override
            public int compare(ReferenceEntry tp1, ReferenceEntry tp2) {
                int nmk2;
                int nmk1 = tp1.getNormalizedKey();
                if (nmk1 > (nmk2 = tp1.getNormalizedKey())) {
                    return 1;
                }
                if (nmk1 < nmk2) {
                    return -1;
                }
                FrameTupleAccessor fta1 = tp1.getAccessor();
                FrameTupleAccessor fta2 = tp2.getAccessor();
                byte[] b1 = fta1.getBuffer().array();
                byte[] b2 = fta2.getBuffer().array();
                int[] tPointers1 = tp1.getTPointers();
                int[] tPointers2 = tp2.getTPointers();
                for (int f = 0; f < RunMergingFrameReader.this.sortFields.length; ++f) {
                    int c = comparators[f].compare(b1, tPointers1[2 * f + 1], tPointers1[2 * f + 2], b2, tPointers2[2 * f + 1], tPointers2[2 * f + 2]);
                    if (c == 0) continue;
                    return c;
                }
                return 0;
            }
        };
    }
}

