/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.sort;

import edu.uci.ics.hyracks.api.comm.IFrameReader;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksCommonContext;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputer;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileWriter;
import edu.uci.ics.hyracks.dataflow.std.sort.BSTMemMgr;
import edu.uci.ics.hyracks.dataflow.std.sort.ExternalSortRunGenerator;
import edu.uci.ics.hyracks.dataflow.std.sort.IMemoryManager;
import edu.uci.ics.hyracks.dataflow.std.sort.IRunGenerator;
import edu.uci.ics.hyracks.dataflow.std.sort.ISelectionTree;
import edu.uci.ics.hyracks.dataflow.std.sort.Slot;
import edu.uci.ics.hyracks.dataflow.std.sort.SortMinMaxHeap;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class OptimizedExternalSortRunGeneratorWithLimit
implements IRunGenerator {
    private final IHyracksTaskContext ctx;
    private final int[] sortFields;
    private final INormalizedKeyComputer nkc;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final IBinaryComparator[] comparators;
    private final RecordDescriptor recordDescriptor;
    private final List<IFrameReader> runs;
    private ISelectionTree sTree;
    private IMemoryManager memMgr;
    private final int memSize;
    private FrameTupleAccessor inputAccessor;
    private FrameTupleAppender outputAppender;
    private ByteBuffer outputBuffer;
    private FrameTupleAccessor lastRecordAccessor;
    private FrameTupleAccessor fta2;
    private final int outputLimit;
    private int curRunSize;
    private int nextRunSize;
    private int lastTupleIx;
    private Slot allocationPtr;
    private Slot outputedTuple;
    private Slot discard;
    private int[] sTreeTop;
    private int[] peek;
    private RunFileWriter writer;
    private boolean newRun;
    private int curRunId;

    public OptimizedExternalSortRunGeneratorWithLimit(IHyracksTaskContext ctx, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDesc, int memSize, int limit) {
        this.ctx = ctx;
        this.sortFields = sortFields;
        this.nkc = firstKeyNormalizerFactory == null ? null : firstKeyNormalizerFactory.createNormalizedKeyComputer();
        this.comparatorFactories = comparatorFactories;
        this.comparators = new IBinaryComparator[comparatorFactories.length];
        for (int i = 0; i < comparatorFactories.length; ++i) {
            this.comparators[i] = comparatorFactories[i].createBinaryComparator();
        }
        this.recordDescriptor = recordDesc;
        this.runs = new LinkedList<IFrameReader>();
        this.memSize = memSize;
        this.outputLimit = limit;
    }

    public void open() throws HyracksDataException {
        this.runs.clear();
        this.inputAccessor = new FrameTupleAccessor(this.ctx.getFrameSize(), this.recordDescriptor);
        this.outputAppender = new FrameTupleAppender(this.ctx.getFrameSize());
        this.outputBuffer = this.ctx.allocateFrame();
        this.outputAppender.reset(this.outputBuffer, true);
        this.lastRecordAccessor = new FrameTupleAccessor(this.ctx.getFrameSize(), this.recordDescriptor);
        this.fta2 = new FrameTupleAccessor(this.ctx.getFrameSize(), this.recordDescriptor);
        this.memMgr = new BSTMemMgr(this.ctx, this.memSize);
        this.sTree = new SortMinMaxHeap((IHyracksCommonContext)this.ctx, this.sortFields, this.comparatorFactories, this.recordDescriptor, this.memMgr);
        this.allocationPtr = new Slot();
        this.outputedTuple = new Slot();
        this.sTreeTop = new int[]{-1, -1, -1, -1};
        this.peek = new int[]{-1, -1, -1, -1};
        this.discard = new Slot();
        this.curRunId = -1;
        this.curRunSize = 0;
        this.nextRunSize = 0;
        this.openNewRun();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.inputAccessor.reset(buffer);
        byte[] bufferArray = buffer.array();
        int tupleCount = this.inputAccessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            int[] entry;
            if (this.curRunSize >= this.outputLimit) {
                this.sTree.peekMax(this.peek);
                if (this.isEntryValid(this.peek) && this.compareRecords(this.inputAccessor, i, this.peek[1], this.peek[2]) >= 0) continue;
            }
            this.allocationPtr.clear();
            int tLength = this.inputAccessor.getTupleEndOffset(i) - this.inputAccessor.getTupleStartOffset(i);
            this.memMgr.allocate(tLength, this.allocationPtr);
            while (this.allocationPtr.isNull()) {
                int unAllocSize = -1;
                while (unAllocSize < tLength) {
                    unAllocSize = this.outputRecord();
                    if (unAllocSize >= 1) continue;
                    throw new HyracksDataException("Unable to allocate space for the new tuple, while there is no more tuple to output");
                }
                this.memMgr.allocate(tLength, this.allocationPtr);
            }
            int pnk = this.getPNK(this.inputAccessor, i, bufferArray);
            int runId = this.getRunId(this.inputAccessor, i);
            if (runId != this.curRunId) {
                this.memMgr.writeTuple(this.allocationPtr.getFrameIx(), this.allocationPtr.getOffset(), this.inputAccessor, i);
                entry = new int[]{runId, this.allocationPtr.getFrameIx(), this.allocationPtr.getOffset(), pnk};
                this.sTree.insert(entry);
                ++this.nextRunSize;
                continue;
            }
            if (this.curRunSize < this.outputLimit) {
                this.memMgr.writeTuple(this.allocationPtr.getFrameIx(), this.allocationPtr.getOffset(), this.inputAccessor, i);
                entry = new int[]{runId, this.allocationPtr.getFrameIx(), this.allocationPtr.getOffset(), pnk};
                this.sTree.insert(entry);
                ++this.curRunSize;
                continue;
            }
            this.sTree.peekMax(this.peek);
            if (this.compareRecords(this.inputAccessor, i, this.peek[1], this.peek[2]) > 0) continue;
            this.sTree.getMax(this.peek);
            this.discard.set(this.peek[1], this.peek[2]);
            this.memMgr.unallocate(this.discard);
            this.memMgr.writeTuple(this.allocationPtr.getFrameIx(), this.allocationPtr.getOffset(), this.inputAccessor, i);
            entry = new int[]{runId, this.allocationPtr.getFrameIx(), this.allocationPtr.getOffset(), pnk};
            this.sTree.insert(entry);
        }
    }

    public void fail() throws HyracksDataException {
    }

    public void close() throws HyracksDataException {
        while (!this.sTree.isEmpty()) {
            this.outputRecordForClose();
        }
        if (this.outputAppender.getTupleCount() > 0) {
            FrameUtils.flushFrame((ByteBuffer)this.outputBuffer, (IFrameWriter)this.writer);
        }
        this.writer.close();
        this.runs.add((IFrameReader)this.writer.createReader());
        this.memMgr.close();
    }

    @Override
    public List<IFrameReader> getRuns() {
        return this.runs;
    }

    private int outputRecord() throws HyracksDataException {
        this.outputedTuple.clear();
        this.sTree.getMin(this.sTreeTop);
        if (!this.isEntryValid(this.sTreeTop)) {
            throw new HyracksDataException("Invalid outputed tuple (Top of the selection tree is invalid)");
        }
        int tFrameIx = this.sTreeTop[1];
        int tOffset = this.sTreeTop[2];
        if (this.sTreeTop[0] == this.curRunId) {
            if (!this.memMgr.readTuple(tFrameIx, tOffset, this.outputAppender)) {
                FrameUtils.flushFrame((ByteBuffer)this.outputBuffer, (IFrameWriter)this.writer);
                this.outputAppender.reset(this.outputBuffer, true);
                if (!this.memMgr.readTuple(tFrameIx, tOffset, this.outputAppender)) {
                    throw new HyracksDataException("Can not append to the ouput buffer in sort");
                }
                this.lastTupleIx = 0;
            } else {
                ++this.lastTupleIx;
            }
            this.outputedTuple.set(tFrameIx, tOffset);
            this.newRun = false;
            return this.memMgr.unallocate(this.outputedTuple);
        }
        this.openNewRun();
        int popCount = this.curRunSize - this.outputLimit;
        int l = 0;
        int maxFreedSpace = 0;
        for (int p = 0; p < popCount; ++p) {
            this.sTree.getMax(this.peek);
            if (!this.isEntryValid(this.peek)) {
                throw new HyracksDataException("Invalid Maximum extracted from MinMaxHeap");
            }
            this.discard.set(this.peek[1], this.peek[2]);
            l = this.memMgr.unallocate(this.discard);
            if (l > maxFreedSpace) {
                maxFreedSpace = l;
            }
            --this.curRunSize;
        }
        if (maxFreedSpace != 0) {
            return maxFreedSpace;
        }
        if (!this.memMgr.readTuple(tFrameIx, tOffset, this.outputAppender)) {
            throw new HyracksDataException("Can not append to the ouput buffer in sort");
        }
        this.lastTupleIx = 0;
        this.outputedTuple.set(tFrameIx, tOffset);
        this.newRun = false;
        return this.memMgr.unallocate(this.outputedTuple);
    }

    private void outputRecordForClose() throws HyracksDataException {
        this.sTree.getMin(this.sTreeTop);
        if (!this.isEntryValid(this.sTreeTop)) {
            throw new HyracksDataException("Invalid outputed tuple (Top of the selection tree is invalid)");
        }
        int tFrameIx = this.sTreeTop[1];
        int tOffset = this.sTreeTop[2];
        if (this.sTreeTop[0] != this.curRunId) {
            this.openNewRun();
        }
        if (!this.memMgr.readTuple(tFrameIx, tOffset, this.outputAppender)) {
            FrameUtils.flushFrame((ByteBuffer)this.outputBuffer, (IFrameWriter)this.writer);
            this.outputAppender.reset(this.outputBuffer, true);
            if (!this.memMgr.readTuple(tFrameIx, tOffset, this.outputAppender)) {
                throw new HyracksDataException("Can not append to the ouput buffer in sort");
            }
        }
    }

    private int getPNK(FrameTupleAccessor fta, int tIx, byte[] buffInArray) {
        int sfIdx = this.sortFields[0];
        int tStart = fta.getTupleStartOffset(tIx);
        int f0StartRel = fta.getFieldStartOffset(tIx, sfIdx);
        int f0EndRel = fta.getFieldEndOffset(tIx, sfIdx);
        int f0Start = f0StartRel + tStart + fta.getFieldSlotsLength();
        return this.nkc == null ? 0 : this.nkc.normalize(buffInArray, f0Start, f0EndRel - f0StartRel);
    }

    private int getRunId(FrameTupleAccessor fta, int tupIx) {
        if (this.newRun) {
            return this.curRunId;
        }
        byte[] lastRecBuff = this.outputBuffer.array();
        this.lastRecordAccessor.reset(this.outputBuffer);
        int lastStartOffset = this.lastRecordAccessor.getTupleStartOffset(this.lastTupleIx);
        ByteBuffer fr2 = fta.getBuffer();
        byte[] curRecBuff = fr2.array();
        int r2StartOffset = fta.getTupleStartOffset(tupIx);
        for (int f = 0; f < this.comparators.length; ++f) {
            int l2;
            int fIdx = this.sortFields[f];
            int f1Start = fIdx == 0 ? 0 : this.outputBuffer.getInt(lastStartOffset + (fIdx - 1) * 4);
            int f1End = this.outputBuffer.getInt(lastStartOffset + fIdx * 4);
            int s1 = lastStartOffset + this.lastRecordAccessor.getFieldSlotsLength() + f1Start;
            int l1 = f1End - f1Start;
            int f2Start = fIdx == 0 ? 0 : fr2.getInt(r2StartOffset + (fIdx - 1) * 4);
            int f2End = fr2.getInt(r2StartOffset + fIdx * 4);
            int s2 = r2StartOffset + fta.getFieldSlotsLength() + f2Start;
            int c = this.comparators[f].compare(lastRecBuff, s1, l1, curRecBuff, s2, l2 = f2End - f2Start);
            if (c == 0) continue;
            if (c <= 0) {
                return this.curRunId;
            }
            return this.curRunId + 1;
        }
        return this.curRunId;
    }

    private int compareRecords(FrameTupleAccessor fta1, int ix1, int fix2, int offset2) {
        ByteBuffer buff1 = fta1.getBuffer();
        byte[] recBuff1 = buff1.array();
        int offset1 = fta1.getTupleStartOffset(ix1);
        offset2 += 2;
        ByteBuffer buff2 = this.memMgr.getFrame(fix2);
        this.fta2.reset(buff2);
        byte[] recBuff2 = buff2.array();
        for (int f = 0; f < this.comparators.length; ++f) {
            int l2;
            int fIdx = this.sortFields[f];
            int f1Start = fIdx == 0 ? 0 : buff1.getInt(offset1 + (fIdx - 1) * 4);
            int f1End = buff1.getInt(offset1 + fIdx * 4);
            int s1 = offset1 + fta1.getFieldSlotsLength() + f1Start;
            int l1 = f1End - f1Start;
            int f2Start = fIdx == 0 ? 0 : buff2.getInt(offset2 + (fIdx - 1) * 4);
            int f2End = buff2.getInt(offset2 + fIdx * 4);
            int s2 = offset2 + this.fta2.getFieldSlotsLength() + f2Start;
            int c = this.comparators[f].compare(recBuff1, s1, l1, recBuff2, s2, l2 = f2End - f2Start);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private void openNewRun() throws HyracksDataException {
        if (this.writer != null) {
            if (this.outputAppender.getTupleCount() > 0) {
                FrameUtils.flushFrame((ByteBuffer)this.outputBuffer, (IFrameWriter)this.writer);
            }
            this.outputAppender.reset(this.outputBuffer, true);
            this.writer.close();
            this.runs.add((IFrameReader)this.writer.createReader());
        }
        FileReference file = this.ctx.getJobletContext().createManagedWorkspaceFile(ExternalSortRunGenerator.class.getSimpleName());
        this.writer = new RunFileWriter(file, this.ctx.getIOManager());
        this.writer.open();
        ++this.curRunId;
        this.newRun = true;
        this.curRunSize = this.nextRunSize;
        this.nextRunSize = 0;
        this.lastTupleIx = -1;
    }

    private boolean isEntryValid(int[] entry) {
        return entry[0] > -1 && entry[1] > -1 && entry[2] > -1;
    }
}

