/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.sort;

import edu.uci.ics.hyracks.api.comm.IFrameReader;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksCommonContext;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputer;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileWriter;
import edu.uci.ics.hyracks.dataflow.std.sort.BSTMemMgr;
import edu.uci.ics.hyracks.dataflow.std.sort.ExternalSortRunGenerator;
import edu.uci.ics.hyracks.dataflow.std.sort.IMemoryManager;
import edu.uci.ics.hyracks.dataflow.std.sort.IRunGenerator;
import edu.uci.ics.hyracks.dataflow.std.sort.ISelectionTree;
import edu.uci.ics.hyracks.dataflow.std.sort.Slot;
import edu.uci.ics.hyracks.dataflow.std.sort.SortMinHeap;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class OptimizedExternalSortRunGenerator
implements IRunGenerator {
    private final IHyracksTaskContext ctx;
    private final int[] sortFields;
    private final INormalizedKeyComputer nkc;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final IBinaryComparator[] comparators;
    private final RecordDescriptor recordDescriptor;
    private final List<IFrameReader> runs;
    private ISelectionTree sTree;
    private IMemoryManager memMgr;
    private final int memSize;
    private FrameTupleAccessor inputAccessor;
    private FrameTupleAppender outputAppender;
    private ByteBuffer outputBuffer;
    private FrameTupleAccessor lastRecordAccessor;
    private int lastTupleIx;
    private Slot allocationPtr;
    private Slot outputedTuple;
    private int[] sTreeTop;
    private RunFileWriter writer;
    private boolean newRun;
    private int curRunId;

    public OptimizedExternalSortRunGenerator(IHyracksTaskContext ctx, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDesc, int memSize) {
        this.ctx = ctx;
        this.sortFields = sortFields;
        this.nkc = firstKeyNormalizerFactory == null ? null : firstKeyNormalizerFactory.createNormalizedKeyComputer();
        this.comparatorFactories = comparatorFactories;
        this.comparators = new IBinaryComparator[comparatorFactories.length];
        for (int i = 0; i < comparatorFactories.length; ++i) {
            this.comparators[i] = comparatorFactories[i].createBinaryComparator();
        }
        this.recordDescriptor = recordDesc;
        this.runs = new LinkedList<IFrameReader>();
        this.memSize = memSize;
    }

    public void open() throws HyracksDataException {
        this.runs.clear();
        this.inputAccessor = new FrameTupleAccessor(this.ctx.getFrameSize(), this.recordDescriptor);
        this.outputAppender = new FrameTupleAppender(this.ctx.getFrameSize());
        this.outputBuffer = this.ctx.allocateFrame();
        this.outputAppender.reset(this.outputBuffer, true);
        this.lastRecordAccessor = new FrameTupleAccessor(this.ctx.getFrameSize(), this.recordDescriptor);
        this.memMgr = new BSTMemMgr(this.ctx, this.memSize);
        this.sTree = new SortMinHeap((IHyracksCommonContext)this.ctx, this.sortFields, this.comparatorFactories, this.recordDescriptor, this.memMgr);
        this.allocationPtr = new Slot();
        this.outputedTuple = new Slot();
        this.sTreeTop = new int[]{-1, -1, -1, -1};
        this.curRunId = -1;
        this.openNewRun();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.inputAccessor.reset(buffer);
        byte[] bufferArray = buffer.array();
        int tupleCount = this.inputAccessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            this.allocationPtr.clear();
            int tLength = this.inputAccessor.getTupleEndOffset(i) - this.inputAccessor.getTupleStartOffset(i);
            this.memMgr.allocate(tLength, this.allocationPtr);
            while (this.allocationPtr.isNull()) {
                int unAllocSize = -1;
                while (unAllocSize < tLength) {
                    unAllocSize = this.outputRecord();
                    if (unAllocSize >= 1) continue;
                    throw new HyracksDataException("Unable to allocate space for the new tuple, while there is no more tuple to output");
                }
                this.memMgr.allocate(tLength, this.allocationPtr);
            }
            this.memMgr.writeTuple(this.allocationPtr.getFrameIx(), this.allocationPtr.getOffset(), this.inputAccessor, i);
            int runId = this.getRunId(this.inputAccessor, i);
            int pnk = this.getPNK(this.inputAccessor, i, bufferArray);
            int[] entry = new int[]{runId, this.allocationPtr.getFrameIx(), this.allocationPtr.getOffset(), pnk};
            this.sTree.insert(entry);
        }
    }

    public void fail() throws HyracksDataException {
    }

    public void close() throws HyracksDataException {
        while (!this.sTree.isEmpty()) {
            this.outputRecord();
        }
        if (this.outputAppender.getTupleCount() > 0) {
            FrameUtils.flushFrame((ByteBuffer)this.outputBuffer, (IFrameWriter)this.writer);
        }
        this.outputAppender.reset(this.outputBuffer, true);
        this.writer.close();
        this.runs.add((IFrameReader)this.writer.createReader());
        this.memMgr.close();
    }

    @Override
    public List<IFrameReader> getRuns() {
        return this.runs;
    }

    private int outputRecord() throws HyracksDataException {
        int tOffset;
        int tFrameIx;
        this.outputedTuple.clear();
        this.sTree.getMin(this.sTreeTop);
        if (!this.isEntryValid(this.sTreeTop)) {
            throw new HyracksDataException("Invalid outputed tuple (Top of the selection tree is invalid)");
        }
        if (this.sTreeTop[0] != this.curRunId) {
            this.openNewRun();
        }
        if (!this.memMgr.readTuple(tFrameIx = this.sTreeTop[1], tOffset = this.sTreeTop[2], this.outputAppender)) {
            FrameUtils.flushFrame((ByteBuffer)this.outputBuffer, (IFrameWriter)this.writer);
            this.outputAppender.reset(this.outputBuffer, true);
            if (!this.memMgr.readTuple(tFrameIx, tOffset, this.outputAppender)) {
                throw new HyracksDataException("Can not append to the ouput buffer in sort");
            }
            this.lastTupleIx = 0;
        } else {
            ++this.lastTupleIx;
        }
        this.outputedTuple.set(tFrameIx, tOffset);
        this.newRun = false;
        return this.memMgr.unallocate(this.outputedTuple);
    }

    private int getPNK(FrameTupleAccessor fta, int tIx, byte[] buffInArray) {
        int sfIdx = this.sortFields[0];
        int tStart = fta.getTupleStartOffset(tIx);
        int f0StartRel = fta.getFieldStartOffset(tIx, sfIdx);
        int f0EndRel = fta.getFieldEndOffset(tIx, sfIdx);
        int f0Start = f0StartRel + tStart + fta.getFieldSlotsLength();
        return this.nkc == null ? 0 : this.nkc.normalize(buffInArray, f0Start, f0EndRel - f0StartRel);
    }

    private int getRunId(FrameTupleAccessor fta, int tupIx) {
        if (this.newRun) {
            return this.curRunId;
        }
        byte[] lastRecBuff = this.outputBuffer.array();
        this.lastRecordAccessor.reset(this.outputBuffer);
        int lastStartOffset = this.lastRecordAccessor.getTupleStartOffset(this.lastTupleIx);
        ByteBuffer fr2 = fta.getBuffer();
        byte[] curRecBuff = fr2.array();
        int r2StartOffset = fta.getTupleStartOffset(tupIx);
        for (int f = 0; f < this.comparators.length; ++f) {
            int l2;
            int fIdx = this.sortFields[f];
            int f1Start = fIdx == 0 ? 0 : this.outputBuffer.getInt(lastStartOffset + (fIdx - 1) * 4);
            int f1End = this.outputBuffer.getInt(lastStartOffset + fIdx * 4);
            int s1 = lastStartOffset + this.lastRecordAccessor.getFieldSlotsLength() + f1Start;
            int l1 = f1End - f1Start;
            int f2Start = fIdx == 0 ? 0 : fr2.getInt(r2StartOffset + (fIdx - 1) * 4);
            int f2End = fr2.getInt(r2StartOffset + fIdx * 4);
            int s2 = r2StartOffset + fta.getFieldSlotsLength() + f2Start;
            int c = this.comparators[f].compare(lastRecBuff, s1, l1, curRecBuff, s2, l2 = f2End - f2Start);
            if (c == 0) continue;
            if (c <= 0) {
                return this.curRunId;
            }
            return this.curRunId + 1;
        }
        return this.curRunId;
    }

    private void openNewRun() throws HyracksDataException {
        if (this.writer != null) {
            if (this.outputAppender.getTupleCount() > 0) {
                FrameUtils.flushFrame((ByteBuffer)this.outputBuffer, (IFrameWriter)this.writer);
            }
            this.outputAppender.reset(this.outputBuffer, true);
            this.writer.close();
            this.runs.add((IFrameReader)this.writer.createReader());
        }
        FileReference file = this.ctx.getJobletContext().createManagedWorkspaceFile(ExternalSortRunGenerator.class.getSimpleName());
        this.writer = new RunFileWriter(file, this.ctx.getIOManager());
        this.writer.open();
        ++this.curRunId;
        this.newRun = true;
        this.lastTupleIx = -1;
    }

    private boolean isEntryValid(int[] entry) {
        return entry[0] > -1 && entry[1] > -1 && entry[2] > -1;
    }
}

