/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.sort;

import edu.uci.ics.hyracks.api.comm.IFrameReader;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.IActivity;
import edu.uci.ics.hyracks.api.dataflow.IActivityGraphBuilder;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.TaskId;
import edu.uci.ics.hyracks.api.dataflow.state.IStateObject;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputer;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractActivityNode;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractStateObject;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.sort.ExternalSortRunMerger;
import edu.uci.ics.hyracks.dataflow.std.sort.IRunGenerator;
import edu.uci.ics.hyracks.dataflow.std.sort.OptimizedExternalSortRunGenerator;
import edu.uci.ics.hyracks.dataflow.std.sort.OptimizedExternalSortRunGeneratorWithLimit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public class OptimizedExternalSortOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final int NO_LIMIT = -1;
    private static final long serialVersionUID = 1L;
    private static final int SORT_ACTIVITY_ID = 0;
    private static final int MERGE_ACTIVITY_ID = 1;
    private final int[] sortFields;
    private final INormalizedKeyComputerFactory firstKeyNormalizerFactory;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final int memSize;
    private final int outputLimit;

    public OptimizedExternalSortOperatorDescriptor(IOperatorDescriptorRegistry spec, int framesLimit, int[] sortFields, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) {
        this(spec, framesLimit, -1, sortFields, null, comparatorFactories, recordDescriptor);
    }

    public OptimizedExternalSortOperatorDescriptor(IOperatorDescriptorRegistry spec, int framesLimit, int outputLimit, int[] sortFields, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) {
        this(spec, framesLimit, outputLimit, sortFields, null, comparatorFactories, recordDescriptor);
    }

    public OptimizedExternalSortOperatorDescriptor(IOperatorDescriptorRegistry spec, int memSize, int outputLimit, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) {
        super(spec, 1, 1);
        this.memSize = memSize;
        this.outputLimit = outputLimit;
        this.sortFields = sortFields;
        this.firstKeyNormalizerFactory = firstKeyNormalizerFactory;
        this.comparatorFactories = comparatorFactories;
        if (memSize <= 1) {
            throw new IllegalStateException();
        }
        this.recordDescriptors[0] = recordDescriptor;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        OptimizedSortActivity osa = new OptimizedSortActivity(new ActivityId(this.odId, 0));
        OptimizedMergeActivity oma = new OptimizedMergeActivity(new ActivityId(this.odId, 1));
        builder.addActivity((IOperatorDescriptor)this, (IActivity)osa);
        builder.addSourceEdge(0, (IActivity)osa, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)oma);
        builder.addTargetEdge(0, (IActivity)oma, 0);
        builder.addBlockingEdge((IActivity)osa, (IActivity)oma);
    }

    private class OptimizedMergeActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public OptimizedMergeActivity(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            AbstractUnaryOutputSourceOperatorNodePushable op = new AbstractUnaryOutputSourceOperatorNodePushable(){

                @Override
                public void initialize() throws HyracksDataException {
                    OptimizedSortTaskState state = (OptimizedSortTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(OptimizedExternalSortOperatorDescriptor.this.getOperatorId(), 0), partition));
                    List runs = state.runs;
                    IBinaryComparator[] comparators = new IBinaryComparator[OptimizedExternalSortOperatorDescriptor.this.comparatorFactories.length];
                    for (int i = 0; i < OptimizedExternalSortOperatorDescriptor.this.comparatorFactories.length; ++i) {
                        comparators[i] = OptimizedExternalSortOperatorDescriptor.this.comparatorFactories[i].createBinaryComparator();
                    }
                    INormalizedKeyComputer nmkComputer = OptimizedExternalSortOperatorDescriptor.this.firstKeyNormalizerFactory == null ? null : OptimizedExternalSortOperatorDescriptor.this.firstKeyNormalizerFactory.createNormalizedKeyComputer();
                    int necessaryFrames = Math.min(runs.size() + 2, OptimizedExternalSortOperatorDescriptor.this.memSize);
                    ExternalSortRunMerger merger = new ExternalSortRunMerger(ctx, OptimizedExternalSortOperatorDescriptor.this.outputLimit, (List<IFrameReader>)runs, OptimizedExternalSortOperatorDescriptor.this.sortFields, comparators, nmkComputer, OptimizedExternalSortOperatorDescriptor.this.recordDescriptors[0], necessaryFrames, this.writer);
                    merger.processWithReplacementSelection();
                }
            };
            return op;
        }
    }

    private class OptimizedSortActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public OptimizedSortActivity(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            final IRunGenerator runGen = OptimizedExternalSortOperatorDescriptor.this.outputLimit == -1 ? new OptimizedExternalSortRunGenerator(ctx, OptimizedExternalSortOperatorDescriptor.this.sortFields, OptimizedExternalSortOperatorDescriptor.this.firstKeyNormalizerFactory, OptimizedExternalSortOperatorDescriptor.this.comparatorFactories, OptimizedExternalSortOperatorDescriptor.this.recordDescriptors[0], OptimizedExternalSortOperatorDescriptor.this.memSize) : new OptimizedExternalSortRunGeneratorWithLimit(ctx, OptimizedExternalSortOperatorDescriptor.this.sortFields, OptimizedExternalSortOperatorDescriptor.this.firstKeyNormalizerFactory, OptimizedExternalSortOperatorDescriptor.this.comparatorFactories, OptimizedExternalSortOperatorDescriptor.this.recordDescriptors[0], OptimizedExternalSortOperatorDescriptor.this.memSize, OptimizedExternalSortOperatorDescriptor.this.outputLimit);
            AbstractUnaryInputSinkOperatorNodePushable op = new AbstractUnaryInputSinkOperatorNodePushable(){

                public void open() throws HyracksDataException {
                    runGen.open();
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    runGen.nextFrame(buffer);
                }

                public void close() throws HyracksDataException {
                    OptimizedSortTaskState state = new OptimizedSortTaskState(ctx.getJobletContext().getJobId(), new TaskId(OptimizedSortActivity.this.getActivityId(), partition));
                    runGen.close();
                    state.runs = runGen.getRuns();
                    ctx.setStateObject((IStateObject)state);
                }

                public void fail() throws HyracksDataException {
                    runGen.fail();
                }
            };
            return op;
        }
    }

    public static class OptimizedSortTaskState
    extends AbstractStateObject {
        private List<IFrameReader> runs;

        public OptimizedSortTaskState() {
        }

        private OptimizedSortTaskState(JobId jobId, TaskId taskId) {
            super(jobId, taskId);
        }

        public void toBytes(DataOutput out) throws IOException {
        }

        public void fromBytes(DataInput in) throws IOException {
        }
    }
}

