/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.sort;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.IActivity;
import edu.uci.ics.hyracks.api.dataflow.IActivityGraphBuilder;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.TaskId;
import edu.uci.ics.hyracks.api.dataflow.state.IStateObject;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractActivityNode;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractStateObject;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.sort.FrameSorterMergeSort;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class InMemorySortOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private static final int SORT_ACTIVITY_ID = 0;
    private static final int MERGE_ACTIVITY_ID = 1;
    private final int[] sortFields;
    private INormalizedKeyComputerFactory firstKeyNormalizerFactory;
    private IBinaryComparatorFactory[] comparatorFactories;

    public InMemorySortOperatorDescriptor(IOperatorDescriptorRegistry spec, int[] sortFields, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) {
        this(spec, sortFields, null, comparatorFactories, recordDescriptor);
    }

    public InMemorySortOperatorDescriptor(IOperatorDescriptorRegistry spec, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) {
        super(spec, 1, 1);
        this.sortFields = sortFields;
        this.firstKeyNormalizerFactory = firstKeyNormalizerFactory;
        this.comparatorFactories = comparatorFactories;
        this.recordDescriptors[0] = recordDescriptor;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        SortActivity sa = new SortActivity(new ActivityId(this.odId, 0));
        MergeActivity ma = new MergeActivity(new ActivityId(this.odId, 1));
        builder.addActivity((IOperatorDescriptor)this, (IActivity)sa);
        builder.addSourceEdge(0, (IActivity)sa, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)ma);
        builder.addTargetEdge(0, (IActivity)ma, 0);
        builder.addBlockingEdge((IActivity)sa, (IActivity)ma);
    }

    private class MergeActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public MergeActivity(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            AbstractUnaryOutputSourceOperatorNodePushable op = new AbstractUnaryOutputSourceOperatorNodePushable(){

                @Override
                public void initialize() throws HyracksDataException {
                    this.writer.open();
                    try {
                        SortTaskState state = (SortTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(InMemorySortOperatorDescriptor.this.getOperatorId(), 0), partition));
                        state.frameSorter.flushFrames(this.writer);
                    }
                    catch (Exception e) {
                        this.writer.fail();
                        throw new HyracksDataException((Throwable)e);
                    }
                    finally {
                        this.writer.close();
                    }
                }
            };
            return op;
        }
    }

    private class SortActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public SortActivity(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            AbstractUnaryInputSinkOperatorNodePushable op = new AbstractUnaryInputSinkOperatorNodePushable(){
                private SortTaskState state;

                public void open() throws HyracksDataException {
                    this.state = new SortTaskState(ctx.getJobletContext().getJobId(), new TaskId(SortActivity.this.getActivityId(), partition));
                    this.state.frameSorter = new FrameSorterMergeSort(ctx, InMemorySortOperatorDescriptor.this.sortFields, InMemorySortOperatorDescriptor.this.firstKeyNormalizerFactory, InMemorySortOperatorDescriptor.this.comparatorFactories, InMemorySortOperatorDescriptor.this.recordDescriptors[0]);
                    this.state.frameSorter.reset();
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.state.frameSorter.insertFrame(buffer);
                }

                public void close() throws HyracksDataException {
                    this.state.frameSorter.sortFrames();
                    ctx.setStateObject((IStateObject)this.state);
                }

                public void fail() throws HyracksDataException {
                }
            };
            return op;
        }
    }

    public static class SortTaskState
    extends AbstractStateObject {
        private FrameSorterMergeSort frameSorter;

        public SortTaskState() {
        }

        private SortTaskState(JobId jobId, TaskId taskId) {
            super(jobId, taskId);
        }

        public void toBytes(DataOutput out) throws IOException {
        }

        public void fromBytes(DataInput in) throws IOException {
        }
    }
}

