/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.sort;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputer;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.std.sort.IFrameSorter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class FrameSorterQuickSort
implements IFrameSorter {
    private final IHyracksTaskContext ctx;
    private final int[] sortFields;
    private final INormalizedKeyComputer nkc;
    private final IBinaryComparator[] comparators;
    private final List<ByteBuffer> buffers;
    private final FrameTupleAccessor fta1;
    private final FrameTupleAccessor fta2;
    private final FrameTupleAppender appender;
    private final ByteBuffer outFrame;
    private int dataFrameCount;
    private int[] tPointers;
    private int tupleCount;

    public FrameSorterQuickSort(IHyracksTaskContext ctx, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) throws HyracksDataException {
        this.ctx = ctx;
        this.sortFields = sortFields;
        this.nkc = firstKeyNormalizerFactory == null ? null : firstKeyNormalizerFactory.createNormalizedKeyComputer();
        this.comparators = new IBinaryComparator[comparatorFactories.length];
        for (int i = 0; i < comparatorFactories.length; ++i) {
            this.comparators[i] = comparatorFactories[i].createBinaryComparator();
        }
        this.buffers = new ArrayList<ByteBuffer>();
        this.fta1 = new FrameTupleAccessor(ctx.getFrameSize(), recordDescriptor);
        this.fta2 = new FrameTupleAccessor(ctx.getFrameSize(), recordDescriptor);
        this.appender = new FrameTupleAppender(ctx.getFrameSize());
        this.outFrame = ctx.allocateFrame();
        this.dataFrameCount = 0;
    }

    @Override
    public void reset() {
        this.dataFrameCount = 0;
        this.tupleCount = 0;
    }

    @Override
    public int getFrameCount() {
        return this.dataFrameCount;
    }

    @Override
    public void insertFrame(ByteBuffer buffer) throws HyracksDataException {
        ByteBuffer copyFrame;
        if (this.dataFrameCount == this.buffers.size()) {
            copyFrame = this.ctx.allocateFrame();
            this.buffers.add(copyFrame);
        } else {
            copyFrame = this.buffers.get(this.dataFrameCount);
        }
        FrameUtils.copy((ByteBuffer)buffer, (ByteBuffer)copyFrame);
        ++this.dataFrameCount;
    }

    @Override
    public void sortFrames() {
        int nBuffers = this.dataFrameCount;
        this.tupleCount = 0;
        for (int i = 0; i < nBuffers; ++i) {
            this.fta1.reset(this.buffers.get(i));
            this.tupleCount += this.fta1.getTupleCount();
        }
        int sfIdx = this.sortFields[0];
        this.tPointers = this.tPointers == null || this.tPointers.length < this.tupleCount * 4 ? new int[this.tupleCount * 4] : this.tPointers;
        int ptr = 0;
        for (int i = 0; i < nBuffers; ++i) {
            this.fta1.reset(this.buffers.get(i));
            int tCount = this.fta1.getTupleCount();
            byte[] array = this.fta1.getBuffer().array();
            for (int j = 0; j < tCount; ++j) {
                int tStart = this.fta1.getTupleStartOffset(j);
                int tEnd = this.fta1.getTupleEndOffset(j);
                this.tPointers[ptr * 4] = i;
                this.tPointers[ptr * 4 + 1] = tStart;
                this.tPointers[ptr * 4 + 2] = tEnd;
                int f0StartRel = this.fta1.getFieldStartOffset(j, sfIdx);
                int f0EndRel = this.fta1.getFieldEndOffset(j, sfIdx);
                int f0Start = f0StartRel + tStart + this.fta1.getFieldSlotsLength();
                this.tPointers[ptr * 4 + 3] = this.nkc == null ? 0 : this.nkc.normalize(array, f0Start, f0EndRel - f0StartRel);
                ++ptr;
            }
        }
        if (this.tupleCount > 0) {
            this.sort(this.tPointers, 0, this.tupleCount);
        }
    }

    @Override
    public void flushFrames(IFrameWriter writer) throws HyracksDataException {
        this.appender.reset(this.outFrame, true);
        for (int ptr = 0; ptr < this.tupleCount; ++ptr) {
            int i = this.tPointers[ptr * 4];
            int tStart = this.tPointers[ptr * 4 + 1];
            int tEnd = this.tPointers[ptr * 4 + 2];
            ByteBuffer buffer = this.buffers.get(i);
            this.fta1.reset(buffer);
            if (this.appender.append((IFrameTupleAccessor)this.fta1, tStart, tEnd)) continue;
            FrameUtils.flushFrame((ByteBuffer)this.outFrame, (IFrameWriter)writer);
            this.appender.reset(this.outFrame, true);
            if (this.appender.append((IFrameTupleAccessor)this.fta1, tStart, tEnd)) continue;
            throw new HyracksDataException("Record size (" + (tEnd - tStart) + ") larger than frame size (" + this.appender.getBuffer().capacity() + ")");
        }
        if (this.appender.getTupleCount() > 0) {
            FrameUtils.flushFrame((ByteBuffer)this.outFrame, (IFrameWriter)writer);
        }
    }

    private void sort(int[] tPointers, int offset, int length) {
        int c;
        int a;
        int m = offset + (length >> 1);
        int mi = tPointers[m * 4];
        int mj = tPointers[m * 4 + 1];
        int mv = tPointers[m * 4 + 3];
        int b = a = offset;
        int d = c = offset + length - 1;
        while (true) {
            int cmp;
            if (b <= c && (cmp = this.compare(tPointers, b, mi, mj, mv)) <= 0) {
                if (cmp == 0) {
                    this.swap(tPointers, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (cmp = this.compare(tPointers, c, mi, mj, mv)) >= 0) {
                if (cmp == 0) {
                    this.swap(tPointers, c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(tPointers, b++, c--);
        }
        int n = offset + length;
        int s = Math.min(a - offset, b - a);
        this.vecswap(tPointers, offset, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(tPointers, b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sort(tPointers, offset, s);
        }
        if ((s = d - c) > 1) {
            this.sort(tPointers, n - s, s);
        }
    }

    private void swap(int[] x, int a, int b) {
        for (int i = 0; i < 4; ++i) {
            int t = x[a * 4 + i];
            x[a * 4 + i] = x[b * 4 + i];
            x[b * 4 + i] = t;
        }
    }

    private void vecswap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private int compare(int[] tPointers, int tp1, int tp2i, int tp2j, int tp2v) {
        int i1 = tPointers[tp1 * 4];
        int j1 = tPointers[tp1 * 4 + 1];
        int v1 = tPointers[tp1 * 4 + 3];
        if (v1 != tp2v) {
            return ((long)v1 & 0xFFFFFFFFL) < ((long)tp2v & 0xFFFFFFFFL) ? -1 : 1;
        }
        int i2 = tp2i;
        int j2 = tp2j;
        ByteBuffer buf1 = this.buffers.get(i1);
        ByteBuffer buf2 = this.buffers.get(i2);
        byte[] b1 = buf1.array();
        byte[] b2 = buf2.array();
        this.fta1.reset(buf1);
        this.fta2.reset(buf2);
        for (int f = 0; f < this.comparators.length; ++f) {
            int l2;
            int fIdx = this.sortFields[f];
            int f1Start = fIdx == 0 ? 0 : buf1.getInt(j1 + (fIdx - 1) * 4);
            int f1End = buf1.getInt(j1 + fIdx * 4);
            int s1 = j1 + this.fta1.getFieldSlotsLength() + f1Start;
            int l1 = f1End - f1Start;
            int f2Start = fIdx == 0 ? 0 : buf2.getInt(j2 + (fIdx - 1) * 4);
            int f2End = buf2.getInt(j2 + fIdx * 4);
            int s2 = j2 + this.fta2.getFieldSlotsLength() + f2Start;
            int c = this.comparators[f].compare(b1, s1, l1, b2, s2, l2 = f2End - f2Start);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public void close() {
        this.buffers.clear();
    }
}

