/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.sort;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputer;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.util.IntSerDeUtils;
import edu.uci.ics.hyracks.dataflow.std.sort.IFrameSorter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class FrameSorterMergeSort
implements IFrameSorter {
    private final IHyracksTaskContext ctx;
    private final int[] sortFields;
    private final INormalizedKeyComputer nkc;
    private final IBinaryComparator[] comparators;
    private final List<ByteBuffer> buffers;
    private final FrameTupleAccessor fta1;
    private final FrameTupleAccessor fta2;
    private final FrameTupleAppender appender;
    private final ByteBuffer outFrame;
    private int dataFrameCount;
    private int[] tPointers;
    private int[] tPointersTemp;
    private int tupleCount;

    public FrameSorterMergeSort(IHyracksTaskContext ctx, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) throws HyracksDataException {
        this.ctx = ctx;
        this.sortFields = sortFields;
        this.nkc = firstKeyNormalizerFactory == null ? null : firstKeyNormalizerFactory.createNormalizedKeyComputer();
        this.comparators = new IBinaryComparator[comparatorFactories.length];
        for (int i = 0; i < comparatorFactories.length; ++i) {
            this.comparators[i] = comparatorFactories[i].createBinaryComparator();
        }
        this.buffers = new ArrayList<ByteBuffer>();
        this.fta1 = new FrameTupleAccessor(ctx.getFrameSize(), recordDescriptor);
        this.fta2 = new FrameTupleAccessor(ctx.getFrameSize(), recordDescriptor);
        this.appender = new FrameTupleAppender(ctx.getFrameSize());
        this.outFrame = ctx.allocateFrame();
        this.dataFrameCount = 0;
    }

    @Override
    public void reset() {
        this.dataFrameCount = 0;
        this.tupleCount = 0;
    }

    @Override
    public int getFrameCount() {
        return this.dataFrameCount;
    }

    @Override
    public void insertFrame(ByteBuffer buffer) throws HyracksDataException {
        ByteBuffer copyFrame;
        if (this.dataFrameCount == this.buffers.size()) {
            copyFrame = this.ctx.allocateFrame();
            this.buffers.add(copyFrame);
        } else {
            copyFrame = this.buffers.get(this.dataFrameCount);
        }
        FrameUtils.copy((ByteBuffer)buffer, (ByteBuffer)copyFrame);
        ++this.dataFrameCount;
    }

    @Override
    public void sortFrames() {
        int nBuffers = this.dataFrameCount;
        this.tupleCount = 0;
        for (int i = 0; i < nBuffers; ++i) {
            this.fta1.reset(this.buffers.get(i));
            this.tupleCount += this.fta1.getTupleCount();
        }
        int sfIdx = this.sortFields[0];
        this.tPointers = this.tPointers == null || this.tPointers.length < this.tupleCount * 4 ? new int[this.tupleCount * 4] : this.tPointers;
        int ptr = 0;
        for (int i = 0; i < nBuffers; ++i) {
            this.fta1.reset(this.buffers.get(i));
            int tCount = this.fta1.getTupleCount();
            byte[] array = this.fta1.getBuffer().array();
            for (int j = 0; j < tCount; ++j) {
                int tStart = this.fta1.getTupleStartOffset(j);
                int tEnd = this.fta1.getTupleEndOffset(j);
                this.tPointers[ptr * 4] = i;
                this.tPointers[ptr * 4 + 1] = tStart;
                this.tPointers[ptr * 4 + 2] = tEnd;
                int f0StartRel = this.fta1.getFieldStartOffset(j, sfIdx);
                int f0EndRel = this.fta1.getFieldEndOffset(j, sfIdx);
                int f0Start = f0StartRel + tStart + this.fta1.getFieldSlotsLength();
                this.tPointers[ptr * 4 + 3] = this.nkc == null ? 0 : this.nkc.normalize(array, f0Start, f0EndRel - f0StartRel);
                ++ptr;
            }
        }
        if (this.tupleCount > 0) {
            this.tPointersTemp = new int[this.tPointers.length];
            this.sort(0, this.tupleCount);
        }
    }

    @Override
    public void flushFrames(IFrameWriter writer) throws HyracksDataException {
        this.appender.reset(this.outFrame, true);
        for (int ptr = 0; ptr < this.tupleCount; ++ptr) {
            int i = this.tPointers[ptr * 4];
            int tStart = this.tPointers[ptr * 4 + 1];
            int tEnd = this.tPointers[ptr * 4 + 2];
            ByteBuffer buffer = this.buffers.get(i);
            this.fta1.reset(buffer);
            if (this.appender.append((IFrameTupleAccessor)this.fta1, tStart, tEnd)) continue;
            FrameUtils.flushFrame((ByteBuffer)this.outFrame, (IFrameWriter)writer);
            this.appender.reset(this.outFrame, true);
            if (this.appender.append((IFrameTupleAccessor)this.fta1, tStart, tEnd)) continue;
            throw new HyracksDataException("Record size (" + (tEnd - tStart) + ") larger than frame size (" + this.appender.getBuffer().capacity() + ")");
        }
        if (this.appender.getTupleCount() > 0) {
            FrameUtils.flushFrame((ByteBuffer)this.outFrame, (IFrameWriter)writer);
        }
    }

    private void sort(int offset, int length) {
        int len = length;
        int end = offset + len;
        for (int step = 1; step < len; step *= 2) {
            for (int i = offset; i < end; i += 2 * step) {
                int next = i + step;
                if (next < end) {
                    this.merge(i, next, step, Math.min(step, end - next));
                    continue;
                }
                System.arraycopy(this.tPointers, i * 4, this.tPointersTemp, i * 4, (end - i) * 4);
            }
            int[] tmp = this.tPointersTemp;
            this.tPointersTemp = this.tPointers;
            this.tPointers = tmp;
        }
    }

    private void merge(int start1, int start2, int len1, int len2) {
        int rest;
        int targetPos = start1;
        int pos1 = start1;
        int pos2 = start2;
        int end1 = start1 + len1 - 1;
        int end2 = start2 + len2 - 1;
        while (pos1 <= end1 && pos2 <= end2) {
            int cmp = this.compare(pos1, pos2);
            if (cmp <= 0) {
                this.copy(pos1, targetPos);
                ++pos1;
            } else {
                this.copy(pos2, targetPos);
                ++pos2;
            }
            ++targetPos;
        }
        if (pos1 <= end1) {
            rest = end1 - pos1 + 1;
            System.arraycopy(this.tPointers, pos1 * 4, this.tPointersTemp, targetPos * 4, rest * 4);
        }
        if (pos2 <= end2) {
            rest = end2 - pos2 + 1;
            System.arraycopy(this.tPointers, pos2 * 4, this.tPointersTemp, targetPos * 4, rest * 4);
        }
    }

    private void copy(int src, int dest) {
        this.tPointersTemp[dest * 4] = this.tPointers[src * 4];
        this.tPointersTemp[dest * 4 + 1] = this.tPointers[src * 4 + 1];
        this.tPointersTemp[dest * 4 + 2] = this.tPointers[src * 4 + 2];
        this.tPointersTemp[dest * 4 + 3] = this.tPointers[src * 4 + 3];
    }

    private int compare(int tp1, int tp2) {
        int i1 = this.tPointers[tp1 * 4];
        int j1 = this.tPointers[tp1 * 4 + 1];
        int v1 = this.tPointers[tp1 * 4 + 3];
        int tp2i = this.tPointers[tp2 * 4];
        int tp2j = this.tPointers[tp2 * 4 + 1];
        int tp2v = this.tPointers[tp2 * 4 + 3];
        if (v1 != tp2v) {
            return ((long)v1 & 0xFFFFFFFFL) < ((long)tp2v & 0xFFFFFFFFL) ? -1 : 1;
        }
        int i2 = tp2i;
        int j2 = tp2j;
        ByteBuffer buf1 = this.buffers.get(i1);
        ByteBuffer buf2 = this.buffers.get(i2);
        byte[] b1 = buf1.array();
        byte[] b2 = buf2.array();
        this.fta1.reset(buf1);
        this.fta2.reset(buf2);
        for (int f = 0; f < this.comparators.length; ++f) {
            int l2;
            int fIdx = this.sortFields[f];
            int f1Start = fIdx == 0 ? 0 : IntSerDeUtils.getInt((byte[])buf1.array(), (int)(j1 + (fIdx - 1) * 4));
            int f1End = IntSerDeUtils.getInt((byte[])buf1.array(), (int)(j1 + fIdx * 4));
            int s1 = j1 + this.fta1.getFieldSlotsLength() + f1Start;
            int l1 = f1End - f1Start;
            int f2Start = fIdx == 0 ? 0 : IntSerDeUtils.getInt((byte[])buf2.array(), (int)(j2 + (fIdx - 1) * 4));
            int f2End = IntSerDeUtils.getInt((byte[])buf2.array(), (int)(j2 + fIdx * 4));
            int s2 = j2 + this.fta2.getFieldSlotsLength() + f2Start;
            int c = this.comparators[f].compare(b1, s1, l1, b2, s2, l2 = f2End - f2Start);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public void close() {
        this.buffers.clear();
    }
}

