/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.sort;

import edu.uci.ics.hyracks.api.comm.IFrameReader;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputer;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileReader;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileWriter;
import edu.uci.ics.hyracks.dataflow.std.sort.IFrameSorter;
import edu.uci.ics.hyracks.dataflow.std.sort.RunMergingFrameReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ExternalSortRunMerger {
    private final IHyracksTaskContext ctx;
    private final List<IFrameReader> runs;
    private final int[] sortFields;
    private final IBinaryComparator[] comparators;
    private final INormalizedKeyComputer nmkComputer;
    private final RecordDescriptor recordDesc;
    private final int framesLimit;
    private final IFrameWriter writer;
    private List<ByteBuffer> inFrames;
    private ByteBuffer outFrame;
    private FrameTupleAppender outFrameAppender;
    private IFrameSorter frameSorter;
    private FrameTupleAccessor outFrameAccessor;
    private final int outputLimit;
    private int currentSize;

    public ExternalSortRunMerger(IHyracksTaskContext ctx, IFrameSorter frameSorter, List<IFrameReader> runs, int[] sortFields, IBinaryComparator[] comparators, INormalizedKeyComputer nmkComputer, RecordDescriptor recordDesc, int framesLimit, IFrameWriter writer) {
        this.ctx = ctx;
        this.frameSorter = frameSorter;
        this.runs = new LinkedList<IFrameReader>(runs);
        this.sortFields = sortFields;
        this.comparators = comparators;
        this.nmkComputer = nmkComputer;
        this.recordDesc = recordDesc;
        this.framesLimit = framesLimit;
        this.writer = writer;
        this.outputLimit = -1;
    }

    public ExternalSortRunMerger(IHyracksTaskContext ctx, int outputLimit, List<IFrameReader> runs, int[] sortFields, IBinaryComparator[] comparators, INormalizedKeyComputer nmkComputer, RecordDescriptor recordDesc, int framesLimit, IFrameWriter writer) {
        this.ctx = ctx;
        this.runs = new LinkedList<IFrameReader>(runs);
        this.sortFields = sortFields;
        this.comparators = comparators;
        this.nmkComputer = nmkComputer;
        this.recordDesc = recordDesc;
        this.framesLimit = framesLimit;
        this.writer = writer;
        this.outputLimit = outputLimit;
        this.currentSize = 0;
        this.frameSorter = null;
    }

    public void process() throws HyracksDataException {
        this.writer.open();
        try {
            if (this.runs.size() <= 0) {
                if (this.frameSorter != null && this.frameSorter.getFrameCount() > 0) {
                    this.frameSorter.flushFrames(this.writer);
                }
                this.frameSorter.close();
            } else {
                this.frameSorter.close();
                this.inFrames = new ArrayList<ByteBuffer>();
                this.outFrame = this.ctx.allocateFrame();
                this.outFrameAppender = new FrameTupleAppender(this.ctx.getFrameSize());
                this.outFrameAppender.reset(this.outFrame, true);
                for (int i = 0; i < this.framesLimit - 1; ++i) {
                    this.inFrames.add(this.ctx.allocateFrame());
                }
                int maxMergeWidth = this.framesLimit - 1;
                while (this.runs.size() > maxMergeWidth) {
                    int generationSeparator = 0;
                    while (generationSeparator < this.runs.size() && this.runs.size() > maxMergeWidth) {
                        int mergeWidth = Math.min(Math.min(this.runs.size() - generationSeparator, maxMergeWidth), this.runs.size() - maxMergeWidth + 1);
                        FileReference newRun = this.ctx.createManagedWorkspaceFile(ExternalSortRunMerger.class.getSimpleName());
                        RunFileWriter mergeResultWriter = new RunFileWriter(newRun, this.ctx.getIOManager());
                        mergeResultWriter.open();
                        RunFileReader[] runCursors = new RunFileReader[mergeWidth];
                        for (int i = 0; i < mergeWidth; ++i) {
                            runCursors[i] = this.runs.get(generationSeparator + i);
                        }
                        this.merge((IFrameWriter)mergeResultWriter, (IFrameReader[])runCursors);
                        this.runs.subList(generationSeparator, mergeWidth + generationSeparator).clear();
                        this.runs.add(generationSeparator++, (IFrameReader)mergeResultWriter.createReader());
                    }
                }
                if (!this.runs.isEmpty()) {
                    RunFileReader[] runCursors = new RunFileReader[this.runs.size()];
                    for (int i = 0; i < runCursors.length; ++i) {
                        runCursors[i] = this.runs.get(i);
                    }
                    this.merge(this.writer, (IFrameReader[])runCursors);
                }
            }
        }
        catch (Exception e) {
            this.writer.fail();
            throw new HyracksDataException((Throwable)e);
        }
        finally {
            this.writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge(IFrameWriter mergeResultWriter, IFrameReader[] runCursors) throws HyracksDataException {
        merger.open();
        try (RunMergingFrameReader merger = new RunMergingFrameReader(this.ctx, runCursors, this.inFrames, this.sortFields, this.comparators, this.nmkComputer, this.recordDesc);){
            while (merger.nextFrame(this.outFrame)) {
                FrameUtils.flushFrame((ByteBuffer)this.outFrame, (IFrameWriter)mergeResultWriter);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processWithReplacementSelection() throws HyracksDataException {
        this.writer.open();
        try {
            this.outFrameAccessor = new FrameTupleAccessor(this.ctx.getFrameSize(), this.recordDesc);
            this.outFrame = this.ctx.allocateFrame();
            this.outFrameAppender = new FrameTupleAppender(this.ctx.getFrameSize());
            this.outFrameAppender.reset(this.outFrame, true);
            if (this.runs.size() == 1) {
                if (this.outputLimit < 1) {
                    this.runs.get(0).open();
                    ByteBuffer nextFrame = this.ctx.allocateFrame();
                    while (this.runs.get(0).nextFrame(nextFrame)) {
                        FrameUtils.flushFrame((ByteBuffer)nextFrame, (IFrameWriter)this.writer);
                        this.outFrameAppender.reset(nextFrame, true);
                    }
                    return;
                }
                int totalCount = 0;
                this.runs.get(0).open();
                FrameTupleAccessor fta = new FrameTupleAccessor(this.ctx.getFrameSize(), this.recordDesc);
                ByteBuffer nextFrame = this.ctx.allocateFrame();
                while (totalCount <= this.outputLimit && this.runs.get(0).nextFrame(nextFrame)) {
                    fta.reset(nextFrame);
                    int tupCount = fta.getTupleCount();
                    if (totalCount + tupCount < this.outputLimit) {
                        FrameUtils.flushFrame((ByteBuffer)nextFrame, (IFrameWriter)this.writer);
                        totalCount += tupCount;
                        continue;
                    }
                    int copyCount = this.outputLimit - totalCount;
                    this.outFrameAppender.reset(this.outFrame, true);
                    for (int i = 0; i < copyCount; ++i) {
                        if (!this.outFrameAppender.append((IFrameTupleAccessor)fta, i)) {
                            throw new HyracksDataException("Record size (" + (fta.getTupleEndOffset(i) - fta.getTupleStartOffset(i)) + ") larger than frame size (" + this.outFrameAppender.getBuffer().capacity() + ")");
                        }
                        ++totalCount;
                    }
                }
                if (this.outFrameAppender.getTupleCount() <= 0) return;
                FrameUtils.flushFrame((ByteBuffer)this.outFrame, (IFrameWriter)this.writer);
                this.outFrameAppender.reset(this.outFrame, true);
                return;
            }
            this.inFrames = new ArrayList<ByteBuffer>();
            for (int i = 0; i < this.framesLimit - 1; ++i) {
                this.inFrames.add(this.ctx.allocateFrame());
            }
            while (this.runs.size() > 0) {
                try {
                    this.doPassWithReplacementSelection(this.runs);
                }
                catch (Exception e) {
                    throw new HyracksDataException((Throwable)e);
                    return;
                }
            }
        }
        catch (Exception e) {
            this.writer.fail();
            throw new HyracksDataException((Throwable)e);
        }
        finally {
            this.writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPassWithReplacementSelection(List<IFrameReader> runs) throws HyracksDataException {
        FileReference newRun = null;
        IFrameWriter writer = this.writer;
        boolean finalPass = false;
        if (runs.size() + 1 <= this.framesLimit) {
            finalPass = true;
            for (int i = this.inFrames.size() - 1; i >= runs.size(); --i) {
                this.inFrames.remove(i);
            }
        } else {
            newRun = this.ctx.createManagedWorkspaceFile(ExternalSortRunMerger.class.getSimpleName());
            writer = new RunFileWriter(newRun, this.ctx.getIOManager());
            writer.open();
        }
        try {
            RunFileReader[] runCursors = new RunFileReader[this.inFrames.size()];
            for (int i = 0; i < this.inFrames.size(); ++i) {
                runCursors[i] = runs.get(i);
            }
            merger.open();
            try (RunMergingFrameReader merger = new RunMergingFrameReader(this.ctx, (IFrameReader[])runCursors, this.inFrames, this.sortFields, this.comparators, this.nmkComputer, this.recordDesc);){
                while (merger.nextFrame(this.outFrame)) {
                    if (this.outputLimit > 0 && finalPass) {
                        this.outFrameAccessor.reset(this.outFrame);
                        int count = this.outFrameAccessor.getTupleCount();
                        if (this.currentSize + count > this.outputLimit) {
                            ByteBuffer b = this.ctx.allocateFrame();
                            FrameTupleAppender partialAppender = new FrameTupleAppender(this.ctx.getFrameSize());
                            partialAppender.reset(b, true);
                            int copyCount = this.outputLimit - this.currentSize;
                            for (int i = 0; i < copyCount; ++i) {
                                partialAppender.append((IFrameTupleAccessor)this.outFrameAccessor, i);
                                ++this.currentSize;
                            }
                            FrameUtils.makeReadable((ByteBuffer)b);
                            FrameUtils.flushFrame((ByteBuffer)b, (IFrameWriter)writer);
                            break;
                        }
                        FrameUtils.flushFrame((ByteBuffer)this.outFrame, (IFrameWriter)writer);
                        this.currentSize += count;
                        continue;
                    }
                    FrameUtils.flushFrame((ByteBuffer)this.outFrame, (IFrameWriter)writer);
                }
            }
            if (this.outputLimit > 0 && finalPass && this.currentSize >= this.outputLimit) {
                runs.clear();
                return;
            }
            runs.subList(0, this.inFrames.size()).clear();
            if (!finalPass) {
                runs.add(0, (IFrameReader)((RunFileWriter)writer).createReader());
            }
        }
        finally {
            if (!finalPass) {
                writer.close();
            }
        }
    }
}

