/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.sort;

import edu.uci.ics.hyracks.api.comm.IFrameReader;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileWriter;
import edu.uci.ics.hyracks.dataflow.std.sort.Algorithm;
import edu.uci.ics.hyracks.dataflow.std.sort.FrameSorterMergeSort;
import edu.uci.ics.hyracks.dataflow.std.sort.FrameSorterQuickSort;
import edu.uci.ics.hyracks.dataflow.std.sort.IFrameSorter;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class ExternalSortRunGenerator
implements IFrameWriter {
    private final IHyracksTaskContext ctx;
    private final IFrameSorter frameSorter;
    private final List<IFrameReader> runs;
    private final int maxSortFrames;

    public ExternalSortRunGenerator(IHyracksTaskContext ctx, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDesc, Algorithm alg, int framesLimit) throws HyracksDataException {
        this.ctx = ctx;
        this.frameSorter = alg == Algorithm.MERGE_SORT ? new FrameSorterMergeSort(ctx, sortFields, firstKeyNormalizerFactory, comparatorFactories, recordDesc) : new FrameSorterQuickSort(ctx, sortFields, firstKeyNormalizerFactory, comparatorFactories, recordDesc);
        this.runs = new LinkedList<IFrameReader>();
        this.maxSortFrames = framesLimit - 1;
    }

    public void open() throws HyracksDataException {
        this.runs.clear();
        this.frameSorter.reset();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        if (this.frameSorter.getFrameCount() >= this.maxSortFrames) {
            this.flushFramesToRun();
        }
        this.frameSorter.insertFrame(buffer);
    }

    public void close() throws HyracksDataException {
        if (this.frameSorter.getFrameCount() > 0) {
            if (this.runs.size() <= 0) {
                this.frameSorter.sortFrames();
            } else {
                this.flushFramesToRun();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushFramesToRun() throws HyracksDataException {
        this.frameSorter.sortFrames();
        FileReference file = this.ctx.getJobletContext().createManagedWorkspaceFile(ExternalSortRunGenerator.class.getSimpleName());
        writer.open();
        try (RunFileWriter writer = new RunFileWriter(file, this.ctx.getIOManager());){
            this.frameSorter.flushFrames((IFrameWriter)writer);
        }
        this.frameSorter.reset();
        this.runs.add((IFrameReader)writer.createReader());
    }

    public void fail() throws HyracksDataException {
    }

    public IFrameSorter getFrameSorter() {
        return this.frameSorter;
    }

    public List<IFrameReader> getRuns() {
        return this.runs;
    }
}

