/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.sort;

import edu.uci.ics.hyracks.api.comm.IFrameReader;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.IActivity;
import edu.uci.ics.hyracks.api.dataflow.IActivityGraphBuilder;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.TaskId;
import edu.uci.ics.hyracks.api.dataflow.state.IStateObject;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputer;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractActivityNode;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractStateObject;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.sort.Algorithm;
import edu.uci.ics.hyracks.dataflow.std.sort.ExternalSortRunGenerator;
import edu.uci.ics.hyracks.dataflow.std.sort.ExternalSortRunMerger;
import edu.uci.ics.hyracks.dataflow.std.sort.IFrameSorter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public class ExternalSortOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private static final int SORT_ACTIVITY_ID = 0;
    private static final int MERGE_ACTIVITY_ID = 1;
    private final int[] sortFields;
    private final INormalizedKeyComputerFactory firstKeyNormalizerFactory;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final int framesLimit;
    private Algorithm alg = Algorithm.MERGE_SORT;

    public ExternalSortOperatorDescriptor(IOperatorDescriptorRegistry spec, int framesLimit, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, Algorithm alg) {
        this(spec, framesLimit, sortFields, firstKeyNormalizerFactory, comparatorFactories, recordDescriptor);
        this.alg = alg;
    }

    public ExternalSortOperatorDescriptor(IOperatorDescriptorRegistry spec, int framesLimit, int[] sortFields, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) {
        this(spec, framesLimit, sortFields, null, comparatorFactories, recordDescriptor);
    }

    public ExternalSortOperatorDescriptor(IOperatorDescriptorRegistry spec, int framesLimit, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) {
        super(spec, 1, 1);
        this.framesLimit = framesLimit;
        this.sortFields = sortFields;
        this.firstKeyNormalizerFactory = firstKeyNormalizerFactory;
        this.comparatorFactories = comparatorFactories;
        if (framesLimit <= 1) {
            throw new IllegalStateException();
        }
        this.recordDescriptors[0] = recordDescriptor;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        SortActivity sa = new SortActivity(new ActivityId(this.odId, 0));
        MergeActivity ma = new MergeActivity(new ActivityId(this.odId, 1));
        builder.addActivity((IOperatorDescriptor)this, (IActivity)sa);
        builder.addSourceEdge(0, (IActivity)sa, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)ma);
        builder.addTargetEdge(0, (IActivity)ma, 0);
        builder.addBlockingEdge((IActivity)sa, (IActivity)ma);
    }

    private class MergeActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public MergeActivity(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            AbstractUnaryOutputSourceOperatorNodePushable op = new AbstractUnaryOutputSourceOperatorNodePushable(){

                @Override
                public void initialize() throws HyracksDataException {
                    SortTaskState state = (SortTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(ExternalSortOperatorDescriptor.this.getOperatorId(), 0), partition));
                    List runs = state.runs;
                    IFrameSorter frameSorter = state.frameSorter;
                    IBinaryComparator[] comparators = new IBinaryComparator[ExternalSortOperatorDescriptor.this.comparatorFactories.length];
                    for (int i = 0; i < ExternalSortOperatorDescriptor.this.comparatorFactories.length; ++i) {
                        comparators[i] = ExternalSortOperatorDescriptor.this.comparatorFactories[i].createBinaryComparator();
                    }
                    INormalizedKeyComputer nmkComputer = ExternalSortOperatorDescriptor.this.firstKeyNormalizerFactory == null ? null : ExternalSortOperatorDescriptor.this.firstKeyNormalizerFactory.createNormalizedKeyComputer();
                    int necessaryFrames = Math.min(runs.size() + 2, ExternalSortOperatorDescriptor.this.framesLimit);
                    ExternalSortRunMerger merger = new ExternalSortRunMerger(ctx, frameSorter, (List<IFrameReader>)runs, ExternalSortOperatorDescriptor.this.sortFields, comparators, nmkComputer, ExternalSortOperatorDescriptor.this.recordDescriptors[0], necessaryFrames, this.writer);
                    merger.process();
                }
            };
            return op;
        }
    }

    private class SortActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public SortActivity(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            AbstractUnaryInputSinkOperatorNodePushable op = new AbstractUnaryInputSinkOperatorNodePushable(){
                private ExternalSortRunGenerator runGen;

                public void open() throws HyracksDataException {
                    this.runGen = new ExternalSortRunGenerator(ctx, ExternalSortOperatorDescriptor.this.sortFields, ExternalSortOperatorDescriptor.this.firstKeyNormalizerFactory, ExternalSortOperatorDescriptor.this.comparatorFactories, ExternalSortOperatorDescriptor.this.recordDescriptors[0], ExternalSortOperatorDescriptor.this.alg, ExternalSortOperatorDescriptor.this.framesLimit);
                    this.runGen.open();
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.runGen.nextFrame(buffer);
                }

                public void close() throws HyracksDataException {
                    SortTaskState state = new SortTaskState(ctx.getJobletContext().getJobId(), new TaskId(SortActivity.this.getActivityId(), partition));
                    this.runGen.close();
                    state.runs = this.runGen.getRuns();
                    state.frameSorter = this.runGen.getFrameSorter();
                    ctx.setStateObject((IStateObject)state);
                }

                public void fail() throws HyracksDataException {
                    this.runGen.fail();
                }
            };
            return op;
        }
    }

    public static class SortTaskState
    extends AbstractStateObject {
        private List<IFrameReader> runs;
        private IFrameSorter frameSorter;

        public SortTaskState() {
        }

        private SortTaskState(JobId jobId, TaskId taskId) {
            super(jobId, taskId);
        }

        public void toBytes(DataOutput out) throws IOException {
        }

        public void fromBytes(DataInput in) throws IOException {
        }
    }
}

