/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.sort;

import edu.uci.ics.hyracks.dataflow.std.sort.Slot;
import java.nio.ByteBuffer;

public class BSTNodeUtil {
    static final int MINIMUM_FREE_SLOT_SIZE = 32;
    private static final int FRAME_PTR_SIZE = 4;
    private static final int OFFSET_SIZE = 2;
    static final int HEADER_SIZE = 2;
    private static final int HEADER_INDEX = 0;
    private static final int LEFT_CHILD_FRAME_INDEX = 2;
    private static final int LEFT_CHILD_OFFSET_INDEX = 6;
    private static final int RIGHT_CHILD_FRAME_INDEX = 8;
    private static final int RIGHT_CHILD_OFFSET_INDEX = 12;
    private static final int NEXT_FRAME_INDEX = 14;
    private static final int NEXT_OFFSET_INDEX = 18;
    private static final int PREV_FRAME_INDEX = 20;
    private static final int PREV_OFFSET_INDEX = 24;
    private static final byte INVALID = -128;
    private static final byte MASK = 127;
    static final int INVALID_INDEX = -1;

    static int getLeftChildFrameIx(Slot s, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        return BSTNodeUtil.getLeftChildFrameIx(s.getFrameIx(), s.getOffset(), frames, convertBuffer);
    }

    static int getLeftChildOffset(Slot s, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        return BSTNodeUtil.getLeftChildOffset(s.getFrameIx(), s.getOffset(), frames, convertBuffer);
    }

    static int getLeftChildFrameIx(int frameIx, int offset, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        return BSTNodeUtil.retrieveAsInt(frames[frameIx], offset + 2, 4, convertBuffer);
    }

    static int getLeftChildOffset(int frameIx, int offset, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        return BSTNodeUtil.retrieveAsInt(frames[frameIx], offset + 6, 2, convertBuffer);
    }

    static void setLeftChild(Slot node, Slot lc, ByteBuffer[] frames) {
        BSTNodeUtil.setLeftChild(node.getFrameIx(), node.getOffset(), lc.getFrameIx(), lc.getOffset(), frames);
    }

    static void setLeftChild(int nodeFix, int nodeOff, int lcFix, int lcOff, ByteBuffer[] frames) {
        BSTNodeUtil.storeInt(frames[nodeFix], nodeOff + 2, 4, lcFix);
        BSTNodeUtil.storeInt(frames[nodeFix], nodeOff + 6, 2, lcOff);
    }

    static int getRightChildFrameIx(Slot s, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        return BSTNodeUtil.getRightChildFrameIx(s.getFrameIx(), s.getOffset(), frames, convertBuffer);
    }

    static int getRightChildOffset(Slot s, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        return BSTNodeUtil.getRightChildOffset(s.getFrameIx(), s.getOffset(), frames, convertBuffer);
    }

    static int getRightChildFrameIx(int frameIx, int offset, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        return BSTNodeUtil.retrieveAsInt(frames[frameIx], offset + 8, 4, convertBuffer);
    }

    static int getRightChildOffset(int frameIx, int offset, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        return BSTNodeUtil.retrieveAsInt(frames[frameIx], offset + 12, 2, convertBuffer);
    }

    static void setRightChild(Slot node, Slot rc, ByteBuffer[] frames) {
        BSTNodeUtil.setRightChild(node.getFrameIx(), node.getOffset(), rc.getFrameIx(), rc.getOffset(), frames);
    }

    static void setRightChild(int nodeFix, int nodeOff, int rcFix, int rcOff, ByteBuffer[] frames) {
        BSTNodeUtil.storeInt(frames[nodeFix], nodeOff + 8, 4, rcFix);
        BSTNodeUtil.storeInt(frames[nodeFix], nodeOff + 12, 2, rcOff);
    }

    static int getNextFrameIx(Slot s, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        return BSTNodeUtil.getNextFrameIx(s.getFrameIx(), s.getOffset(), frames, convertBuffer);
    }

    static int getNextOffset(Slot s, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        return BSTNodeUtil.getNextOffset(s.getFrameIx(), s.getOffset(), frames, convertBuffer);
    }

    static int getNextFrameIx(int frameIx, int offset, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        return BSTNodeUtil.retrieveAsInt(frames[frameIx], offset + 14, 4, convertBuffer);
    }

    static int getNextOffset(int frameIx, int offset, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        return BSTNodeUtil.retrieveAsInt(frames[frameIx], offset + 18, 2, convertBuffer);
    }

    static void setNext(Slot node, Slot next, ByteBuffer[] frames) {
        BSTNodeUtil.setNext(node.getFrameIx(), node.getOffset(), next.getFrameIx(), node.getOffset(), frames);
    }

    static void setNext(int nodeFix, int nodeOff, int nFix, int nOff, ByteBuffer[] frames) {
        BSTNodeUtil.storeInt(frames[nodeFix], nodeOff + 14, 4, nFix);
        BSTNodeUtil.storeInt(frames[nodeFix], nodeOff + 18, 2, nOff);
    }

    static int getPrevFrameIx(Slot s, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        return BSTNodeUtil.getPrevFrameIx(s.getFrameIx(), s.getOffset(), frames, convertBuffer);
    }

    static int getPrevOffset(Slot s, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        return BSTNodeUtil.getPrevOffset(s.getFrameIx(), s.getOffset(), frames, convertBuffer);
    }

    static int getPrevFrameIx(int frameIx, int offset, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        return BSTNodeUtil.retrieveAsInt(frames[frameIx], offset + 20, 4, convertBuffer);
    }

    static int getPrevOffset(int frameIx, int offset, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        return BSTNodeUtil.retrieveAsInt(frames[frameIx], offset + 24, 2, convertBuffer);
    }

    static void setPrev(Slot node, Slot prev, ByteBuffer[] frames) {
        BSTNodeUtil.setPrev(node.getFrameIx(), node.getOffset(), prev.getFrameIx(), prev.getOffset(), frames);
    }

    static void setPrev(int nodeFix, int nodeOff, int pFix, int pOff, ByteBuffer[] frames) {
        BSTNodeUtil.storeInt(frames[nodeFix], nodeOff + 20, 4, pFix);
        BSTNodeUtil.storeInt(frames[nodeFix], nodeOff + 24, 2, pOff);
    }

    static boolean slotsTheSame(Slot s, Slot t) {
        return s.getFrameIx() == t.getFrameIx() && s.getOffset() == t.getOffset();
    }

    static void setHeaderFooter(int frameIx, int offset, int usedLength, boolean isFree, ByteBuffer[] frames) {
        int slotLength = BSTNodeUtil.getActualLength(usedLength);
        int footerOffset = offset + 2 + slotLength;
        BSTNodeUtil.storeInt(frames[frameIx], offset, 2, usedLength);
        BSTNodeUtil.storeInt(frames[frameIx], footerOffset, 2, usedLength);
        BSTNodeUtil.setFree(frameIx, offset, isFree, frames);
        BSTNodeUtil.setFree(frameIx, footerOffset, isFree, frames);
    }

    static int getLength(Slot s, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        return BSTNodeUtil.getLength(s.getFrameIx(), s.getOffset(), frames, convertBuffer);
    }

    static int getLength(int frameIx, int offset, ByteBuffer[] frames, ByteBuffer convertBuffer) {
        convertBuffer.clear();
        for (int i = 0; i < 2; ++i) {
            convertBuffer.put(i, (byte)0);
        }
        convertBuffer.put(2, (byte)(frames[frameIx].get(offset) & 0x7F));
        System.arraycopy(frames[frameIx].array(), offset + 1, convertBuffer.array(), 3, 1);
        return convertBuffer.getInt(0);
    }

    static boolean isFree(int frameIx, int offset, ByteBuffer[] frames) {
        return (frames[frameIx].array()[offset] & 0x80) == 128;
    }

    static void setFree(int frameIx, int offset, boolean free, ByteBuffer[] frames) {
        if (free) {
            frames[frameIx].put(offset, (byte)(frames[frameIx].array()[offset] | 0x80));
        } else {
            frames[frameIx].put(offset, (byte)(frames[frameIx].array()[offset] & 0x7F));
        }
    }

    static int getActualLength(int l) {
        int r = (l + 4) % 32;
        return r == 0 ? l : l + (32 - r);
    }

    private static int retrieveAsInt(ByteBuffer b, int fromIndex, int size, ByteBuffer convertBuffer) {
        if ((b.get(fromIndex) & 0xFFFFFF80) == -128) {
            return -1;
        }
        convertBuffer.clear();
        for (int i = 0; i < 4 - size; ++i) {
            convertBuffer.put(i, (byte)0);
        }
        System.arraycopy(b.array(), fromIndex, convertBuffer.array(), 4 - size, size);
        return convertBuffer.getInt(0);
    }

    private static void storeInt(ByteBuffer b, int fromIndex, int size, int value) {
        if (value == -1) {
            b.put(fromIndex, (byte)-128);
            return;
        }
        for (int i = 0; i < size; ++i) {
            b.put(fromIndex + i, (byte)(value >>> 8 * (size - 1 - i) & 0xFF));
        }
    }
}

