/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.sort;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.std.sort.BSTNodeUtil;
import edu.uci.ics.hyracks.dataflow.std.sort.IMemoryManager;
import edu.uci.ics.hyracks.dataflow.std.sort.Slot;
import java.nio.ByteBuffer;

public class BSTMemMgr
implements IMemoryManager {
    private final IHyracksTaskContext ctx;
    public static int frameSize;
    private ByteBuffer[] frames;
    private ByteBuffer convertBuffer;
    private Slot root;
    private Slot result;
    private Slot insertSlot;
    private Slot lastLeftParent;
    private Slot lastLeft;
    private Slot parent;
    private Slot[] parentRes;
    private int lastFrame;

    public BSTMemMgr(IHyracksTaskContext ctx, int memSize) {
        this.ctx = ctx;
        frameSize = ctx.getFrameSize();
        this.convertBuffer = ByteBuffer.allocate(4);
        this.frames = new ByteBuffer[memSize];
        this.lastFrame = -1;
        this.root = new Slot();
        this.insertSlot = new Slot();
        this.result = new Slot();
        this.lastLeftParent = new Slot();
        this.lastLeft = new Slot();
        this.parent = new Slot();
        this.parentRes = new Slot[]{new Slot(), new Slot()};
    }

    @Override
    public void allocate(int length, Slot result) throws HyracksDataException {
        int acLen;
        int sl;
        this.search(length, this.parentRes);
        if (this.parentRes[1].isNull()) {
            this.addFrame(this.parentRes);
            if (this.parentRes[1].isNull()) {
                return;
            }
        }
        if (this.shouldSplit(sl = BSTNodeUtil.getLength(this.parentRes[1], this.frames, this.convertBuffer), acLen = BSTNodeUtil.getActualLength(length))) {
            int[] s = this.split(this.parentRes[1], this.parentRes[0], acLen);
            int insertLen = BSTNodeUtil.getLength(s[2], s[3], this.frames, this.convertBuffer);
            this.insert(s[2], s[3], insertLen);
            BSTNodeUtil.setHeaderFooter(s[0], s[1], length, false, this.frames);
            result.set(s[0], s[1]);
            return;
        }
        this.allocate(this.parentRes[1], this.parentRes[0], length, result);
    }

    @Override
    public int unallocate(Slot s) throws HyracksDataException {
        int nextMemSlotHeaderOffset;
        int usedLen = BSTNodeUtil.getLength(s, this.frames, this.convertBuffer);
        int actualLen = BSTNodeUtil.getActualLength(usedLen);
        int fix = s.getFrameIx();
        int off = s.getOffset();
        int prevMemSlotFooterOffset = off - 2 >= 0 ? off - 2 : -1;
        int t = off + 4 + actualLen;
        int n = nextMemSlotHeaderOffset = t < frameSize ? t : -1;
        if (!this.isNodeNull(fix, prevMemSlotFooterOffset) && BSTNodeUtil.isFree(fix, prevMemSlotFooterOffset, this.frames)) {
            int leftLength = BSTNodeUtil.getLength(fix, prevMemSlotFooterOffset, this.frames, this.convertBuffer);
            this.removeFromList(fix, prevMemSlotFooterOffset - leftLength - 2);
            int concatLength = actualLen + leftLength + 4;
            if (!this.isNodeNull(fix, nextMemSlotHeaderOffset) && BSTNodeUtil.isFree(fix, nextMemSlotHeaderOffset, this.frames)) {
                this.removeFromList(fix, nextMemSlotHeaderOffset);
                concatLength += BSTNodeUtil.getLength(fix, nextMemSlotHeaderOffset, this.frames, this.convertBuffer) + 4;
            }
            this.insert(fix, prevMemSlotFooterOffset - leftLength - 2, concatLength);
            return concatLength;
        }
        if (!this.isNodeNull(fix, nextMemSlotHeaderOffset) && BSTNodeUtil.isFree(fix, nextMemSlotHeaderOffset, this.frames)) {
            this.removeFromList(fix, nextMemSlotHeaderOffset);
            int concatLength = actualLen + BSTNodeUtil.getLength(fix, nextMemSlotHeaderOffset, this.frames, this.convertBuffer) + 4;
            this.insert(fix, off, concatLength);
            return concatLength;
        }
        this.insert(fix, off, actualLen);
        return actualLen;
    }

    @Override
    public boolean readTuple(int frameIx, int offset, FrameTupleAppender dest) {
        int offToRead = offset + 2;
        int length = BSTNodeUtil.getLength(frameIx, offset, this.frames, this.convertBuffer);
        return dest.append(this.frames[frameIx].array(), offToRead, length);
    }

    @Override
    public boolean writeTuple(int frameIx, int offset, FrameTupleAccessor src, int tIndex) {
        int offToCopy = offset + 2;
        int tStartOffset = src.getTupleStartOffset(tIndex);
        int tEndOffset = src.getTupleEndOffset(tIndex);
        int tupleLength = tEndOffset - tStartOffset;
        ByteBuffer srcBuffer = src.getBuffer();
        System.arraycopy(srcBuffer.array(), tStartOffset, this.frames[frameIx].array(), offToCopy, tupleLength);
        return true;
    }

    @Override
    public ByteBuffer getFrame(int frameIndex) {
        return this.frames[frameIndex];
    }

    @Override
    public void close() {
        for (int i = 0; i < this.frames.length; ++i) {
            this.frames[i] = null;
        }
    }

    private void addFrame(Slot[] parentResult) throws HyracksDataException {
        this.clear(parentResult);
        if (this.lastFrame + 1 >= this.frames.length) {
            return;
        }
        this.frames[++this.lastFrame] = this.allocateFrame();
        int l = frameSize - 4;
        BSTNodeUtil.setHeaderFooter(this.lastFrame, 0, l, true, this.frames);
        this.initNewNode(this.lastFrame, 0);
        parentResult[1].copy(this.root);
        if (parentResult[1].isNull()) {
            this.root.set(this.lastFrame, 0);
            this.initNewNode(this.root.getFrameIx(), this.root.getOffset());
            parentResult[1].copy(this.root);
            return;
        }
        while (!parentResult[1].isNull()) {
            if (BSTNodeUtil.getLength(parentResult[1], this.frames, this.convertBuffer) == l) {
                this.append(parentResult[1].getFrameIx(), parentResult[1].getOffset(), this.lastFrame, 0);
                parentResult[1].set(this.lastFrame, 0);
                return;
            }
            if (l < BSTNodeUtil.getLength(parentResult[1], this.frames, this.convertBuffer)) {
                if (this.isNodeNull(BSTNodeUtil.getLeftChildFrameIx(parentResult[1], this.frames, this.convertBuffer), BSTNodeUtil.getLeftChildOffset(parentResult[1], this.frames, this.convertBuffer))) {
                    BSTNodeUtil.setLeftChild(parentResult[1].getFrameIx(), parentResult[1].getOffset(), this.lastFrame, 0, this.frames);
                    parentResult[0].copy(parentResult[1]);
                    parentResult[1].set(this.lastFrame, 0);
                    return;
                }
                parentResult[0].copy(parentResult[1]);
                parentResult[1].set(BSTNodeUtil.getLeftChildFrameIx(parentResult[1], this.frames, this.convertBuffer), BSTNodeUtil.getLeftChildOffset(parentResult[1], this.frames, this.convertBuffer));
                continue;
            }
            if (this.isNodeNull(BSTNodeUtil.getRightChildFrameIx(parentResult[1], this.frames, this.convertBuffer), BSTNodeUtil.getRightChildOffset(parentResult[1], this.frames, this.convertBuffer))) {
                BSTNodeUtil.setRightChild(parentResult[1].getFrameIx(), parentResult[1].getOffset(), this.lastFrame, 0, this.frames);
                parentResult[0].copy(parentResult[1]);
                parentResult[1].set(this.lastFrame, 0);
                return;
            }
            parentResult[0].copy(parentResult[1]);
            parentResult[1].set(BSTNodeUtil.getRightChildFrameIx(parentResult[1], this.frames, this.convertBuffer), BSTNodeUtil.getRightChildOffset(parentResult[1], this.frames, this.convertBuffer));
        }
        throw new HyracksDataException("New Frame could not be added to BSTMemMgr");
    }

    private void insert(int fix, int off, int length) throws HyracksDataException {
        BSTNodeUtil.setHeaderFooter(fix, off, length, true, this.frames);
        this.initNewNode(fix, off);
        if (this.root.isNull()) {
            this.root.set(fix, off);
            return;
        }
        this.insertSlot.clear();
        this.insertSlot.copy(this.root);
        while (!this.insertSlot.isNull()) {
            int rightChildOffset;
            int curSlotLen = BSTNodeUtil.getLength(this.insertSlot, this.frames, this.convertBuffer);
            if (curSlotLen == length) {
                this.append(this.insertSlot.getFrameIx(), this.insertSlot.getOffset(), fix, off);
                return;
            }
            if (length < curSlotLen) {
                int leftChildOffset;
                int leftChildFIx = BSTNodeUtil.getLeftChildFrameIx(this.insertSlot, this.frames, this.convertBuffer);
                if (this.isNodeNull(leftChildFIx, leftChildOffset = BSTNodeUtil.getLeftChildOffset(this.insertSlot, this.frames, this.convertBuffer))) {
                    this.initNewNode(fix, off);
                    BSTNodeUtil.setLeftChild(this.insertSlot.getFrameIx(), this.insertSlot.getOffset(), fix, off, this.frames);
                    return;
                }
                this.insertSlot.set(leftChildFIx, leftChildOffset);
                continue;
            }
            int rightChildFIx = BSTNodeUtil.getRightChildFrameIx(this.insertSlot, this.frames, this.convertBuffer);
            if (this.isNodeNull(rightChildFIx, rightChildOffset = BSTNodeUtil.getRightChildOffset(this.insertSlot, this.frames, this.convertBuffer))) {
                this.initNewNode(fix, off);
                BSTNodeUtil.setRightChild(this.insertSlot.getFrameIx(), this.insertSlot.getOffset(), fix, off, this.frames);
                return;
            }
            this.insertSlot.set(rightChildFIx, rightChildOffset);
        }
        throw new HyracksDataException("Failure in node insertion into BST in BSTMemMgr");
    }

    private void search(int length, Slot[] target) {
        this.clear(target);
        this.result.clear();
        if (this.root.isNull()) {
            return;
        }
        this.lastLeftParent.clear();
        this.lastLeft.clear();
        this.parent.clear();
        this.result.copy(this.root);
        while (!this.result.isNull()) {
            int off;
            int fix;
            if (BSTNodeUtil.getLength(this.result, this.frames, this.convertBuffer) == length) {
                target[0].copy(this.parent);
                target[1].copy(this.result);
                return;
            }
            if (length < BSTNodeUtil.getLength(this.result, this.frames, this.convertBuffer)) {
                this.lastLeftParent.copy(this.parent);
                this.lastLeft.copy(this.result);
                this.parent.copy(this.result);
                fix = BSTNodeUtil.getLeftChildFrameIx(this.result, this.frames, this.convertBuffer);
                off = BSTNodeUtil.getLeftChildOffset(this.result, this.frames, this.convertBuffer);
                this.result.set(fix, off);
                continue;
            }
            this.parent.copy(this.result);
            fix = BSTNodeUtil.getRightChildFrameIx(this.result, this.frames, this.convertBuffer);
            off = BSTNodeUtil.getRightChildOffset(this.result, this.frames, this.convertBuffer);
            this.result.set(fix, off);
        }
        target[0].copy(this.lastLeftParent);
        target[1].copy(this.lastLeft);
    }

    private void append(int headFix, int headOff, int nodeFix, int nodeOff) {
        this.initNewNode(nodeFix, nodeOff);
        int fix = BSTNodeUtil.getNextFrameIx(headFix, headOff, this.frames, this.convertBuffer);
        int off = BSTNodeUtil.getNextOffset(headFix, headOff, this.frames, this.convertBuffer);
        BSTNodeUtil.setNext(nodeFix, nodeOff, fix, off, this.frames);
        if (!this.isNodeNull(fix, off)) {
            BSTNodeUtil.setPrev(fix, off, nodeFix, nodeOff, this.frames);
        }
        BSTNodeUtil.setPrev(nodeFix, nodeOff, headFix, headOff, this.frames);
        BSTNodeUtil.setNext(headFix, headOff, nodeFix, nodeOff, this.frames);
    }

    private int[] split(Slot listHead, Slot parent, int length) {
        int l2 = BSTNodeUtil.getLength(listHead, this.frames, this.convertBuffer) - length - 4;
        if (!this.isNodeNull(BSTNodeUtil.getNextFrameIx(listHead, this.frames, this.convertBuffer), BSTNodeUtil.getNextOffset(listHead, this.frames, this.convertBuffer))) {
            int afterHeadFix = BSTNodeUtil.getNextFrameIx(listHead, this.frames, this.convertBuffer);
            int afterHeadOff = BSTNodeUtil.getNextOffset(listHead, this.frames, this.convertBuffer);
            int afHNextFix = BSTNodeUtil.getNextFrameIx(afterHeadFix, afterHeadOff, this.frames, this.convertBuffer);
            int afHNextOff = BSTNodeUtil.getNextOffset(afterHeadFix, afterHeadOff, this.frames, this.convertBuffer);
            BSTNodeUtil.setNext(listHead.getFrameIx(), listHead.getOffset(), afHNextFix, afHNextOff, this.frames);
            if (!this.isNodeNull(afHNextFix, afHNextOff)) {
                BSTNodeUtil.setPrev(afHNextFix, afHNextOff, listHead.getFrameIx(), listHead.getOffset(), this.frames);
            }
            int secondOffset = afterHeadOff + length + 4;
            BSTNodeUtil.setHeaderFooter(afterHeadFix, afterHeadOff, length, true, this.frames);
            BSTNodeUtil.setHeaderFooter(afterHeadFix, secondOffset, l2, true, this.frames);
            return new int[]{afterHeadFix, afterHeadOff, afterHeadFix, secondOffset};
        }
        int secondOffset = listHead.getOffset() + length + 4;
        BSTNodeUtil.setHeaderFooter(listHead.getFrameIx(), listHead.getOffset(), length, true, this.frames);
        BSTNodeUtil.setHeaderFooter(listHead.getFrameIx(), secondOffset, l2, true, this.frames);
        this.fixTreePtrs(listHead.getFrameIx(), listHead.getOffset(), parent.getFrameIx(), parent.getOffset());
        return new int[]{listHead.getFrameIx(), listHead.getOffset(), listHead.getFrameIx(), secondOffset};
    }

    private void fixTreePtrs(int nodeFrameIx, int nodeOffset, int parentFrameIx, int parentOffset) {
        int nodeLeftChildFrameIx = BSTNodeUtil.getLeftChildFrameIx(nodeFrameIx, nodeOffset, this.frames, this.convertBuffer);
        int nodeLeftChildOffset = BSTNodeUtil.getLeftChildOffset(nodeFrameIx, nodeOffset, this.frames, this.convertBuffer);
        int nodeRightChildFrameIx = BSTNodeUtil.getRightChildFrameIx(nodeFrameIx, nodeOffset, this.frames, this.convertBuffer);
        int nodeRightChildOffset = BSTNodeUtil.getRightChildOffset(nodeFrameIx, nodeOffset, this.frames, this.convertBuffer);
        int status = -1;
        if (!this.isNodeNull(parentFrameIx, parentOffset)) {
            int plen;
            int nlen = BSTNodeUtil.getActualLength(BSTNodeUtil.getLength(nodeFrameIx, nodeOffset, this.frames, this.convertBuffer));
            int n = status = nlen < (plen = BSTNodeUtil.getActualLength(BSTNodeUtil.getLength(parentFrameIx, parentOffset, this.frames, this.convertBuffer))) ? 0 : 1;
        }
        if (!this.isNodeNull(nodeLeftChildFrameIx, nodeLeftChildOffset) && !this.isNodeNull(nodeRightChildFrameIx, nodeRightChildOffset)) {
            int pMinFIx = nodeFrameIx;
            int pMinOff = nodeOffset;
            int minFIx = nodeRightChildFrameIx;
            int minOff = nodeRightChildOffset;
            int nextLeftFIx = BSTNodeUtil.getLeftChildFrameIx(minFIx, minOff, this.frames, this.convertBuffer);
            int nextLeftOff = BSTNodeUtil.getLeftChildOffset(minFIx, minOff, this.frames, this.convertBuffer);
            while (!this.isNodeNull(nextLeftFIx, nextLeftOff)) {
                pMinFIx = minFIx;
                pMinOff = minOff;
                minFIx = nextLeftFIx;
                minOff = nextLeftOff;
                nextLeftFIx = BSTNodeUtil.getLeftChildFrameIx(minFIx, minOff, this.frames, this.convertBuffer);
                nextLeftOff = BSTNodeUtil.getLeftChildOffset(minFIx, minOff, this.frames, this.convertBuffer);
            }
            if (nodeRightChildFrameIx == minFIx && nodeRightChildOffset == minOff) {
                BSTNodeUtil.setLeftChild(nodeRightChildFrameIx, nodeRightChildOffset, nodeLeftChildFrameIx, nodeLeftChildOffset, this.frames);
            } else {
                int minRightFIx = BSTNodeUtil.getRightChildFrameIx(minFIx, minOff, this.frames, this.convertBuffer);
                int minRightOffset = BSTNodeUtil.getRightChildOffset(minFIx, minOff, this.frames, this.convertBuffer);
                BSTNodeUtil.setRightChild(minFIx, minOff, nodeRightChildFrameIx, nodeRightChildOffset, this.frames);
                BSTNodeUtil.setLeftChild(minFIx, minOff, nodeLeftChildFrameIx, nodeLeftChildOffset, this.frames);
                BSTNodeUtil.setLeftChild(pMinFIx, pMinOff, minRightFIx, minRightOffset, this.frames);
            }
            if (!this.isNodeNull(parentFrameIx, parentOffset)) {
                if (status == 0) {
                    BSTNodeUtil.setLeftChild(parentFrameIx, parentOffset, minFIx, minOff, this.frames);
                } else if (status == 1) {
                    BSTNodeUtil.setRightChild(parentFrameIx, parentOffset, minFIx, minOff, this.frames);
                }
            } else {
                this.root.set(minFIx, minOff);
            }
            return;
        }
        if (!this.isNodeNull(nodeLeftChildFrameIx, nodeLeftChildOffset)) {
            if (status == 0) {
                BSTNodeUtil.setLeftChild(parentFrameIx, parentOffset, nodeLeftChildFrameIx, nodeLeftChildOffset, this.frames);
            } else if (status == 1) {
                BSTNodeUtil.setRightChild(parentFrameIx, parentOffset, nodeLeftChildFrameIx, nodeLeftChildOffset, this.frames);
            } else if (status == -1) {
                this.root.set(nodeLeftChildFrameIx, nodeLeftChildOffset);
            }
            return;
        }
        if (!this.isNodeNull(nodeRightChildFrameIx, nodeRightChildOffset)) {
            if (status == 0) {
                BSTNodeUtil.setLeftChild(parentFrameIx, parentOffset, nodeRightChildFrameIx, nodeRightChildOffset, this.frames);
            } else if (status == 1) {
                BSTNodeUtil.setRightChild(parentFrameIx, parentOffset, nodeRightChildFrameIx, nodeRightChildOffset, this.frames);
            } else if (status == -1) {
                this.root.set(nodeRightChildFrameIx, nodeRightChildOffset);
            }
            return;
        }
        if (status == 0) {
            BSTNodeUtil.setLeftChild(parentFrameIx, parentOffset, -1, -1, this.frames);
        } else if (status == 1) {
            BSTNodeUtil.setRightChild(parentFrameIx, parentOffset, -1, -1, this.frames);
        } else {
            this.root.clear();
        }
    }

    private void allocate(Slot node, Slot parent, int length, Slot result) {
        int nextOff;
        int nextFix = BSTNodeUtil.getNextFrameIx(node, this.frames, this.convertBuffer);
        if (!this.isNodeNull(nextFix, nextOff = BSTNodeUtil.getNextOffset(node, this.frames, this.convertBuffer))) {
            int nextOfNextFIx = BSTNodeUtil.getNextFrameIx(nextFix, nextOff, this.frames, this.convertBuffer);
            int nextOfNextOffset = BSTNodeUtil.getNextOffset(nextFix, nextOff, this.frames, this.convertBuffer);
            BSTNodeUtil.setNext(node.getFrameIx(), node.getOffset(), nextOfNextFIx, nextOfNextOffset, this.frames);
            if (!this.isNodeNull(nextOfNextFIx, nextOfNextOffset)) {
                BSTNodeUtil.setPrev(nextOfNextFIx, nextOfNextOffset, node.getFrameIx(), node.getOffset(), this.frames);
            }
            BSTNodeUtil.setHeaderFooter(nextFix, nextOff, length, false, this.frames);
            result.set(nextFix, nextOff);
            return;
        }
        this.fixTreePtrs(node.getFrameIx(), node.getOffset(), parent.getFrameIx(), parent.getOffset());
        BSTNodeUtil.setHeaderFooter(node.getFrameIx(), node.getOffset(), length, false, this.frames);
        result.copy(node);
    }

    private void removeFromList(int fix, int off) {
        int prevOffset;
        int nextFIx = BSTNodeUtil.getNextFrameIx(fix, off, this.frames, this.convertBuffer);
        int nextOffset = BSTNodeUtil.getNextOffset(fix, off, this.frames, this.convertBuffer);
        int prevFIx = BSTNodeUtil.getPrevFrameIx(fix, off, this.frames, this.convertBuffer);
        if (!this.isNodeNull(prevFIx, prevOffset = BSTNodeUtil.getPrevOffset(fix, off, this.frames, this.convertBuffer)) && !this.isNodeNull(nextFIx, nextOffset)) {
            BSTNodeUtil.setNext(prevFIx, prevOffset, nextFIx, nextOffset, this.frames);
            BSTNodeUtil.setPrev(nextFIx, nextOffset, prevFIx, prevOffset, this.frames);
            BSTNodeUtil.setNext(fix, off, -1, -1, this.frames);
            BSTNodeUtil.setPrev(fix, off, -1, -1, this.frames);
            return;
        }
        if (!this.isNodeNull(prevFIx, prevOffset)) {
            BSTNodeUtil.setNext(prevFIx, prevOffset, -1, -1, this.frames);
            BSTNodeUtil.setPrev(fix, off, -1, -1, this.frames);
            return;
        }
        int parentFIx = -1;
        int parentOffset = -1;
        int length = BSTNodeUtil.getActualLength(BSTNodeUtil.getLength(fix, off, this.frames, this.convertBuffer));
        fix = this.root.getFrameIx();
        off = this.root.getOffset();
        int curLen = BSTNodeUtil.getLength(fix, off, this.frames, this.convertBuffer);
        while (length != curLen) {
            parentFIx = fix;
            parentOffset = off;
            if (length < curLen) {
                fix = BSTNodeUtil.getLeftChildFrameIx(parentFIx, parentOffset, this.frames, this.convertBuffer);
                off = BSTNodeUtil.getLeftChildOffset(parentFIx, parentOffset, this.frames, this.convertBuffer);
            } else {
                fix = BSTNodeUtil.getRightChildFrameIx(parentFIx, parentOffset, this.frames, this.convertBuffer);
                off = BSTNodeUtil.getRightChildOffset(parentFIx, parentOffset, this.frames, this.convertBuffer);
            }
            curLen = BSTNodeUtil.getLength(fix, off, this.frames, this.convertBuffer);
        }
        if (!this.isNodeNull(nextFIx, nextOffset)) {
            BSTNodeUtil.setPrev(nextFIx, nextOffset, -1, -1, this.frames);
            int nodeLeftChildFIx = BSTNodeUtil.getLeftChildFrameIx(fix, off, this.frames, this.convertBuffer);
            int nodeLeftChildOffset = BSTNodeUtil.getLeftChildOffset(fix, off, this.frames, this.convertBuffer);
            int nodeRightChildFix = BSTNodeUtil.getRightChildFrameIx(fix, off, this.frames, this.convertBuffer);
            int nodeRightChildOffset = BSTNodeUtil.getRightChildOffset(fix, off, this.frames, this.convertBuffer);
            BSTNodeUtil.setLeftChild(nextFIx, nextOffset, nodeLeftChildFIx, nodeLeftChildOffset, this.frames);
            BSTNodeUtil.setRightChild(nextFIx, nextOffset, nodeRightChildFix, nodeRightChildOffset, this.frames);
            if (!this.isNodeNull(parentFIx, parentOffset)) {
                int parentLength = BSTNodeUtil.getLength(parentFIx, parentOffset, this.frames, this.convertBuffer);
                if (length < parentLength) {
                    BSTNodeUtil.setLeftChild(parentFIx, parentOffset, nextFIx, nextOffset, this.frames);
                } else {
                    BSTNodeUtil.setRightChild(parentFIx, parentOffset, nextFIx, nextOffset, this.frames);
                }
            }
            if (this.root.getFrameIx() == fix && this.root.getOffset() == off) {
                this.root.set(nextFIx, nextOffset);
            }
            return;
        }
        this.fixTreePtrs(fix, off, parentFIx, parentOffset);
    }

    private void clear(Slot[] s) {
        s[0].clear();
        s[1].clear();
    }

    private boolean isNodeNull(int frameIx, int offset) {
        return frameIx == -1 || offset == -1 || this.frames[frameIx] == null;
    }

    private boolean shouldSplit(int slotLength, int reqLength) {
        return slotLength - reqLength >= 32;
    }

    private void initNewNode(int frameIx, int offset) {
        BSTNodeUtil.setLeftChild(frameIx, offset, -1, -1, this.frames);
        BSTNodeUtil.setRightChild(frameIx, offset, -1, -1, this.frames);
        BSTNodeUtil.setNext(frameIx, offset, -1, -1, this.frames);
        BSTNodeUtil.setPrev(frameIx, offset, -1, -1, this.frames);
    }

    private ByteBuffer allocateFrame() throws HyracksDataException {
        return this.ctx.allocateFrame();
    }

    public String debugPrintMemory() {
        int nfix;
        int noff;
        Slot s = new Slot(0, 0);
        if (s.isNull()) {
            return "memory:\tNull";
        }
        String m = "memory:\n" + this.debugPrintSlot(0, 0) + "\n";
        int length = BSTNodeUtil.getActualLength(BSTNodeUtil.getLength(0, 0, this.frames, this.convertBuffer));
        int n = noff = length + 4 >= frameSize ? -1 : length + 4;
        int n2 = noff == -1 ? (this.frames.length == 1 ? -1 : 1) : (nfix = 0);
        if (noff == -1 && nfix != -1) {
            noff = 0;
        }
        s.set(nfix, noff);
        while (!this.isNodeNull(s.getFrameIx(), s.getOffset())) {
            m = m + this.debugPrintSlot(s.getFrameIx(), s.getOffset()) + "\n";
            length = BSTNodeUtil.getActualLength(BSTNodeUtil.getLength(s.getFrameIx(), s.getOffset(), this.frames, this.convertBuffer));
            int n3 = noff = s.getOffset() + length + 4 >= frameSize ? -1 : s.getOffset() + length + 4;
            int n4 = noff == -1 ? (this.frames.length - 1 == s.getFrameIx() ? -1 : s.getFrameIx() + 1) : (nfix = s.getFrameIx());
            if (noff == -1 && nfix != -1) {
                noff = 0;
            }
            s.set(nfix, noff);
        }
        return m;
    }

    public String debugPrintTree() {
        Slot node = new Slot();
        node.copy(this.root);
        if (!node.isNull()) {
            return this.debugPrintSubTree(node);
        }
        return "Null";
    }

    private String debugPrintSubTree(Slot r) {
        Slot node = new Slot();
        node.copy(r);
        int fix = node.getFrameIx();
        int off = node.getOffset();
        int lfix = BSTNodeUtil.getLeftChildFrameIx(node, this.frames, this.convertBuffer);
        int loff = BSTNodeUtil.getLeftChildOffset(node, this.frames, this.convertBuffer);
        int rfix = BSTNodeUtil.getRightChildFrameIx(node, this.frames, this.convertBuffer);
        int roff = BSTNodeUtil.getRightChildOffset(node, this.frames, this.convertBuffer);
        int nfix = BSTNodeUtil.getNextFrameIx(node, this.frames, this.convertBuffer);
        int noff = BSTNodeUtil.getNextOffset(node, this.frames, this.convertBuffer);
        int pfix = BSTNodeUtil.getPrevFrameIx(node, this.frames, this.convertBuffer);
        int poff = BSTNodeUtil.getPrevOffset(node, this.frames, this.convertBuffer);
        String s = "{" + r.getFrameIx() + ", " + r.getOffset() + " (Len: " + BSTNodeUtil.getLength(fix, off, this.frames, this.convertBuffer) + ") - " + "(LC: " + this.debugPrintSlot(lfix, loff) + ") - " + "(RC: " + this.debugPrintSlot(rfix, roff) + ") - " + "(NX: " + this.debugPrintSlot(nfix, noff) + ") - " + "(PR: " + this.debugPrintSlot(pfix, poff) + ")  }\n";
        if (!this.isNodeNull(lfix, loff)) {
            s = s + this.debugPrintSubTree(new Slot(lfix, loff)) + "\n";
        }
        if (!this.isNodeNull(rfix, roff)) {
            s = s + this.debugPrintSubTree(new Slot(rfix, roff)) + "\n";
        }
        return s;
    }

    private String debugPrintSlot(int fix, int off) {
        if (this.isNodeNull(fix, off)) {
            return "-1, -1";
        }
        int l = BSTNodeUtil.getLength(fix, off, this.frames, this.convertBuffer);
        int al = BSTNodeUtil.getActualLength(l);
        boolean f = BSTNodeUtil.isFree(fix, off, this.frames);
        return fix + ", " + off + " (free: " + f + ") (Len: " + l + ") (actual len: " + al + ") ";
    }
}

