/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.result;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.IResultSerializer;
import edu.uci.ics.hyracks.api.dataflow.value.IResultSerializerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.dataset.IDatasetPartitionManager;
import edu.uci.ics.hyracks.api.dataset.ResultSetId;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameOutputStream;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;

public class ResultWriterOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final ResultSetId rsId;
    private final boolean ordered;
    private final boolean asyncMode;
    private final IResultSerializerFactory resultSerializerFactory;

    public ResultWriterOperatorDescriptor(IOperatorDescriptorRegistry spec, ResultSetId rsId, boolean ordered, boolean asyncMode, IResultSerializerFactory resultSerializerFactory) throws IOException {
        super(spec, 1, 0);
        this.rsId = rsId;
        this.ordered = ordered;
        this.asyncMode = asyncMode;
        this.resultSerializerFactory = resultSerializerFactory;
    }

    public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, final int nPartitions) throws HyracksDataException {
        final IDatasetPartitionManager dpm = ctx.getDatasetPartitionManager();
        final ByteBuffer outputBuffer = ctx.allocateFrame();
        final FrameOutputStream frameOutputStream = new FrameOutputStream(ctx.getFrameSize());
        frameOutputStream.reset(outputBuffer, true);
        PrintStream printStream = new PrintStream((OutputStream)frameOutputStream);
        RecordDescriptor outRecordDesc = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0);
        final IResultSerializer resultSerializer = this.resultSerializerFactory.createResultSerializer(outRecordDesc, printStream);
        final FrameTupleAccessor frameTupleAccessor = new FrameTupleAccessor(ctx.getFrameSize(), outRecordDesc);
        return new AbstractUnaryInputSinkOperatorNodePushable(){
            IFrameWriter datasetPartitionWriter;

            public void open() throws HyracksDataException {
                try {
                    this.datasetPartitionWriter = dpm.createDatasetPartitionWriter(ctx, ResultWriterOperatorDescriptor.this.rsId, ResultWriterOperatorDescriptor.this.ordered, ResultWriterOperatorDescriptor.this.asyncMode, partition, nPartitions);
                    this.datasetPartitionWriter.open();
                    resultSerializer.init();
                }
                catch (HyracksException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                frameTupleAccessor.reset(buffer);
                for (int tIndex = 0; tIndex < frameTupleAccessor.getTupleCount(); ++tIndex) {
                    resultSerializer.appendTuple((IFrameTupleAccessor)frameTupleAccessor, tIndex);
                    if (frameOutputStream.appendTuple()) continue;
                    this.datasetPartitionWriter.nextFrame(outputBuffer);
                    frameOutputStream.reset(outputBuffer, true);
                    resultSerializer.appendTuple((IFrameTupleAccessor)frameTupleAccessor, tIndex);
                    frameOutputStream.appendTuple();
                }
            }

            public void fail() throws HyracksDataException {
                this.datasetPartitionWriter.fail();
            }

            public void close() throws HyracksDataException {
                if (frameOutputStream.getTupleCount() > 0) {
                    this.datasetPartitionWriter.nextFrame(outputBuffer);
                    frameOutputStream.reset(outputBuffer, true);
                }
                this.datasetPartitionWriter.close();
            }
        };
    }
}

