/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.misc;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputOperatorNodePushable;
import java.nio.ByteBuffer;

public class SplitOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;

    public SplitOperatorDescriptor(IOperatorDescriptorRegistry spec, RecordDescriptor rDesc, int outputArity) {
        super(spec, 1, outputArity);
        for (int i = 0; i < outputArity; ++i) {
            this.recordDescriptors[i] = rDesc;
        }
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        return new AbstractUnaryInputOperatorNodePushable(){
            private final IFrameWriter[] writers;
            {
                this.writers = new IFrameWriter[SplitOperatorDescriptor.this.outputArity];
            }

            public void close() throws HyracksDataException {
                for (IFrameWriter writer : this.writers) {
                    writer.close();
                }
            }

            public void fail() throws HyracksDataException {
                for (IFrameWriter writer : this.writers) {
                    writer.fail();
                }
            }

            public void nextFrame(ByteBuffer bufferAccessor) throws HyracksDataException {
                for (IFrameWriter writer : this.writers) {
                    FrameUtils.flushFrame((ByteBuffer)bufferAccessor, (IFrameWriter)writer);
                }
            }

            public void open() throws HyracksDataException {
                for (IFrameWriter writer : this.writers) {
                    writer.open();
                }
            }

            public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) {
                this.writers[index] = writer;
            }
        };
    }
}

