/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.misc;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.IActivity;
import edu.uci.ics.hyracks.api.dataflow.IActivityGraphBuilder;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.TaskId;
import edu.uci.ics.hyracks.api.dataflow.state.IStateObject;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileReader;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileWriter;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractActivityNode;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractStateObject;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MaterializingOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private static final int MATERIALIZER_ACTIVITY_ID = 0;
    private static final int READER_ACTIVITY_ID = 1;
    private static final int MATERIALIZER_READER_ACTIVITY_ID = 2;
    private boolean isSingleActivity;

    public MaterializingOperatorDescriptor(IOperatorDescriptorRegistry spec, RecordDescriptor recordDescriptor) {
        this(spec, recordDescriptor, false);
    }

    public MaterializingOperatorDescriptor(IOperatorDescriptorRegistry spec, RecordDescriptor recordDescriptor, boolean isSingleActivity) {
        super(spec, 1, 1);
        this.recordDescriptors[0] = recordDescriptor;
        this.isSingleActivity = isSingleActivity;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        if (this.isSingleActivity) {
            MaterializerReaderActivityNode mra = new MaterializerReaderActivityNode(new ActivityId(this.odId, 2));
            builder.addActivity((IOperatorDescriptor)this, (IActivity)mra);
            builder.addSourceEdge(0, (IActivity)mra, 0);
            builder.addTargetEdge(0, (IActivity)mra, 0);
        } else {
            MaterializerActivityNode ma = new MaterializerActivityNode(new ActivityId(this.odId, 0));
            ReaderActivityNode ra = new ReaderActivityNode(new ActivityId(this.odId, 1));
            builder.addActivity((IOperatorDescriptor)this, (IActivity)ma);
            builder.addSourceEdge(0, (IActivity)ma, 0);
            builder.addActivity((IOperatorDescriptor)this, (IActivity)ra);
            builder.addTargetEdge(0, (IActivity)ra, 0);
            builder.addBlockingEdge((IActivity)ma, (IActivity)ra);
        }
    }

    private final class ReaderActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public ReaderActivityNode(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            return new AbstractUnaryOutputSourceOperatorNodePushable(){

                @Override
                public void initialize() throws HyracksDataException {
                    ByteBuffer frame = ctx.allocateFrame();
                    MaterializerTaskState state = (MaterializerTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(MaterializingOperatorDescriptor.this.getOperatorId(), 0), partition));
                    state.writeOut(this.writer, frame);
                }

                @Override
                public void deinitialize() throws HyracksDataException {
                }
            };
        }
    }

    private final class MaterializerActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public MaterializerActivityNode(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            return new AbstractUnaryInputSinkOperatorNodePushable(){
                private MaterializerTaskState state;

                public void open() throws HyracksDataException {
                    this.state = new MaterializerTaskState(ctx.getJobletContext().getJobId(), new TaskId(MaterializerActivityNode.this.getActivityId(), partition));
                    this.state.open(ctx);
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.state.appendFrame(buffer);
                }

                public void close() throws HyracksDataException {
                    this.state.out.close();
                    ctx.setStateObject((IStateObject)this.state);
                }

                public void fail() throws HyracksDataException {
                }
            };
        }
    }

    private final class MaterializerReaderActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public MaterializerReaderActivityNode(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            return new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
                private MaterializerTaskState state;

                public void open() throws HyracksDataException {
                    this.state = new MaterializerTaskState(ctx.getJobletContext().getJobId(), new TaskId(MaterializerReaderActivityNode.this.getActivityId(), partition));
                    this.state.open(ctx);
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.state.appendFrame(buffer);
                }

                public void fail() throws HyracksDataException {
                }

                public void close() throws HyracksDataException {
                    this.state.out.close();
                    ByteBuffer frame = ctx.allocateFrame();
                    this.state.writeOut(this.writer, frame);
                }
            };
        }
    }

    public static class MaterializerTaskState
    extends AbstractStateObject {
        private RunFileWriter out;

        public MaterializerTaskState() {
        }

        private MaterializerTaskState(JobId jobId, TaskId taskId) {
            super(jobId, taskId);
        }

        public void toBytes(DataOutput out) throws IOException {
        }

        public void fromBytes(DataInput in) throws IOException {
        }

        public void open(IHyracksTaskContext ctx) throws HyracksDataException {
            FileReference file = ctx.getJobletContext().createManagedWorkspaceFile(MaterializingOperatorDescriptor.class.getSimpleName());
            this.out = new RunFileWriter(file, ctx.getIOManager());
            this.out.open();
        }

        public void appendFrame(ByteBuffer buffer) throws HyracksDataException {
            this.out.nextFrame(buffer);
        }

        public void writeOut(IFrameWriter writer, ByteBuffer frame) throws HyracksDataException {
            RunFileReader in = this.out.createReader();
            writer.open();
            try {
                in.open();
                while (in.nextFrame(frame)) {
                    frame.flip();
                    writer.nextFrame(frame);
                    frame.clear();
                }
                in.close();
            }
            catch (Exception e) {
                writer.fail();
                throw new HyracksDataException((Throwable)e);
            }
            finally {
                writer.close();
            }
        }
    }
}

