/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.misc;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import java.nio.ByteBuffer;

public class LimitOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final int outputLimit;

    public LimitOperatorDescriptor(IOperatorDescriptorRegistry spec, RecordDescriptor rDesc, int outputLimit) {
        super(spec, 1, 1);
        this.recordDescriptors[0] = rDesc;
        this.outputLimit = outputLimit;
    }

    public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        return new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
            private FrameTupleAccessor fta;
            private int currentSize;
            private boolean finished;

            public void open() throws HyracksDataException {
                this.fta = new FrameTupleAccessor(ctx.getFrameSize(), LimitOperatorDescriptor.this.recordDescriptors[0]);
                this.currentSize = 0;
                this.finished = false;
                this.writer.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                if (!this.finished) {
                    this.fta.reset(buffer);
                    int count = this.fta.getTupleCount();
                    if (this.currentSize + count > LimitOperatorDescriptor.this.outputLimit) {
                        ByteBuffer b = ctx.allocateFrame();
                        FrameTupleAppender partialAppender = new FrameTupleAppender(ctx.getFrameSize());
                        partialAppender.reset(b, true);
                        int copyCount = LimitOperatorDescriptor.this.outputLimit - this.currentSize;
                        for (int i = 0; i < copyCount; ++i) {
                            partialAppender.append((IFrameTupleAccessor)this.fta, i);
                            ++this.currentSize;
                        }
                        FrameUtils.makeReadable((ByteBuffer)b);
                        FrameUtils.flushFrame((ByteBuffer)b, (IFrameWriter)this.writer);
                        this.finished = true;
                    } else {
                        FrameUtils.flushFrame((ByteBuffer)buffer, (IFrameWriter)this.writer);
                        this.currentSize += count;
                    }
                }
            }

            public void fail() throws HyracksDataException {
                this.writer.fail();
            }

            public void close() throws HyracksDataException {
                this.writer.close();
            }
        };
    }
}

