/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.misc;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import java.nio.ByteBuffer;

public class ConstantTupleSourceOperatorNodePushable
extends AbstractUnaryOutputSourceOperatorNodePushable {
    private IHyracksTaskContext ctx;
    private int[] fieldSlots;
    private byte[] tupleData;
    private int tupleSize;

    public ConstantTupleSourceOperatorNodePushable(IHyracksTaskContext ctx, int[] fieldSlots, byte[] tupleData, int tupleSize) {
        this.fieldSlots = fieldSlots;
        this.tupleData = tupleData;
        this.tupleSize = tupleSize;
        this.ctx = ctx;
    }

    @Override
    public void initialize() throws HyracksDataException {
        ByteBuffer writeBuffer = this.ctx.allocateFrame();
        FrameTupleAppender appender = new FrameTupleAppender(this.ctx.getFrameSize());
        appender.reset(writeBuffer, true);
        if (this.fieldSlots != null && this.tupleData != null && this.tupleSize > 0) {
            appender.append(this.fieldSlots, this.tupleData, 0, this.tupleSize);
        }
        this.writer.open();
        try {
            FrameUtils.flushFrame((ByteBuffer)writeBuffer, (IFrameWriter)this.writer);
        }
        catch (Exception e) {
            this.writer.fail();
            throw new HyracksDataException((Throwable)e);
        }
        finally {
            this.writer.close();
        }
    }
}

