/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.map;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IDataWriter;
import edu.uci.ics.hyracks.api.dataflow.IOpenableDataWriter;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.IOpenableDataWriterOperator;
import edu.uci.ics.hyracks.dataflow.std.map.IDeserializedMapper;
import edu.uci.ics.hyracks.dataflow.std.map.IDeserializedMapperFactory;
import edu.uci.ics.hyracks.dataflow.std.util.DeserializedOperatorNodePushable;

public class DeserializedMapperOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final IDeserializedMapperFactory mapperFactory;

    public DeserializedMapperOperatorDescriptor(IOperatorDescriptorRegistry spec, IDeserializedMapperFactory mapperFactory, RecordDescriptor recordDescriptor) {
        super(spec, 1, 1);
        this.mapperFactory = mapperFactory;
        this.recordDescriptors[0] = recordDescriptor;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
        return new DeserializedOperatorNodePushable(ctx, new MapperOperator(), recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0));
    }

    private class MapperOperator
    implements IOpenableDataWriterOperator {
        private IDeserializedMapper mapper;
        private IOpenableDataWriter<Object[]> writer;

        private MapperOperator() {
        }

        public void close() throws HyracksDataException {
            this.writer.close();
        }

        public void fail() throws HyracksDataException {
            this.writer.fail();
        }

        public void open() throws HyracksDataException {
            this.mapper = DeserializedMapperOperatorDescriptor.this.mapperFactory.createMapper();
            this.writer.open();
        }

        @Override
        public void setDataWriter(int index, IOpenableDataWriter<Object[]> writer) {
            if (index != 0) {
                throw new IllegalArgumentException();
            }
            this.writer = writer;
        }

        public void writeData(Object[] data) throws HyracksDataException {
            this.mapper.map(data, (IDataWriter<Object[]>)this.writer);
        }
    }
}

