/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.join;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.IActivity;
import edu.uci.ics.hyracks.api.dataflow.IActivityGraphBuilder;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.TaskId;
import edu.uci.ics.hyracks.api.dataflow.state.IStateObject;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryHashFunctionFamily;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriter;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriterFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IPredicateEvaluator;
import edu.uci.ics.hyracks.api.dataflow.value.IPredicateEvaluatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePairComparator;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePairComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputer;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputerFamily;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTuplePairComparator;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.data.partition.FieldHashPartitionComputerFamily;
import edu.uci.ics.hyracks.dataflow.common.data.partition.RepartitionComputerGeneratorFactory;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileReader;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractActivityNode;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractStateObject;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.join.InMemoryHashJoin;
import edu.uci.ics.hyracks.dataflow.std.join.NestedLoopJoin;
import edu.uci.ics.hyracks.dataflow.std.join.OptimizedHybridHashJoin;
import edu.uci.ics.hyracks.dataflow.std.structures.SerializableHashTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.logging.Logger;

public class OptimizedHybridHashJoinOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final int BUILD_AND_PARTITION_ACTIVITY_ID = 0;
    private static final int PARTITION_AND_JOIN_ACTIVITY_ID = 1;
    private static final long serialVersionUID = 1L;
    private static final double NLJ_SWITCH_THRESHOLD = 0.8;
    private static final String PROBE_REL = "RelR";
    private static final String BUILD_REL = "RelS";
    private final int memsize;
    private final int inputsize0;
    private final double fudgeFactor;
    private final int[] probeKeys;
    private final int[] buildKeys;
    private final IBinaryHashFunctionFamily[] hashFunctionGeneratorFactories;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final ITuplePairComparatorFactory tuplePairComparatorFactory0;
    private final ITuplePairComparatorFactory tuplePairComparatorFactory1;
    private final IPredicateEvaluatorFactory predEvaluatorFactory;
    private final boolean isLeftOuter;
    private final INullWriterFactory[] nullWriterFactories1;
    private static boolean skipInMemoryHJ = false;
    private static boolean forceNLJ = false;
    private static boolean forceRR = false;
    private static final Logger LOGGER = Logger.getLogger(OptimizedHybridHashJoinOperatorDescriptor.class.getName());

    public OptimizedHybridHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int memsize, int inputsize0, double factor, int[] keys0, int[] keys1, IBinaryHashFunctionFamily[] hashFunctionGeneratorFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, ITuplePairComparatorFactory tupPaircomparatorFactory0, ITuplePairComparatorFactory tupPaircomparatorFactory1, IPredicateEvaluatorFactory predEvaluatorFactory, boolean isLeftOuter, INullWriterFactory[] nullWriterFactories1) throws HyracksDataException {
        super(spec, 2, 1);
        this.memsize = memsize;
        this.inputsize0 = inputsize0;
        this.fudgeFactor = factor;
        this.probeKeys = keys0;
        this.buildKeys = keys1;
        this.hashFunctionGeneratorFactories = hashFunctionGeneratorFactories;
        this.comparatorFactories = comparatorFactories;
        this.tuplePairComparatorFactory0 = tupPaircomparatorFactory0;
        this.tuplePairComparatorFactory1 = tupPaircomparatorFactory1;
        this.recordDescriptors[0] = recordDescriptor;
        this.predEvaluatorFactory = predEvaluatorFactory;
        this.isLeftOuter = isLeftOuter;
        this.nullWriterFactories1 = nullWriterFactories1;
    }

    public OptimizedHybridHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int memsize, int inputsize0, double factor, int[] keys0, int[] keys1, IBinaryHashFunctionFamily[] hashFunctionGeneratorFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, ITuplePairComparatorFactory tupPaircomparatorFactory0, ITuplePairComparatorFactory tupPaircomparatorFactory1, IPredicateEvaluatorFactory predEvaluatorFactory) throws HyracksDataException {
        super(spec, 2, 1);
        this.memsize = memsize;
        this.inputsize0 = inputsize0;
        this.fudgeFactor = factor;
        this.probeKeys = keys0;
        this.buildKeys = keys1;
        this.hashFunctionGeneratorFactories = hashFunctionGeneratorFactories;
        this.comparatorFactories = comparatorFactories;
        this.tuplePairComparatorFactory0 = tupPaircomparatorFactory0;
        this.tuplePairComparatorFactory1 = tupPaircomparatorFactory1;
        this.predEvaluatorFactory = predEvaluatorFactory;
        this.recordDescriptors[0] = recordDescriptor;
        this.isLeftOuter = false;
        this.nullWriterFactories1 = null;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        ActivityId buildAid = new ActivityId(this.odId, 0);
        ActivityId probeAid = new ActivityId(this.odId, 1);
        PartitionAndBuildActivityNode phase1 = new PartitionAndBuildActivityNode(buildAid, probeAid);
        ProbeAndJoinActivityNode phase2 = new ProbeAndJoinActivityNode(probeAid, buildAid);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)phase1);
        builder.addSourceEdge(1, (IActivity)phase1, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)phase2);
        builder.addSourceEdge(0, (IActivity)phase2, 0);
        builder.addBlockingEdge((IActivity)phase1, (IActivity)phase2);
        builder.addTargetEdge(0, (IActivity)phase2, 0);
    }

    private int getNumberOfPartitions(int memorySize, int buildSize, double factor, int nPartitions) throws HyracksDataException {
        int numberOfPartitions = 0;
        if (memorySize <= 1) {
            throw new HyracksDataException("not enough memory is available for Hybrid Hash Join");
        }
        if (memorySize > buildSize) {
            return 1;
        }
        numberOfPartitions = (int)Math.ceil(((double)buildSize * factor / (double)nPartitions - (double)memorySize) / (double)(memorySize - 1));
        if (numberOfPartitions <= 0) {
            numberOfPartitions = 1;
        }
        if (numberOfPartitions > memorySize) {
            numberOfPartitions = (int)Math.ceil(Math.sqrt((double)buildSize * factor / (double)nPartitions));
            return numberOfPartitions < memorySize ? numberOfPartitions : memorySize;
        }
        return numberOfPartitions;
    }

    public void setSkipInMemHJ(boolean b) {
        skipInMemoryHJ = b;
    }

    public void setForceNLJ(boolean b) {
        forceNLJ = b;
    }

    public void setForceRR(boolean b) {
        forceRR = !this.isLeftOuter && b;
    }

    private class ProbeAndJoinActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;
        private final ActivityId buildAid;

        public ProbeAndJoinActivityNode(ActivityId id, ActivityId buildAid) {
            super(id);
            this.buildAid = buildAid;
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, final int nPartitions) throws HyracksDataException {
            INullWriter[] nullWriters1;
            final RecordDescriptor probeRd = recordDescProvider.getInputRecordDescriptor(this.buildAid, 0);
            final RecordDescriptor buildRd = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0);
            final IBinaryComparator[] comparators = new IBinaryComparator[OptimizedHybridHashJoinOperatorDescriptor.this.comparatorFactories.length];
            final ITuplePairComparator nljComparator0 = OptimizedHybridHashJoinOperatorDescriptor.this.tuplePairComparatorFactory0.createTuplePairComparator(ctx);
            final ITuplePairComparator nljComparator1 = OptimizedHybridHashJoinOperatorDescriptor.this.tuplePairComparatorFactory1.createTuplePairComparator(ctx);
            final IPredicateEvaluator predEvaluator = OptimizedHybridHashJoinOperatorDescriptor.this.predEvaluatorFactory == null ? null : OptimizedHybridHashJoinOperatorDescriptor.this.predEvaluatorFactory.createPredicateEvaluator();
            for (int i = 0; i < OptimizedHybridHashJoinOperatorDescriptor.this.comparatorFactories.length; ++i) {
                comparators[i] = OptimizedHybridHashJoinOperatorDescriptor.this.comparatorFactories[i].createBinaryComparator();
            }
            INullWriter[] iNullWriterArray = nullWriters1 = OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter ? new INullWriter[OptimizedHybridHashJoinOperatorDescriptor.this.nullWriterFactories1.length] : null;
            if (OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter) {
                for (int i = 0; i < OptimizedHybridHashJoinOperatorDescriptor.this.nullWriterFactories1.length; ++i) {
                    nullWriters1[i] = OptimizedHybridHashJoinOperatorDescriptor.this.nullWriterFactories1[i].createNullWriter();
                }
            }
            AbstractUnaryInputUnaryOutputOperatorNodePushable op = new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
                private BuildAndPartitionTaskState state;
                private ByteBuffer rPartbuff;
                private ITuplePartitionComputerFamily hpcf0;
                private ITuplePartitionComputerFamily hpcf1;
                private ITuplePartitionComputer hpcRep0;
                private ITuplePartitionComputer hpcRep1;
                {
                    this.rPartbuff = ctx.allocateFrame();
                    this.hpcf0 = new FieldHashPartitionComputerFamily(OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys, OptimizedHybridHashJoinOperatorDescriptor.this.hashFunctionGeneratorFactories);
                    this.hpcf1 = new FieldHashPartitionComputerFamily(OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys, OptimizedHybridHashJoinOperatorDescriptor.this.hashFunctionGeneratorFactories);
                }

                public void open() throws HyracksDataException {
                    this.state = (BuildAndPartitionTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(OptimizedHybridHashJoinOperatorDescriptor.this.getOperatorId(), 0), partition));
                    this.writer.open();
                    this.state.hybridHJ.initProbe();
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.state.hybridHJ.probe(buffer, this.writer);
                }

                public void fail() throws HyracksDataException {
                    this.writer.fail();
                }

                public void close() throws HyracksDataException {
                    this.state.hybridHJ.closeProbe(this.writer);
                    BitSet partitionStatus = this.state.hybridHJ.getPartitinStatus();
                    this.hpcRep0 = new RepartitionComputerGeneratorFactory(this.state.numOfPartitions, this.hpcf0).createPartitioner(0);
                    this.hpcRep1 = new RepartitionComputerGeneratorFactory(this.state.numOfPartitions, this.hpcf1).createPartitioner(0);
                    this.rPartbuff.clear();
                    int pid = partitionStatus.nextSetBit(0);
                    while (pid >= 0) {
                        RunFileReader bReader = this.state.hybridHJ.getBuildRFReader(pid);
                        RunFileReader pReader = this.state.hybridHJ.getProbeRFReader(pid);
                        if (bReader != null && pReader != null) {
                            int pSize;
                            int bSize = this.state.hybridHJ.getBuildPartitionSizeInTup(pid);
                            int beforeMax = bSize > (pSize = this.state.hybridHJ.getProbePartitionSizeInTup(pid)) ? bSize : pSize;
                            this.joinPartitionPair(this.state.hybridHJ, bReader, pReader, pid, beforeMax, 1, false);
                        }
                        pid = partitionStatus.nextSetBit(pid + 1);
                    }
                    this.writer.close();
                }

                private void joinPartitionPair(OptimizedHybridHashJoin ohhj, RunFileReader buildSideReader, RunFileReader probeSideReader, int pid, int beforeMax, int level, boolean wasReversed) throws HyracksDataException {
                    ITuplePartitionComputer probeHpc = new FieldHashPartitionComputerFamily(OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys, OptimizedHybridHashJoinOperatorDescriptor.this.hashFunctionGeneratorFactories).createPartitioner(level);
                    ITuplePartitionComputer buildHpc = new FieldHashPartitionComputerFamily(OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys, OptimizedHybridHashJoinOperatorDescriptor.this.hashFunctionGeneratorFactories).createPartitioner(level);
                    long buildPartSize = wasReversed ? ohhj.getProbePartitionSize(pid) / (long)ctx.getFrameSize() : ohhj.getBuildPartitionSize(pid) / (long)ctx.getFrameSize();
                    long probePartSize = wasReversed ? ohhj.getBuildPartitionSize(pid) / (long)ctx.getFrameSize() : ohhj.getProbePartitionSize(pid) / (long)ctx.getFrameSize();
                    LOGGER.fine("\n>>>Joining Partition Pairs (pid " + pid + ") - (level " + level + ") - wasReversed " + wasReversed + " - BuildSize:\t" + buildPartSize + "\tProbeSize:\t" + probePartSize + " - MemForJoin " + this.state.memForJoin + "  - LeftOuter is " + OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter);
                    if (!skipInMemoryHJ) {
                        if (buildPartSize < (long)this.state.memForJoin || probePartSize < (long)this.state.memForJoin && !OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter) {
                            int tabSize = -1;
                            if (!forceRR && (OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter || buildPartSize < probePartSize)) {
                                LOGGER.fine("\t>>>Case 1.1 (IsLeftOuter || buildSize<probe) AND ApplyInMemHJ - [Level " + level + "]");
                                int n = tabSize = wasReversed ? ohhj.getProbePartitionSizeInTup(pid) : ohhj.getBuildPartitionSizeInTup(pid);
                                if (tabSize == 0) {
                                    throw new HyracksDataException("Trying to join an empty partition. Invalid table size for inMemoryHashJoin.");
                                }
                                this.applyInMemHashJoin(OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys, OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys, tabSize, probeRd, buildRd, this.hpcRep0, this.hpcRep1, buildSideReader, probeSideReader, false, pid);
                            } else {
                                LOGGER.fine("\t>>>Case 1.2. (NoIsLeftOuter || probe<build) AND ApplyInMemHJ WITH RoleReversal - [Level " + level + "]");
                                int n = tabSize = wasReversed ? ohhj.getBuildPartitionSizeInTup(pid) : ohhj.getProbePartitionSizeInTup(pid);
                                if (tabSize == 0) {
                                    throw new HyracksDataException("Trying to join an empty partition. Invalid table size for inMemoryHashJoin.");
                                }
                                this.applyInMemHashJoin(OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys, OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys, tabSize, buildRd, probeRd, this.hpcRep1, this.hpcRep0, probeSideReader, buildSideReader, true, pid);
                            }
                        }
                    } else {
                        LOGGER.fine("\t>>>Case 2. ApplyRecursiveHHJ - [Level " + level + "]");
                        if (!forceRR && (OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter || buildPartSize < probePartSize)) {
                            LOGGER.fine("\t\t>>>Case 2.1 - RecursiveHHJ WITH (isLeftOuter || build<probe) - [Level " + level + "]");
                            int n = OptimizedHybridHashJoinOperatorDescriptor.this.getNumberOfPartitions(this.state.memForJoin, (int)buildPartSize, OptimizedHybridHashJoinOperatorDescriptor.this.fudgeFactor, nPartitions);
                            OptimizedHybridHashJoin rHHj = new OptimizedHybridHashJoin(ctx, this.state.memForJoin, n, OptimizedHybridHashJoinOperatorDescriptor.PROBE_REL, OptimizedHybridHashJoinOperatorDescriptor.BUILD_REL, OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys, OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys, comparators, probeRd, buildRd, probeHpc, buildHpc, predEvaluator);
                            buildSideReader.open();
                            rHHj.initBuild();
                            this.rPartbuff.clear();
                            while (buildSideReader.nextFrame(this.rPartbuff)) {
                                rHHj.build(this.rPartbuff);
                            }
                            rHHj.closeBuild();
                            probeSideReader.open();
                            rHHj.initProbe();
                            this.rPartbuff.clear();
                            while (probeSideReader.nextFrame(this.rPartbuff)) {
                                rHHj.probe(this.rPartbuff, this.writer);
                            }
                            rHHj.closeProbe(this.writer);
                            int maxAfterBuildSize = rHHj.getMaxBuildPartitionSize();
                            int maxAfterProbeSize = rHHj.getMaxProbePartitionSize();
                            int afterMax = maxAfterBuildSize > maxAfterProbeSize ? maxAfterBuildSize : maxAfterProbeSize;
                            BitSet rPStatus = rHHj.getPartitinStatus();
                            if (!forceNLJ && (double)afterMax < 0.8 * (double)beforeMax) {
                                LOGGER.fine("\t\t>>>Case 2.1.1 - KEEP APPLYING RecursiveHHJ WITH (isLeftOuter || build<probe) - [Level " + level + "]");
                                int rPid = rPStatus.nextSetBit(0);
                                while (rPid >= 0) {
                                    RunFileReader rbrfw = rHHj.getBuildRFReader(rPid);
                                    RunFileReader rprfw = rHHj.getProbeRFReader(rPid);
                                    if (rbrfw != null && rprfw != null) {
                                        this.joinPartitionPair(rHHj, rbrfw, rprfw, rPid, afterMax, level + 1, false);
                                    }
                                    rPid = rPStatus.nextSetBit(rPid + 1);
                                }
                            } else {
                                LOGGER.fine("\t\t>>>Case 2.1.2 - SWITCHED to NLJ RecursiveHHJ WITH (isLeftOuter || build<probe) - [Level " + level + "]");
                                int rPid = rPStatus.nextSetBit(0);
                                while (rPid >= 0) {
                                    RunFileReader rbrfw = rHHj.getBuildRFReader(rPid);
                                    RunFileReader rprfw = rHHj.getProbeRFReader(rPid);
                                    if (rbrfw != null && rprfw != null) {
                                        int buildSideInTups = rHHj.getBuildPartitionSizeInTup(rPid);
                                        int probeSideInTups = rHHj.getProbePartitionSizeInTup(rPid);
                                        if (OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter || buildSideInTups < probeSideInTups) {
                                            this.applyNestedLoopJoin(buildRd, probeRd, this.state.memForJoin, rprfw, rbrfw, nljComparator0, false);
                                        } else {
                                            this.applyNestedLoopJoin(probeRd, buildRd, this.state.memForJoin, rbrfw, rprfw, nljComparator1, true);
                                        }
                                    }
                                    rPid = rPStatus.nextSetBit(rPid + 1);
                                }
                            }
                        } else {
                            LOGGER.fine("\t\t>>>Case 2.2. - RecursiveHHJ WITH RoleReversal - [Level " + level + "]");
                            int n = OptimizedHybridHashJoinOperatorDescriptor.this.getNumberOfPartitions(this.state.memForJoin, (int)probePartSize, OptimizedHybridHashJoinOperatorDescriptor.this.fudgeFactor, nPartitions);
                            OptimizedHybridHashJoin rHHj = new OptimizedHybridHashJoin(ctx, this.state.memForJoin, n, OptimizedHybridHashJoinOperatorDescriptor.BUILD_REL, OptimizedHybridHashJoinOperatorDescriptor.PROBE_REL, OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys, OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys, comparators, buildRd, probeRd, buildHpc, probeHpc, predEvaluator);
                            rHHj.setIsReversed(true);
                            probeSideReader.open();
                            rHHj.initBuild();
                            this.rPartbuff.clear();
                            while (probeSideReader.nextFrame(this.rPartbuff)) {
                                rHHj.build(this.rPartbuff);
                            }
                            rHHj.closeBuild();
                            rHHj.initProbe();
                            buildSideReader.open();
                            this.rPartbuff.clear();
                            while (buildSideReader.nextFrame(this.rPartbuff)) {
                                rHHj.probe(this.rPartbuff, this.writer);
                            }
                            rHHj.closeProbe(this.writer);
                            int maxAfterBuildSize = rHHj.getMaxBuildPartitionSize();
                            int maxAfterProbeSize = rHHj.getMaxProbePartitionSize();
                            int afterMax = maxAfterBuildSize > maxAfterProbeSize ? maxAfterBuildSize : maxAfterProbeSize;
                            BitSet rPStatus = rHHj.getPartitinStatus();
                            if (!forceNLJ && (double)afterMax < 0.8 * (double)beforeMax) {
                                LOGGER.fine("\t\t>>>Case 2.2.1 - KEEP APPLYING RecursiveHHJ WITH RoleReversal - [Level " + level + "]");
                                int rPid = rPStatus.nextSetBit(0);
                                while (rPid >= 0) {
                                    RunFileReader rbrfw = rHHj.getBuildRFReader(rPid);
                                    RunFileReader rprfw = rHHj.getProbeRFReader(rPid);
                                    if (rbrfw != null && rprfw != null) {
                                        this.joinPartitionPair(rHHj, rprfw, rbrfw, rPid, afterMax, level + 1, true);
                                    }
                                    rPid = rPStatus.nextSetBit(rPid + 1);
                                }
                            } else {
                                LOGGER.fine("\t\t>>>Case 2.2.2 - SWITCHED to NLJ RecursiveHHJ WITH RoleReversal - [Level " + level + "]");
                                int rPid = rPStatus.nextSetBit(0);
                                while (rPid >= 0) {
                                    RunFileReader rbrfw = rHHj.getBuildRFReader(rPid);
                                    RunFileReader rprfw = rHHj.getProbeRFReader(rPid);
                                    if (rbrfw != null && rprfw != null) {
                                        long probeSideSize;
                                        long buildSideSize = rbrfw.getFileSize();
                                        if (buildSideSize > (probeSideSize = rprfw.getFileSize())) {
                                            this.applyNestedLoopJoin(buildRd, probeRd, this.state.memForJoin, rbrfw, rprfw, nljComparator0, true);
                                        } else {
                                            this.applyNestedLoopJoin(probeRd, buildRd, this.state.memForJoin, rprfw, rbrfw, nljComparator1, true);
                                        }
                                    }
                                    rPid = rPStatus.nextSetBit(rPid + 1);
                                }
                            }
                        }
                        buildSideReader.close();
                        probeSideReader.close();
                    }
                }

                private void applyInMemHashJoin(int[] bKeys, int[] pKeys, int tabSize, RecordDescriptor buildRDesc, RecordDescriptor probeRDesc, ITuplePartitionComputer hpcRepLarger, ITuplePartitionComputer hpcRepSmaller, RunFileReader bReader, RunFileReader pReader, boolean reverse, int pid) throws HyracksDataException {
                    SerializableHashTable table = new SerializableHashTable(tabSize, ctx);
                    InMemoryHashJoin joiner = new InMemoryHashJoin(ctx, tabSize, new FrameTupleAccessor(ctx.getFrameSize(), probeRDesc), hpcRepLarger, new FrameTupleAccessor(ctx.getFrameSize(), buildRDesc), hpcRepSmaller, new FrameTuplePairComparator(pKeys, bKeys, comparators), OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter, nullWriters1, table, predEvaluator, reverse);
                    bReader.open();
                    this.rPartbuff.clear();
                    while (bReader.nextFrame(this.rPartbuff)) {
                        ByteBuffer copyBuffer = ctx.allocateFrame();
                        FrameUtils.copy((ByteBuffer)this.rPartbuff, (ByteBuffer)copyBuffer);
                        FrameUtils.makeReadable((ByteBuffer)copyBuffer);
                        joiner.build(copyBuffer);
                        this.rPartbuff.clear();
                    }
                    bReader.close();
                    this.rPartbuff.clear();
                    pReader.open();
                    while (pReader.nextFrame(this.rPartbuff)) {
                        joiner.join(this.rPartbuff, this.writer);
                        this.rPartbuff.clear();
                    }
                    pReader.close();
                    joiner.closeJoin(this.writer);
                }

                private void applyNestedLoopJoin(RecordDescriptor outerRd, RecordDescriptor innerRd, int memorySize, RunFileReader outerReader, RunFileReader innerReader, ITuplePairComparator nljComparator, boolean reverse) throws HyracksDataException {
                    NestedLoopJoin nlj = new NestedLoopJoin(ctx, new FrameTupleAccessor(ctx.getFrameSize(), outerRd), new FrameTupleAccessor(ctx.getFrameSize(), innerRd), nljComparator, memorySize, predEvaluator, OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter, nullWriters1);
                    nlj.setIsReversed(reverse);
                    ByteBuffer cacheBuff = ctx.allocateFrame();
                    innerReader.open();
                    while (innerReader.nextFrame(cacheBuff)) {
                        FrameUtils.makeReadable((ByteBuffer)cacheBuff);
                        nlj.cache(cacheBuff);
                        cacheBuff.clear();
                    }
                    nlj.closeCache();
                    ByteBuffer joinBuff = ctx.allocateFrame();
                    outerReader.open();
                    while (outerReader.nextFrame(joinBuff)) {
                        FrameUtils.makeReadable((ByteBuffer)joinBuff);
                        nlj.join(joinBuff, this.writer);
                        joinBuff.clear();
                    }
                    nlj.closeJoin(this.writer);
                    outerReader.close();
                    innerReader.close();
                }
            };
            return op;
        }
    }

    private class PartitionAndBuildActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;
        private final ActivityId probeAid;

        public PartitionAndBuildActivityNode(ActivityId id, ActivityId probeAid) {
            super(id);
            this.probeAid = probeAid;
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, final int nPartitions) {
            final RecordDescriptor probeRd = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0);
            final RecordDescriptor buildRd = recordDescProvider.getInputRecordDescriptor(this.probeAid, 0);
            final IBinaryComparator[] comparators = new IBinaryComparator[OptimizedHybridHashJoinOperatorDescriptor.this.comparatorFactories.length];
            for (int i = 0; i < OptimizedHybridHashJoinOperatorDescriptor.this.comparatorFactories.length; ++i) {
                comparators[i] = OptimizedHybridHashJoinOperatorDescriptor.this.comparatorFactories[i].createBinaryComparator();
            }
            final IPredicateEvaluator predEvaluator = OptimizedHybridHashJoinOperatorDescriptor.this.predEvaluatorFactory == null ? null : OptimizedHybridHashJoinOperatorDescriptor.this.predEvaluatorFactory.createPredicateEvaluator();
            AbstractUnaryInputSinkOperatorNodePushable op = new AbstractUnaryInputSinkOperatorNodePushable(){
                private BuildAndPartitionTaskState state;
                ITuplePartitionComputer probeHpc;
                ITuplePartitionComputer buildHpc;
                {
                    this.state = new BuildAndPartitionTaskState(ctx.getJobletContext().getJobId(), new TaskId(PartitionAndBuildActivityNode.this.getActivityId(), partition));
                    this.probeHpc = new FieldHashPartitionComputerFamily(OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys, OptimizedHybridHashJoinOperatorDescriptor.this.hashFunctionGeneratorFactories).createPartitioner(0);
                    this.buildHpc = new FieldHashPartitionComputerFamily(OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys, OptimizedHybridHashJoinOperatorDescriptor.this.hashFunctionGeneratorFactories).createPartitioner(0);
                }

                public void open() throws HyracksDataException {
                    if (OptimizedHybridHashJoinOperatorDescriptor.this.memsize <= 2) {
                        throw new HyracksDataException("not enough memory for Hybrid Hash Join");
                    }
                    this.state.memForJoin = OptimizedHybridHashJoinOperatorDescriptor.this.memsize - 2;
                    this.state.numOfPartitions = OptimizedHybridHashJoinOperatorDescriptor.this.getNumberOfPartitions(this.state.memForJoin, OptimizedHybridHashJoinOperatorDescriptor.this.inputsize0, OptimizedHybridHashJoinOperatorDescriptor.this.fudgeFactor, nPartitions);
                    if (!OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter) {
                        this.state.hybridHJ = new OptimizedHybridHashJoin(ctx, this.state.memForJoin, this.state.numOfPartitions, OptimizedHybridHashJoinOperatorDescriptor.PROBE_REL, OptimizedHybridHashJoinOperatorDescriptor.BUILD_REL, OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys, OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys, comparators, probeRd, buildRd, this.probeHpc, this.buildHpc, predEvaluator);
                    } else {
                        this.state.hybridHJ = new OptimizedHybridHashJoin(ctx, this.state.memForJoin, this.state.numOfPartitions, OptimizedHybridHashJoinOperatorDescriptor.PROBE_REL, OptimizedHybridHashJoinOperatorDescriptor.BUILD_REL, OptimizedHybridHashJoinOperatorDescriptor.this.probeKeys, OptimizedHybridHashJoinOperatorDescriptor.this.buildKeys, comparators, probeRd, buildRd, this.probeHpc, this.buildHpc, predEvaluator, OptimizedHybridHashJoinOperatorDescriptor.this.isLeftOuter, OptimizedHybridHashJoinOperatorDescriptor.this.nullWriterFactories1);
                    }
                    this.state.hybridHJ.initBuild();
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.state.hybridHJ.build(buffer);
                }

                public void close() throws HyracksDataException {
                    this.state.hybridHJ.closeBuild();
                    ctx.setStateObject((IStateObject)this.state);
                    LOGGER.fine("OptimizedHybridHashJoin closed its build phase");
                }

                public void fail() throws HyracksDataException {
                }
            };
            return op;
        }
    }

    public static class BuildAndPartitionTaskState
    extends AbstractStateObject {
        private int memForJoin;
        private int numOfPartitions;
        private OptimizedHybridHashJoin hybridHJ;

        public BuildAndPartitionTaskState() {
        }

        private BuildAndPartitionTaskState(JobId jobId, TaskId taskId) {
            super(jobId, taskId);
        }

        public void toBytes(DataOutput out) throws IOException {
        }

        public void fromBytes(DataInput in) throws IOException {
        }
    }
}

