/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.join;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriter;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriterFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IPredicateEvaluator;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputer;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTuplePairComparator;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileReader;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileWriter;
import edu.uci.ics.hyracks.dataflow.std.join.InMemoryHashJoin;
import edu.uci.ics.hyracks.dataflow.std.structures.SerializableHashTable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;

public class OptimizedHybridHashJoin {
    private final int NO_MORE_FREE_BUFFER = -1;
    private final int END_OF_PARTITION = -1;
    private final int INVALID_BUFFER = -2;
    private final int UNALLOCATED_FRAME = -3;
    private final int BUFFER_FOR_RESIDENT_PARTS = -1;
    private IHyracksTaskContext ctx;
    private final String rel0Name;
    private final String rel1Name;
    private final int[] buildKeys;
    private final int[] probeKeys;
    private final IBinaryComparator[] comparators;
    private ITuplePartitionComputer buildHpc;
    private ITuplePartitionComputer probeHpc;
    private final RecordDescriptor buildRd;
    private final RecordDescriptor probeRd;
    private RunFileWriter[] buildRFWriters;
    private RunFileWriter[] probeRFWriters;
    private final IPredicateEvaluator predEvaluator;
    private final boolean isLeftOuter;
    private final INullWriter[] nullWriters1;
    private ByteBuffer[] memBuffs;
    private int[] curPBuff;
    private int[] nextBuff;
    private int[] buildPSizeInTups;
    private int[] probePSizeInTups;
    private int nextFreeBuffIx;
    private BitSet pStatus;
    private int numOfPartitions;
    private int memForJoin;
    private InMemoryHashJoin inMemJoiner;
    private final FrameTupleAccessor accessorBuild;
    private final FrameTupleAccessor accessorProbe;
    private FrameTupleAppender buildTupAppender;
    private FrameTupleAppender probeTupAppenderToResident;
    private FrameTupleAppender probeTupAppenderToSpilled;
    private int numOfSpilledParts;
    private ByteBuffer[] sPartBuffs;
    private ByteBuffer probeResBuff;
    private ByteBuffer reloadBuffer;
    private int[] buildPSizeInFrames;
    private int freeFramesCounter;
    private boolean isTableEmpty;
    private boolean isReversed;

    public OptimizedHybridHashJoin(IHyracksTaskContext ctx, int memForJoin, int numOfPartitions, String rel0Name, String rel1Name, int[] keys0, int[] keys1, IBinaryComparator[] comparators, RecordDescriptor buildRd, RecordDescriptor probeRd, ITuplePartitionComputer probeHpc, ITuplePartitionComputer buildHpc, IPredicateEvaluator predEval) {
        this.ctx = ctx;
        this.memForJoin = memForJoin;
        this.buildRd = buildRd;
        this.probeRd = probeRd;
        this.buildHpc = buildHpc;
        this.probeHpc = probeHpc;
        this.buildKeys = keys1;
        this.probeKeys = keys0;
        this.comparators = comparators;
        this.rel0Name = rel0Name;
        this.rel1Name = rel1Name;
        this.numOfPartitions = numOfPartitions;
        this.buildRFWriters = new RunFileWriter[numOfPartitions];
        this.probeRFWriters = new RunFileWriter[numOfPartitions];
        this.accessorBuild = new FrameTupleAccessor(ctx.getFrameSize(), buildRd);
        this.accessorProbe = new FrameTupleAccessor(ctx.getFrameSize(), probeRd);
        this.predEvaluator = predEval;
        this.isLeftOuter = false;
        this.nullWriters1 = null;
        this.isReversed = false;
    }

    public OptimizedHybridHashJoin(IHyracksTaskContext ctx, int memForJoin, int numOfPartitions, String rel0Name, String rel1Name, int[] keys0, int[] keys1, IBinaryComparator[] comparators, RecordDescriptor buildRd, RecordDescriptor probeRd, ITuplePartitionComputer probeHpc, ITuplePartitionComputer buildHpc, IPredicateEvaluator predEval, boolean isLeftOuter, INullWriterFactory[] nullWriterFactories1) {
        this.ctx = ctx;
        this.memForJoin = memForJoin;
        this.buildRd = buildRd;
        this.probeRd = probeRd;
        this.buildHpc = buildHpc;
        this.probeHpc = probeHpc;
        this.buildKeys = keys1;
        this.probeKeys = keys0;
        this.comparators = comparators;
        this.rel0Name = rel0Name;
        this.rel1Name = rel1Name;
        this.numOfPartitions = numOfPartitions;
        this.buildRFWriters = new RunFileWriter[numOfPartitions];
        this.probeRFWriters = new RunFileWriter[numOfPartitions];
        this.accessorBuild = new FrameTupleAccessor(ctx.getFrameSize(), buildRd);
        this.accessorProbe = new FrameTupleAccessor(ctx.getFrameSize(), probeRd);
        this.predEvaluator = predEval;
        this.isLeftOuter = isLeftOuter;
        this.isReversed = false;
        INullWriter[] iNullWriterArray = this.nullWriters1 = isLeftOuter ? new INullWriter[nullWriterFactories1.length] : null;
        if (isLeftOuter) {
            for (int i = 0; i < nullWriterFactories1.length; ++i) {
                this.nullWriters1[i] = nullWriterFactories1[i].createNullWriter();
            }
        }
    }

    public void initBuild() throws HyracksDataException {
        int i;
        this.memBuffs = new ByteBuffer[this.memForJoin];
        this.curPBuff = new int[this.numOfPartitions];
        this.nextBuff = new int[this.memForJoin];
        this.pStatus = new BitSet(this.numOfPartitions);
        this.buildPSizeInTups = new int[this.numOfPartitions];
        this.buildPSizeInFrames = new int[this.numOfPartitions];
        this.freeFramesCounter = this.memForJoin - this.numOfPartitions;
        for (i = 0; i < this.numOfPartitions; ++i) {
            this.memBuffs[i] = this.ctx.allocateFrame();
            this.curPBuff[i] = i;
            this.nextBuff[i] = -1;
            this.buildPSizeInFrames[i] = 1;
        }
        this.nextFreeBuffIx = this.numOfPartitions < this.memForJoin ? this.numOfPartitions : -1;
        for (i = this.numOfPartitions; i < this.memBuffs.length; ++i) {
            this.nextBuff[i] = -3;
        }
        this.buildTupAppender = new FrameTupleAppender(this.ctx.getFrameSize());
    }

    public void build(ByteBuffer buffer) throws HyracksDataException {
        this.accessorBuild.reset(buffer);
        int tupleCount = this.accessorBuild.getTupleCount();
        boolean print = false;
        if (print) {
            this.accessorBuild.prettyPrint();
        }
        for (int i = 0; i < tupleCount; ++i) {
            int pid = this.buildHpc.partition((IFrameTupleAccessor)this.accessorBuild, i, this.numOfPartitions);
            this.processTuple(i, pid);
            int n = pid;
            this.buildPSizeInTups[n] = this.buildPSizeInTups[n] + 1;
        }
    }

    private void processTuple(int tid, int pid) throws HyracksDataException {
        ByteBuffer partition = this.memBuffs[this.curPBuff[pid]];
        if (!this.pStatus.get(pid)) {
            this.buildTupAppender.reset(partition, false);
            if (!this.buildTupAppender.append((IFrameTupleAccessor)this.accessorBuild, tid)) {
                int newBuffIx = this.allocateFreeBuffer(pid);
                if (newBuffIx == -1) {
                    int pidToSpill = this.selectPartitionToSpill();
                    if (pidToSpill == -1) {
                        throw new HyracksDataException("not enough memory for Hash Join (Allocation exceeds the limit)");
                    }
                    this.spillPartition(pidToSpill);
                    this.buildTupAppender.reset(this.memBuffs[pidToSpill], true);
                    this.processTuple(tid, pid);
                } else {
                    partition = this.memBuffs[this.curPBuff[pid]];
                    this.buildTupAppender.reset(partition, true);
                    if (!this.buildTupAppender.append((IFrameTupleAccessor)this.accessorBuild, tid)) {
                        throw new HyracksDataException("Invalid State (Can not append to newly allocated buffer)");
                    }
                    int n = pid;
                    this.buildPSizeInFrames[n] = this.buildPSizeInFrames[n] + 1;
                }
            }
        } else {
            boolean needClear = false;
            while (true) {
                this.buildTupAppender.reset(partition, needClear);
                if (this.buildTupAppender.append((IFrameTupleAccessor)this.accessorBuild, tid)) break;
                this.buildWrite(pid, partition);
                partition.clear();
                needClear = true;
                int n = pid;
                this.buildPSizeInFrames[n] = this.buildPSizeInFrames[n] + 1;
            }
        }
    }

    private int allocateFreeBuffer(int pid) throws HyracksDataException {
        if (this.nextFreeBuffIx != -1) {
            if (this.memBuffs[this.nextFreeBuffIx] == null) {
                this.memBuffs[this.nextFreeBuffIx] = this.ctx.allocateFrame();
            }
            int curPartBuffIx = this.curPBuff[pid];
            this.curPBuff[pid] = this.nextFreeBuffIx;
            int oldNext = this.nextBuff[this.nextFreeBuffIx];
            this.nextBuff[this.nextFreeBuffIx] = curPartBuffIx;
            if (oldNext == -3) {
                ++this.nextFreeBuffIx;
                if (this.nextFreeBuffIx == this.memForJoin) {
                    this.nextFreeBuffIx = -1;
                }
            } else {
                this.nextFreeBuffIx = oldNext;
            }
            this.memBuffs[this.curPBuff[pid]].clear();
            --this.freeFramesCounter;
            return this.curPBuff[pid];
        }
        return -1;
    }

    private int selectPartitionToSpill() {
        int maxSize = -1;
        int partitionToSpill = -1;
        for (int i = 0; i < this.buildPSizeInTups.length; ++i) {
            if (this.pStatus.get(i) || this.buildPSizeInTups[i] <= maxSize) continue;
            maxSize = this.buildPSizeInTups[i];
            partitionToSpill = i;
        }
        return partitionToSpill;
    }

    private void spillPartition(int pid) throws HyracksDataException {
        int curBuffIx = this.curPBuff[pid];
        ByteBuffer buff = null;
        while (curBuffIx != -1) {
            buff = this.memBuffs[curBuffIx];
            this.buildWrite(pid, buff);
            buff.clear();
            int freedBuffIx = curBuffIx;
            curBuffIx = this.nextBuff[curBuffIx];
            if (freedBuffIx == pid) continue;
            this.nextBuff[freedBuffIx] = this.nextFreeBuffIx;
            this.nextFreeBuffIx = freedBuffIx;
            ++this.freeFramesCounter;
        }
        this.curPBuff[pid] = pid;
        this.pStatus.set(pid);
    }

    private void buildWrite(int pid, ByteBuffer buff) throws HyracksDataException {
        RunFileWriter writer = this.buildRFWriters[pid];
        if (writer == null) {
            FileReference file = this.ctx.getJobletContext().createManagedWorkspaceFile(this.rel0Name);
            writer = new RunFileWriter(file, this.ctx.getIOManager());
            writer.open();
            this.buildRFWriters[pid] = writer;
        }
        writer.nextFrame(buff);
    }

    public void closeBuild() throws HyracksDataException {
        for (int i = 0; i < this.numOfPartitions; ++i) {
            if (this.buildPSizeInTups[i] != 0) continue;
            int n = i;
            this.buildPSizeInFrames[n] = this.buildPSizeInFrames[n] - 1;
            this.nextBuff[this.curPBuff[i]] = this.nextFreeBuffIx;
            this.nextFreeBuffIx = this.curPBuff[i];
            this.curPBuff[i] = -2;
            ++this.freeFramesCounter;
        }
        ByteBuffer buff = null;
        int i = this.pStatus.nextSetBit(0);
        while (i >= 0) {
            buff = this.memBuffs[i];
            this.accessorBuild.reset(buff);
            if (this.accessorBuild.getTupleCount() > 0) {
                this.buildWrite(i, buff);
                int n = i;
                this.buildPSizeInFrames[n] = this.buildPSizeInFrames[n] + 1;
            }
            this.nextBuff[i] = this.nextFreeBuffIx;
            this.nextFreeBuffIx = i;
            ++this.freeFramesCounter;
            this.curPBuff[i] = -2;
            if (this.buildRFWriters[i] != null) {
                this.buildRFWriters[i].close();
            }
            i = this.pStatus.nextSetBit(i + 1);
        }
        this.partitionTune();
        int inMemTupCount = 0;
        this.numOfSpilledParts = 0;
        for (int i2 = 0; i2 < this.numOfPartitions; ++i2) {
            if (!this.pStatus.get(i2)) {
                inMemTupCount += this.buildPSizeInTups[i2];
                continue;
            }
            ++this.numOfSpilledParts;
        }
        this.createInMemoryJoiner(inMemTupCount);
        this.cacheInMemJoin();
        this.isTableEmpty = inMemTupCount == 0;
    }

    private void partitionTune() throws HyracksDataException {
        this.reloadBuffer = this.ctx.allocateFrame();
        ArrayList<Integer> reloadSet = this.selectPartitionsToReload();
        for (int i = 0; i < reloadSet.size(); ++i) {
            int pid = reloadSet.get(i);
            int[] buffsToLoad = new int[this.buildPSizeInFrames[pid]];
            for (int j = 0; j < buffsToLoad.length; ++j) {
                buffsToLoad[j] = this.nextFreeBuffIx;
                int oldNext = this.nextBuff[this.nextFreeBuffIx];
                if (oldNext == -3) {
                    ++this.nextFreeBuffIx;
                    if (this.nextFreeBuffIx != this.memForJoin) continue;
                    this.nextFreeBuffIx = -1;
                    continue;
                }
                this.nextFreeBuffIx = oldNext;
            }
            this.curPBuff[pid] = buffsToLoad[0];
            for (int k = 1; k < buffsToLoad.length; ++k) {
                this.nextBuff[buffsToLoad[k - 1]] = buffsToLoad[k];
            }
            this.loadPartitionInMem(pid, this.buildRFWriters[pid], buffsToLoad);
        }
        reloadSet.clear();
        reloadSet = null;
    }

    private void loadPartitionInMem(int pid, RunFileWriter wr, int[] buffs) throws HyracksDataException {
        RunFileReader r = wr.createReader();
        r.open();
        int counter = 0;
        ByteBuffer mBuff = null;
        this.reloadBuffer.clear();
        while (r.nextFrame(this.reloadBuffer)) {
            mBuff = this.memBuffs[buffs[counter]];
            if (mBuff == null) {
                this.memBuffs[buffs[counter]] = mBuff = this.ctx.allocateFrame();
            }
            FrameUtils.copy((ByteBuffer)this.reloadBuffer, (ByteBuffer)mBuff);
            ++counter;
            this.reloadBuffer.clear();
        }
        int curNext = this.nextBuff[buffs[buffs.length - 1]];
        this.nextBuff[buffs[buffs.length - 1]] = -1;
        this.nextFreeBuffIx = curNext;
        r.close();
        this.pStatus.set(pid, false);
        this.buildRFWriters[pid] = null;
    }

    private ArrayList<Integer> selectPartitionsToReload() {
        ArrayList<Integer> p = new ArrayList<Integer>();
        int i = this.pStatus.nextSetBit(0);
        while (i >= 0) {
            if (this.buildPSizeInFrames[i] > 0 && this.freeFramesCounter - this.buildPSizeInFrames[i] >= 0) {
                p.add(i);
                this.freeFramesCounter -= this.buildPSizeInFrames[i];
            }
            if (this.freeFramesCounter < 1) {
                return p;
            }
            i = this.pStatus.nextSetBit(i + 1);
        }
        return p;
    }

    private void createInMemoryJoiner(int inMemTupCount) throws HyracksDataException {
        SerializableHashTable table = new SerializableHashTable(inMemTupCount, this.ctx);
        this.inMemJoiner = new InMemoryHashJoin(this.ctx, inMemTupCount, new FrameTupleAccessor(this.ctx.getFrameSize(), this.probeRd), this.probeHpc, new FrameTupleAccessor(this.ctx.getFrameSize(), this.buildRd), this.buildHpc, new FrameTuplePairComparator(this.probeKeys, this.buildKeys, this.comparators), this.isLeftOuter, this.nullWriters1, table, this.predEvaluator, this.isReversed);
    }

    private void cacheInMemJoin() throws HyracksDataException {
        for (int pid = 0; pid < this.numOfPartitions; ++pid) {
            if (this.pStatus.get(pid)) continue;
            int nextBuffIx = this.curPBuff[pid];
            while (nextBuffIx > -1) {
                this.inMemJoiner.build(this.memBuffs[nextBuffIx]);
                nextBuffIx = this.nextBuff[nextBuffIx];
            }
        }
    }

    public void initProbe() throws HyracksDataException {
        this.sPartBuffs = new ByteBuffer[this.numOfSpilledParts];
        for (int i = 0; i < this.numOfSpilledParts; ++i) {
            this.sPartBuffs[i] = this.ctx.allocateFrame();
        }
        this.curPBuff = new int[this.numOfPartitions];
        int nextBuffIxToAlloc = 0;
        for (int i = 0; i < this.numOfPartitions; ++i) {
            this.curPBuff[i] = this.pStatus.get(i) ? nextBuffIxToAlloc++ : -1;
        }
        this.probePSizeInTups = new int[this.numOfPartitions];
        this.probeRFWriters = new RunFileWriter[this.numOfPartitions];
        this.probeResBuff = this.ctx.allocateFrame();
        this.probeTupAppenderToResident = new FrameTupleAppender(this.ctx.getFrameSize());
        this.probeTupAppenderToResident.reset(this.probeResBuff, true);
        this.probeTupAppenderToSpilled = new FrameTupleAppender(this.ctx.getFrameSize());
    }

    public void probe(ByteBuffer buffer, IFrameWriter writer) throws HyracksDataException {
        this.accessorProbe.reset(buffer);
        int tupleCount = this.accessorProbe.getTupleCount();
        boolean print = false;
        if (print) {
            this.accessorProbe.prettyPrint();
        }
        if (this.numOfSpilledParts == 0) {
            this.inMemJoiner.join(buffer, writer);
            return;
        }
        for (int i = 0; i < tupleCount; ++i) {
            int pid = this.probeHpc.partition((IFrameTupleAccessor)this.accessorProbe, i, this.numOfPartitions);
            if (this.buildPSizeInTups[pid] <= 0) continue;
            if (this.pStatus.get(pid)) {
                boolean needToClear = false;
                ByteBuffer buff = this.sPartBuffs[this.curPBuff[pid]];
                while (true) {
                    this.probeTupAppenderToSpilled.reset(buff, needToClear);
                    if (!this.probeTupAppenderToSpilled.append((IFrameTupleAccessor)this.accessorProbe, i)) {
                        this.probeWrite(pid, buff);
                        buff.clear();
                        needToClear = true;
                        continue;
                    }
                    break;
                }
            } else {
                while (!this.probeTupAppenderToResident.append((IFrameTupleAccessor)this.accessorProbe, i)) {
                    this.inMemJoiner.join(this.probeResBuff, writer);
                    this.probeTupAppenderToResident.reset(this.probeResBuff, true);
                }
            }
            int n = pid;
            this.probePSizeInTups[n] = this.probePSizeInTups[n] + 1;
        }
    }

    public void closeProbe(IFrameWriter writer) throws HyracksDataException {
        this.inMemJoiner.join(this.probeResBuff, writer);
        this.inMemJoiner.closeJoin(writer);
        int pid = this.pStatus.nextSetBit(0);
        while (pid >= 0) {
            ByteBuffer buff = this.sPartBuffs[this.curPBuff[pid]];
            this.accessorProbe.reset(buff);
            if (this.accessorProbe.getTupleCount() > 0) {
                this.probeWrite(pid, buff);
            }
            this.closeProbeWriter(pid);
            pid = this.pStatus.nextSetBit(pid + 1);
        }
    }

    private void probeWrite(int pid, ByteBuffer buff) throws HyracksDataException {
        RunFileWriter pWriter = this.probeRFWriters[pid];
        if (pWriter == null) {
            FileReference file = this.ctx.getJobletContext().createManagedWorkspaceFile(this.rel1Name);
            pWriter = new RunFileWriter(file, this.ctx.getIOManager());
            pWriter.open();
            this.probeRFWriters[pid] = pWriter;
        }
        pWriter.nextFrame(buff);
    }

    private void closeProbeWriter(int pid) throws HyracksDataException {
        RunFileWriter writer = this.probeRFWriters[pid];
        if (writer != null) {
            writer.close();
        }
    }

    public RunFileReader getBuildRFReader(int pid) throws HyracksDataException {
        return this.buildRFWriters[pid] == null ? null : this.buildRFWriters[pid].createReader();
    }

    public long getBuildPartitionSize(int pid) {
        return this.buildRFWriters[pid] == null ? 0L : this.buildRFWriters[pid].getFileSize();
    }

    public int getBuildPartitionSizeInTup(int pid) {
        return this.buildPSizeInTups[pid];
    }

    public RunFileReader getProbeRFReader(int pid) throws HyracksDataException {
        return this.probeRFWriters[pid] == null ? null : this.probeRFWriters[pid].createReader();
    }

    public long getProbePartitionSize(int pid) {
        return this.probeRFWriters[pid] == null ? 0L : this.probeRFWriters[pid].getFileSize();
    }

    public int getProbePartitionSizeInTup(int pid) {
        return this.probePSizeInTups[pid];
    }

    public int getMaxBuildPartitionSize() {
        int max = this.buildPSizeInTups[0];
        for (int i = 1; i < this.buildPSizeInTups.length; ++i) {
            if (this.buildPSizeInTups[i] <= max) continue;
            max = this.buildPSizeInTups[i];
        }
        return max;
    }

    public int getMaxProbePartitionSize() {
        int max = this.probePSizeInTups[0];
        for (int i = 1; i < this.probePSizeInTups.length; ++i) {
            if (this.probePSizeInTups[i] <= max) continue;
            max = this.probePSizeInTups[i];
        }
        return max;
    }

    public BitSet getPartitinStatus() {
        return this.pStatus;
    }

    public String debugGetStats() {
        int numOfResidentPartitions = 0;
        int numOfSpilledPartitions = 0;
        double sumOfBuildSpilledSizes = 0.0;
        double sumOfProbeSpilledSizes = 0.0;
        int numOfInMemTups = 0;
        for (int i = 0; i < this.numOfPartitions; ++i) {
            if (this.pStatus.get(i)) {
                ++numOfSpilledPartitions;
                sumOfBuildSpilledSizes += (double)this.buildPSizeInTups[i];
                sumOfProbeSpilledSizes += (double)this.probePSizeInTups[i];
                continue;
            }
            ++numOfResidentPartitions;
            numOfInMemTups += this.buildPSizeInTups[i];
        }
        double avgBuildSpSz = sumOfBuildSpilledSizes / (double)numOfSpilledPartitions;
        double avgProbeSpSz = sumOfProbeSpilledSizes / (double)numOfSpilledPartitions;
        String s = "Resident Partitions:\t" + numOfResidentPartitions + "\nSpilled Partitions:\t" + numOfSpilledPartitions + "\nAvg Build Spilled Size:\t" + avgBuildSpSz + "\nAvg Probe Spilled Size:\t" + avgProbeSpSz + "\nIn-Memory Tups:\t" + numOfInMemTups + "\nNum of Free Buffers:\t" + this.freeFramesCounter;
        return s;
    }

    public boolean isTableEmpty() {
        return this.isTableEmpty;
    }

    public void setIsReversed(boolean b) {
        this.isReversed = b;
    }
}

