/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.join;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.IActivity;
import edu.uci.ics.hyracks.api.dataflow.IActivityGraphBuilder;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.TaskId;
import edu.uci.ics.hyracks.api.dataflow.state.IStateObject;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriter;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriterFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IPredicateEvaluator;
import edu.uci.ics.hyracks.api.dataflow.value.IPredicateEvaluatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePairComparator;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePairComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractActivityNode;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractStateObject;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.join.NestedLoopJoin;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class NestedLoopJoinOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final int JOIN_CACHE_ACTIVITY_ID = 0;
    private static final int NL_JOIN_ACTIVITY_ID = 1;
    private static final long serialVersionUID = 1L;
    private final ITuplePairComparatorFactory comparatorFactory;
    private final int memSize;
    private final IPredicateEvaluatorFactory predEvaluatorFactory;
    private final boolean isLeftOuter;
    private final INullWriterFactory[] nullWriterFactories1;

    public NestedLoopJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, ITuplePairComparatorFactory comparatorFactory, RecordDescriptor recordDescriptor, int memSize, boolean isLeftOuter, INullWriterFactory[] nullWriterFactories1) {
        this(spec, comparatorFactory, recordDescriptor, memSize, null, isLeftOuter, nullWriterFactories1);
    }

    public NestedLoopJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, ITuplePairComparatorFactory comparatorFactory, RecordDescriptor recordDescriptor, int memSize, IPredicateEvaluatorFactory predEvalFactory, boolean isLeftOuter, INullWriterFactory[] nullWriterFactories1) {
        super(spec, 2, 1);
        this.comparatorFactory = comparatorFactory;
        this.recordDescriptors[0] = recordDescriptor;
        this.memSize = memSize;
        this.predEvaluatorFactory = predEvalFactory;
        this.isLeftOuter = isLeftOuter;
        this.nullWriterFactories1 = nullWriterFactories1;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        ActivityId jcaId = new ActivityId(this.getOperatorId(), 0);
        ActivityId nljAid = new ActivityId(this.getOperatorId(), 1);
        JoinCacheActivityNode jc = new JoinCacheActivityNode(jcaId, nljAid);
        NestedLoopJoinActivityNode nlj = new NestedLoopJoinActivityNode(nljAid);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)jc);
        builder.addSourceEdge(1, (IActivity)jc, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)nlj);
        builder.addSourceEdge(0, (IActivity)nlj, 0);
        builder.addTargetEdge(0, (IActivity)nlj, 0);
        builder.addBlockingEdge((IActivity)jc, (IActivity)nlj);
    }

    private class NestedLoopJoinActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public NestedLoopJoinActivityNode(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            AbstractUnaryInputUnaryOutputOperatorNodePushable op = new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
                private JoinCacheTaskState state;

                public void open() throws HyracksDataException {
                    this.state = (JoinCacheTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(NestedLoopJoinOperatorDescriptor.this.getOperatorId(), 0), partition));
                    this.writer.open();
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.state.joiner.join(buffer, this.writer);
                }

                public void close() throws HyracksDataException {
                    this.state.joiner.closeJoin(this.writer);
                    this.writer.close();
                }

                public void fail() throws HyracksDataException {
                    this.writer.fail();
                }
            };
            return op;
        }
    }

    private class JoinCacheActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;
        private final ActivityId nljAid;

        public JoinCacheActivityNode(ActivityId id, ActivityId nljAid) {
            super(id);
            this.nljAid = nljAid;
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            INullWriter[] nullWriters1;
            final RecordDescriptor rd0 = recordDescProvider.getInputRecordDescriptor(this.nljAid, 0);
            final RecordDescriptor rd1 = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0);
            final ITuplePairComparator comparator = NestedLoopJoinOperatorDescriptor.this.comparatorFactory.createTuplePairComparator(ctx);
            final IPredicateEvaluator predEvaluator = NestedLoopJoinOperatorDescriptor.this.predEvaluatorFactory != null ? NestedLoopJoinOperatorDescriptor.this.predEvaluatorFactory.createPredicateEvaluator() : null;
            INullWriter[] iNullWriterArray = nullWriters1 = NestedLoopJoinOperatorDescriptor.this.isLeftOuter ? new INullWriter[NestedLoopJoinOperatorDescriptor.this.nullWriterFactories1.length] : null;
            if (NestedLoopJoinOperatorDescriptor.this.isLeftOuter) {
                for (int i = 0; i < NestedLoopJoinOperatorDescriptor.this.nullWriterFactories1.length; ++i) {
                    nullWriters1[i] = NestedLoopJoinOperatorDescriptor.this.nullWriterFactories1[i].createNullWriter();
                }
            }
            AbstractUnaryInputSinkOperatorNodePushable op = new AbstractUnaryInputSinkOperatorNodePushable(){
                private JoinCacheTaskState state;

                public void open() throws HyracksDataException {
                    this.state = new JoinCacheTaskState(ctx.getJobletContext().getJobId(), new TaskId(JoinCacheActivityNode.this.getActivityId(), partition));
                    this.state.joiner = new NestedLoopJoin(ctx, new FrameTupleAccessor(ctx.getFrameSize(), rd0), new FrameTupleAccessor(ctx.getFrameSize(), rd1), comparator, NestedLoopJoinOperatorDescriptor.this.memSize, predEvaluator, NestedLoopJoinOperatorDescriptor.this.isLeftOuter, nullWriters1);
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    ByteBuffer copyBuffer = ctx.allocateFrame();
                    FrameUtils.copy((ByteBuffer)buffer, (ByteBuffer)copyBuffer);
                    FrameUtils.makeReadable((ByteBuffer)copyBuffer);
                    this.state.joiner.cache(copyBuffer);
                }

                public void close() throws HyracksDataException {
                    this.state.joiner.closeCache();
                    ctx.setStateObject((IStateObject)this.state);
                }

                public void fail() throws HyracksDataException {
                }
            };
            return op;
        }
    }

    public static class JoinCacheTaskState
    extends AbstractStateObject {
        private NestedLoopJoin joiner;

        public JoinCacheTaskState() {
        }

        private JoinCacheTaskState(JobId jobId, TaskId taskId) {
            super(jobId, taskId);
        }

        public void toBytes(DataOutput out) throws IOException {
        }

        public void fromBytes(DataInput in) throws IOException {
        }
    }
}

